/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEServiceFormLine
extends Panel
implements LEFormLine,
ActionListener,
ItemListener,
MouseListener {
    public static final String NETDATA = new String("netdata");
    public static final String PORTMASTER = new String("portmaster");
    public static final String RLOGIN = new String("rlogin");
    public static final String TELNET = new String("telnet");
    static final String VALID = new String("netdata (0-65535), portmaster, rlogin, telnet (0-65535)");
    Choice m_service;
    LETextField m_tport;
    LEFormLineListener m_listener;

    public LEServiceFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_service = new Choice();
        this.add(this.m_service);
        this.m_service.add(NETDATA);
        this.m_service.add(PORTMASTER);
        this.m_service.add(RLOGIN);
        this.m_service.add(TELNET);
        this.m_service.addItemListener(this);
        this.m_tport = new LETextField(5);
        this.add(this.m_tport);
        this.m_tport.setNumeric(true);
        this.m_tport.addActionListener(this);
        this.addMouseListener(this);
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void itemStateChanged(ItemEvent event) {
        String service = (String)event.getItem();
        if (service.equals(NETDATA) || service.equals(TELNET)) {
            this.m_tport.setEnabled(true);
        } else {
            this.m_tport.setEnabled(false);
        }
        this.notifyListener();
    }

    public void actionPerformed(ActionEvent event) {
        this.notifyListener();
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
    }

    public void setValue(Object field) {
        String str = field.toString();
        String tport = null;
        int sep = str.indexOf(64);
        if (sep > -1) {
            tport = str.substring(sep + 1, str.length());
            str = str.substring(0, sep);
        }
        int count = this.m_service.getItemCount();
        int index = 0;
        int i = 0;
        while (i < count) {
            if (str.equalsIgnoreCase(this.m_service.getItem(i))) {
                index = i;
            }
            ++i;
        }
        this.m_service.select(index);
        if (str.equalsIgnoreCase(NETDATA) || str.equalsIgnoreCase(TELNET)) {
            this.m_tport.setEnabled(true);
            if (tport != null) {
                ((TextComponent)this.m_tport).setText(tport);
            } else {
                ((TextComponent)this.m_tport).setText("0");
            }
        } else {
            this.m_tport.setEnabled(false);
        }
    }

    public String getValue() {
        String tport;
        String item = this.m_service.getSelectedItem();
        StringBuffer buf = new StringBuffer(item);
        if ((item.equals(NETDATA) || item.equals(TELNET)) && (tport = this.m_tport.getText()).length() > 0) {
            buf.append('@');
            int port = 0;
            try {
                port = Integer.parseInt(tport);
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
            port = Math.max(port, 0);
            port = Math.min(port, 65535);
            buf.append(Integer.toString(port));
        }
        return new String(buf);
    }

    public String getValidValues() {
        return VALID;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String val = this.getValue();
            return val.equalsIgnoreCase(oldVal);
        }
        return false;
    }

    public boolean isValueValid() {
        block3: {
            String tport;
            String item = this.m_service.getSelectedItem();
            if (!item.equals(NETDATA) && !item.equals(TELNET) || (tport = this.m_tport.getText()).length() <= 0) break block3;
            int port = 0;
            try {
                port = Integer.parseInt(tport);
                if (port < 0 || port > 65535) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        return true;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent event = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(event);
        }
    }
}

