/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LESlotStreamFormLine
extends Panel
implements LEFormLine,
MouseListener,
KeyListener,
ActionListener {
    LEFormLineListener m_listener;
    String m_valid;
    LETextField m_slot;
    LETextField m_stream;

    public LESlotStreamFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_slot = new LETextField(1);
        this.add(this.m_slot);
        this.add(new Label(":", 1));
        this.m_stream = new LETextField(2);
        this.add(this.m_stream);
        this.addMouseListener(this);
        this.m_slot.setNumeric(true);
        this.m_slot.addKeyListener(this);
        this.m_slot.addActionListener(this);
        this.m_stream.setNumeric(true);
        this.m_stream.addActionListener(this);
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        int pos;
        String val = field.toString();
        if (val.length() > 0 && (pos = val.indexOf(58)) > 0) {
            ((TextComponent)this.m_slot).setText(val.substring(0, pos));
            ((TextComponent)this.m_stream).setText(val.substring(pos + 1));
        }
    }

    public String getValue() {
        StringBuffer buf = new StringBuffer();
        String str = this.m_slot.getText();
        if (str.length() == 0) {
            buf.append("0");
        } else {
            buf.append(str);
        }
        buf.append(":");
        str = this.m_stream.getText();
        if (str.length() == 0) {
            buf.append("0");
        } else {
            buf.append(str);
        }
        return buf.toString();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            this.m_valid = new String("0-9:0-30");
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String newVal = this.getValue();
            return newVal.equals(oldVal);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyChar() == ':') {
            this.m_stream.requestFocus();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        this.notifyListener();
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent event = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(event);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }
}

