/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.forms.LEStringFormLine;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEOctets;
import java.awt.event.MouseEvent;

public class LESourceSpecFormLine
extends LEStringFormLine {
    static final String VALID = "0.0.0.0/0 - 255.255.255.255/32 or =ListName";
    LEFormLineListener m_listener;

    public String getValidValues() {
        return VALID;
    }

    public boolean isValueValid() {
        String val = this.getValue();
        int len = val.length();
        if (len > 0) {
            int ptr = 0;
            while (ptr < len && Character.isWhitespace(val.charAt(ptr))) {
                ++ptr;
            }
            if (ptr < len && val.charAt(ptr) == '=') {
                if (ptr == len - 1) {
                    return false;
                }
            } else if (ptr < len) {
                return this.validAddress(val);
            }
        }
        return true;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    boolean validAddress(String val) {
        int index = val.indexOf("/");
        if (index == -1) {
            return false;
        }
        int len = val.length();
        if (index == len - 1) {
            return false;
        }
        String netmask = val.substring(index + 1, len);
        int nm = -1;
        try {
            nm = Integer.parseInt(netmask);
        }
        catch (NumberFormatException numberFormatException) {}
        if (nm < 0 || nm > 32) {
            return false;
        }
        String address = val.substring(0, index);
        LEOctets octs = new LEOctets(address);
        short[] octets = octs.getOctets();
        if (octets.length != 4) {
            return false;
        }
        String test = octs.toString();
        return test.equals(address);
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent event = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(event);
        }
    }
}

