/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class LESyslogFormLine
extends Panel
implements LEFormLine,
ItemListener {
    public static final String DISABLED = new String("disabled");
    public static final String FACILITY = new String("facility");
    public static final String PRIORITY = new String("priority");
    public static final String VALID = "";
    Checkbox m_disabled;
    Choice m_facility;
    Choice m_priority;
    LEFormLineListener m_listener;

    public LESyslogFormLine() {
        this.setLayout(new FlowLayout());
        this.m_disabled = new Checkbox("Enable");
        this.add(this.m_disabled);
        this.m_disabled.addItemListener(this);
        this.m_facility = new Choice();
        this.add(this.m_facility);
        this.m_facility.addItemListener(this);
        this.add(new Label("."));
        this.m_priority = new Choice();
        this.add(this.m_priority);
        this.m_priority.addItemListener(this);
        this.setState();
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        if (spec != null) {
            int i;
            int len;
            Vector v;
            Object obj = spec.getAttribute(FACILITY);
            if (obj instanceof Vector) {
                v = (Vector)obj;
                len = v.size();
                i = 0;
                while (i < len) {
                    this.m_facility.addItem((String)v.elementAt(i));
                    ++i;
                }
            } else if (obj instanceof String) {
                this.m_facility.addItem((String)obj);
            }
            obj = spec.getAttribute(PRIORITY);
            if (obj instanceof Vector) {
                v = (Vector)obj;
                len = v.size();
                i = 0;
                while (i < len) {
                    this.m_priority.addItem((String)v.elementAt(i));
                    ++i;
                }
            } else if (obj instanceof String) {
                this.m_priority.addItem((String)obj);
            }
        }
    }

    public void setState() {
        if (this.m_disabled.getState()) {
            this.m_facility.setEnabled(true);
            this.m_priority.setEnabled(true);
        } else {
            this.m_facility.setEnabled(false);
            this.m_priority.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        this.setState();
        if (this.m_listener != null) {
            LEFormLineEvent formEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(formEvent);
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        if (field instanceof String) {
            String value = ((String)field).toLowerCase();
            if (value.length() == 0 || value.equalsIgnoreCase(DISABLED)) {
                this.m_disabled.setState(false);
            } else {
                this.m_disabled.setState(true);
                int ptr = value.indexOf(46);
                if (ptr == -1) {
                    this.m_facility.select(value);
                    this.m_priority.select(value);
                } else {
                    this.m_facility.select(value.substring(0, ptr));
                    this.m_priority.select(value.substring(ptr + 1, value.length()));
                }
            }
        } else {
            this.m_disabled.setState(false);
        }
        this.setState();
    }

    public String getValue() {
        if (!this.m_disabled.getState()) {
            return DISABLED;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.m_facility.getSelectedItem());
        buf.append(".");
        buf.append(this.m_priority.getSelectedItem());
        return buf.toString();
    }

    public String getValidValues() {
        return VALID;
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String str = field.toString();
            String val = this.getValue();
            return val.equalsIgnoreCase(str);
        }
        return false;
    }
}

