/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEOptMultiList;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.util.Hashtable;

public class LETableForm
extends LEOptMultiList
implements LEForm,
LEObserver {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    LEPortMaster[] m_pms;
    LEVector m_context;
    String m_platform;
    LEVector m_tags = new LEVector();
    Hashtable m_objs = new Hashtable();
    int m_cols;
    boolean m_keyReadonly = false;
    boolean m_simpleTable = false;
    boolean m_renameEntries = false;

    public boolean isKeyReadonly() {
        return this.m_keyReadonly;
    }

    public boolean isSimpleTable() {
        return this.m_simpleTable;
    }

    public boolean canRenameEntries() {
        return this.m_renameEntries;
    }

    public void setContext(String platform, LEVector context) {
        LEDataSpec tmp;
        this.m_context = context;
        this.m_platform = platform;
        LEDataSpec spec = null;
        String keyDes = BLANK;
        try {
            spec = LEDataSpecFactory.GetSpec(this.m_platform);
            int len = this.m_context.size();
            int i = 0;
            while (i < len) {
                spec = spec.getSpecFor((String)this.m_context.elementAt(i));
                ++i;
            }
            LEDataSpec keySpec = spec.getSpecFor("key");
            if (keySpec.getAttribute(LEAttributes.READONLY) != null) {
                this.m_keyReadonly = true;
            }
            keyDes = keySpec.getDescription();
            LEVector specs = (spec = spec.getSpecFor("entry")).getAllSpecs();
            if (specs == null) {
                this.m_tags.addElement("entry");
                this.m_simpleTable = true;
            } else {
                len = specs.size();
                int i2 = 0;
                while (i2 < len) {
                    tmp = (LEDataSpec)specs.elementAt(i2);
                    if (tmp.getAllSpecs() == null && tmp.getAttribute(LEAttributes.WRITEONLY) == null && tmp.getAttribute(LEAttributes.INVISIBLE) == null) {
                        this.m_tags.addElement(tmp.getTag());
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.m_cols = this.m_tags.size();
        this.initialize(1, 2, this.m_cols);
        String[] titles = new String[this.m_cols + 2];
        titles[0] = PORTMASTER;
        titles[1] = keyDes;
        int i = 0;
        while (i < this.m_cols) {
            if (this.m_simpleTable) {
                tmp = spec;
            } else {
                String tag = (String)this.m_tags.elementAt(i);
                tmp = spec.getSpecFor(tag);
            }
            titles[i + 2] = tmp.getDescription();
            ++i;
        }
        this.setTitles(0, titles);
    }

    public void setPortMasters(LEPortMaster[] pms) {
        int j;
        boolean found;
        int i;
        if (this.m_pms != null) {
            i = 0;
            while (i < this.m_pms.length) {
                found = false;
                j = 0;
                while (!found && j < pms.length) {
                    if (this.m_pms[i] == pms[j]) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.removePortMaster(this.m_pms[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < pms.length) {
            found = false;
            if (this.m_pms != null) {
                j = 0;
                while (!found && j < this.m_pms.length) {
                    if (pms[i] == this.m_pms[j]) {
                        found = true;
                    }
                    ++j;
                }
            }
            if (!found) {
                this.addPortMaster(pms[i]);
            }
            ++i;
        }
        this.m_pms = pms;
        this.repaint();
    }

    public int getNumberOfPM() {
        if (this.m_pms != null) {
            return this.m_pms.length;
        }
        return 0;
    }

    public Object getEntry(int row) {
        LETable table;
        Object entry = null;
        LEPortMaster pm = this.getPortMaster(row);
        if (pm != null && (table = this.getTable(pm)) != null) {
            String key = this.getCellString(row, 1);
            entry = table.get(key);
        }
        return entry;
    }

    public LETable getTable(String host) {
        LETable table = null;
        int i = 0;
        while (table == null && i < this.m_pms.length) {
            if (host.equals(this.m_pms[i].getDescription())) {
                table = this.getTable(this.m_pms[i]);
            }
            ++i;
        }
        return table;
    }

    public void refresh() {
        LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int i = 0;
        while (i < this.m_pms.length) {
            this.removePortMaster(this.m_pms[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_pms.length) {
            LETable table = this.getTable(this.m_pms[i2]);
            if (table != null) {
                table.refresh();
            }
            this.addPortMaster(this.m_pms[i2]);
            ++i2;
        }
        dlg.hideStatus();
        this.repaint();
    }

    public void gone() {
        int i = 0;
        while (i < this.m_pms.length) {
            this.removePortMaster(this.m_pms[i]);
            ++i;
        }
    }

    public LEVector add() {
        LEVector entries = new LEVector();
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return entries;
        }
        int count = 0;
        LEDataSpec keySpec = null;
        LEDataSpec entrySpec = null;
        int i = 0;
        while (i < this.m_pms.length) {
            LETable table = this.getTable(this.m_pms[i]);
            if (table != null) {
                ++count;
                if (keySpec == null) {
                    keySpec = table.getKeySpec();
                }
                if (entrySpec == null) {
                    entrySpec = table.getSpecFor("entry");
                }
            }
            ++i;
        }
        if (count == 0) {
            return entries;
        }
        if (!this.addNewEntry(keySpec, entrySpec)) {
            return entries;
        }
        Object key = null;
        LEVector pms = this.determinePMs("Add");
        if (pms != null) {
            LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            int len = pms.size();
            int i2 = 0;
            while (i2 < len) {
                LENewEntry entry = this.addNewEntryTo((LEPortMaster)pms.elementAt(i2));
                if (entry != null) {
                    entries.addElement(entry);
                }
                ++i2;
            }
            dlg.hideStatus();
            this.repaint();
        }
        return entries;
    }

    public void delete() {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int[] rows = this.getSelectedRows();
        int i = rows.length - 1;
        while (i > -1) {
            LEPortMaster pm = this.getPortMaster(rows[i]);
            String key = this.getCellString(rows[i], 1);
            LETable table = this.getTable(pm);
            this.delete(pm, table, key);
            --i;
        }
        this.refillTable();
        dlg.hideStatus();
        this.repaint();
    }

    public void paste(Object obj) {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        LEVector pms = this.determinePMs("Paste");
        if (pms != null) {
            LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            int len = pms.size();
            int i = 0;
            while (i < len) {
                this.pasteTo((LEPortMaster)pms.elementAt(i), obj);
                ++i;
            }
            dlg.hideStatus();
            this.repaint();
        }
    }

    public void clone(Object obj) {
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        if (!(obj instanceof LEConfig)) {
            return;
        }
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        LEConfig config = (LEConfig)obj;
        int i = 0;
        while (i < rows.length) {
            LEConfig clone = (LEConfig)this.getEntry(rows[i]);
            if (clone != null) {
                LEConnectionFacade facade = clone.getConnectionFacade();
                clone.copy(config);
                LEVector errors = clone.saveChanges();
                if (errors != null) {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), facade, errors);
                }
                this.updateEntry(facade.getDescription(), (LETable)clone.getOwner(), this.getCellString(rows[i], 1));
            }
            ++i;
        }
        dlg.hideStatus();
        this.repaint();
    }

    public void rename() {
        String oldKey;
        LETable table;
        if (LEAppInfo.DemoMode()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
            return;
        }
        int[] rows = this.getSelectedRows();
        if (rows.length != 1) {
            return;
        }
        LEPortMaster pm = this.getPortMaster(rows[0]);
        String newKey = this.renameEntry(pm, table = this.getTable(pm), oldKey = this.getCellString(rows[0], 1));
        if (newKey != null) {
            LEStatusDialog dlg = new LEStatusDialog(LEUiUtils.GetBaseFrame());
            LEConfig src = (LEConfig)table.get(oldKey);
            LEConfig dst = (LEConfig)table.get(newKey);
            dst.copy(src);
            LEVector errors = dst.saveChanges();
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
            this.delete(pm, table, oldKey);
            this.setCellString(rows[0], 1, newKey);
            dlg.hideStatus();
            this.repaint();
        }
    }

    public void update(LEObservable obs, Object arg) {
        String key = (String)this.m_objs.get(obs);
        if (key == null) {
            return;
        }
        LETable table = (LETable)((LEConfig)obs).getOwner();
        String host = table.getConnectionFacade().getDescription();
        this.updateEntry(host, table, key);
        this.repaint();
    }

    LEPortMaster getPortMaster(int row) {
        LEPortMaster pm = null;
        String host = this.getCellString(row, 0);
        int i = 0;
        while (pm == null && i < this.m_pms.length) {
            if (host.equals(this.m_pms[i].getDescription())) {
                pm = this.m_pms[i];
            }
            ++i;
        }
        return pm;
    }

    void addPortMaster(LEPortMaster pm) {
        LETable table = this.getTable(pm);
        if (table != null) {
            LEVector keys = table.getKeys();
            String host = pm.getDescription();
            int len = keys.size();
            int i = 0;
            while (i < len) {
                String key = (String)keys.elementAt(i);
                this.addEntry(host, table, key);
                ++i;
            }
        }
    }

    void addEntry(String host, LETable table, String key) {
        Object obj = table.get(key);
        if (obj == null) {
            return;
        }
        String[] data = new String[this.m_cols + 2];
        data[0] = host;
        data[1] = key;
        if (this.m_cols > 0) {
            if (obj instanceof LEConfig) {
                LEConfig config = (LEConfig)obj;
                config.addObserver(this);
                this.m_objs.put(config, key);
                int len = this.m_tags.size();
                int i = 0;
                while (i < len) {
                    String tag = (String)this.m_tags.elementAt(i);
                    obj = config.get(tag);
                    data[i + 2] = obj == null ? BLANK : obj.toString();
                    ++i;
                }
            } else {
                data[2] = obj.toString();
            }
        }
        this.addRow(data);
    }

    void updateEntry(String host, LETable table, String key) {
        Object obj = table.get(key);
        if (obj == null || this.m_cols == 0) {
            return;
        }
        int rows = this.getNumRows();
        int row = -1;
        int i = 0;
        while (row == -1 && i < rows) {
            String cellHost = this.getCellString(i, 0);
            String cellKey = this.getCellString(i, 1);
            if (cellHost.equals(host) && cellKey.equals(key)) {
                row = i;
            }
            ++i;
        }
        if (row > -1) {
            if (obj instanceof LEConfig) {
                LEConfig config = (LEConfig)obj;
                int len = this.m_tags.size();
                int i2 = 0;
                while (i2 < len) {
                    String tag = (String)this.m_tags.elementAt(i2);
                    obj = config.get(tag);
                    if (obj == null) {
                        this.setCellString(row, i2 + 2, BLANK);
                    } else {
                        this.setCellString(row, i2 + 2, obj.toString());
                    }
                    ++i2;
                }
            } else {
                this.setCellString(row, 2, obj.toString());
            }
        } else {
            this.addEntry(host, table, key);
        }
    }

    synchronized void removePortMaster(LEPortMaster pm) {
        LETable table = this.getTable(pm);
        if (table == null) {
            return;
        }
        String host = pm.getDescription();
        int rows = this.getNumRows();
        int row = rows - 1;
        while (row > -1) {
            String data = this.getCellString(row, 0);
            if (data.equals(host)) {
                String key = this.getCellString(row, 1);
                Object obj = table.get(key);
                if (obj instanceof LEConfig) {
                    ((LEConfig)obj).deleteObserver(this);
                    this.m_objs.remove(obj);
                }
                this.deleteRow(row);
            }
            --row;
        }
    }

    LETable getTable(LEPortMaster pm) {
        LETable table = null;
        LEConfig config = pm;
        int len = this.m_context.size();
        int i = 0;
        while (config != null && i < len) {
            Object obj = ((LEConfig)config).get((String)this.m_context.elementAt(i));
            config = obj instanceof LEConfig ? (LEConfig)obj : null;
            ++i;
        }
        if (config instanceof LETable) {
            table = (LETable)config;
        }
        return table;
    }

    LEVector determinePMs(String action) {
        LEVector pms = new LEVector();
        String des = null;
        int i = 0;
        while (i < this.m_pms.length) {
            LETable table = this.getTable(this.m_pms[i]);
            if (table != null) {
                pms.addElement(this.m_pms[i]);
                if (des == null) {
                    LEDataSpec spec = table.getSpecFor("entry");
                    des = spec.getDescription();
                }
            }
            ++i;
        }
        int count = pms.size();
        if (count > 1) {
            Component[][] comps = new Component[count][2];
            comps[0][0] = new Label(String.valueOf(action) + " " + des + " to:");
            comps[0][0].setFont(LEFont.getBoldFont());
            int i2 = 0;
            while (i2 < count) {
                comps[i2][1] = new Checkbox(((LEPortMaster)pms.elementAt(i2)).getDescription(), true, null);
                ++i2;
            }
            LEAddDialog dlg = new LEAddDialog(LEUiUtils.GetBaseFrame(), String.valueOf(action) + " " + des, new LECompGrid(comps, 2, false));
            if (dlg.okay()) {
                int i3 = count - 1;
                while (i3 > -1) {
                    if (!((Checkbox)comps[i3][1]).getState()) {
                        pms.removeElementAt(i3);
                    }
                    --i3;
                }
                if (pms.size() == 0) {
                    pms = null;
                }
            } else {
                pms = null;
            }
        } else if (count == 0) {
            pms = null;
        }
        return pms;
    }

    void pasteTo(LEPortMaster pm, Object obj) {
        if (obj instanceof LEVector) {
            LEVector vec = (LEVector)obj;
            int len = vec.size();
            int i = 0;
            while (i < len) {
                this.pasteEntryTo(pm, vec.elementAt(i));
                ++i;
            }
        } else {
            this.pasteEntryTo(pm, obj);
        }
    }

    void pasteEntryTo(LEPortMaster pm, Object obj) {
        String key = this.getPasteKey(pm, obj);
        if (key == null) {
            return;
        }
        LETable table = this.getTable(pm);
        Object newObj = table.get(key);
        if (newObj instanceof LEConfig) {
            LEConfig oldConfig = (LEConfig)obj;
            LEConfig newConfig = (LEConfig)newObj;
            newConfig.copy(oldConfig);
            newConfig.setConnectionFacade(pm.getConnectionFacade());
            LEVector errors = newConfig.saveChanges();
            if (errors != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), pm.getConnectionFacade(), errors);
            }
        }
        this.updateEntry(pm.getDescription(), table, key);
    }

    void refillTable() {
        int i = 0;
        while (i < this.m_pms.length) {
            this.removePortMaster(this.m_pms[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_pms.length) {
            this.addPortMaster(this.m_pms[i2]);
            ++i2;
        }
    }

    String getPasteKey(LEPortMaster pm, Object obj) {
        return null;
    }

    boolean addNewEntry(LEDataSpec keySpec, LEDataSpec entrySpec) {
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster pm) {
        return null;
    }

    void delete(LEPortMaster pm, LETable table, String key) {
    }

    String renameEntry(LEPortMaster pm, LETable table, String key) {
        return null;
    }

    static String GetUniqueKey(LETable table, String key, int maxLen) {
        boolean unique = false;
        int count = 1;
        String newKey = key;
        while (!unique) {
            String suffix = Integer.toString(count);
            if (key.length() + suffix.length() > maxLen) {
                key = key.substring(0, maxLen - suffix.length());
            }
            if (table.get(newKey = String.valueOf(key) + suffix) == null) {
                unique = true;
                continue;
            }
            ++count;
        }
        return newKey;
    }
}

