/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Checkbox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEToggleFormLine
extends Checkbox
implements LEFormLine,
ItemListener,
MouseListener {
    public static final String ON = new String("on");
    public static final String OFF = new String("off");
    public static final String TRUE = new String("true");
    public static final String FALSE = new String("false");
    public static final String ONE = new String("1");
    public static final String ZERO = new String("0");
    public static final String ENABLE = new String("enable");
    public static final String DISABLE = new String("disable");
    static int MODE_ONOFF;
    static int MODE_TF;
    static int MODE_01;
    static int MODE_ENDIS;
    int m_mode;
    LEFormLineListener m_listener;
    String m_valid;

    public LEToggleFormLine() {
        super("");
        this.addItemListener(this);
        this.addMouseListener(this);
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_listener != null) {
            LEFormLineEvent formEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(formEvent);
        }
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
    }

    public void setValue(Object field) {
        String state = field.toString();
        if (state.equalsIgnoreCase(ON)) {
            this.setState(true);
            this.m_mode = MODE_ONOFF;
        } else if (state.equalsIgnoreCase(OFF)) {
            this.setState(false);
            this.m_mode = MODE_ONOFF;
        } else if (state.equalsIgnoreCase(TRUE)) {
            this.setState(true);
            this.m_mode = MODE_TF;
        } else if (state.equalsIgnoreCase(FALSE)) {
            this.setState(false);
            this.m_mode = MODE_TF;
        } else if (state.equals(ONE)) {
            this.setState(true);
            this.m_mode = MODE_01;
        } else if (state.equals(ZERO)) {
            this.setState(false);
            this.m_mode = MODE_01;
        } else if (state.equalsIgnoreCase(ENABLE)) {
            this.setState(true);
            this.m_mode = MODE_ENDIS;
        } else if (state.equalsIgnoreCase(DISABLE)) {
            this.setState(false);
            this.m_mode = MODE_ENDIS;
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public String getValue() {
        if (this.getState()) {
            if (this.m_mode == MODE_ONOFF) {
                return ON;
            }
            if (this.m_mode == MODE_TF) {
                return TRUE;
            }
            if (this.m_mode == MODE_01) {
                return ONE;
            }
            return ENABLE;
        }
        if (this.m_mode == MODE_ONOFF) {
            return OFF;
        }
        if (this.m_mode == MODE_TF) {
            return FALSE;
        }
        if (this.m_mode == MODE_01) {
            return ZERO;
        }
        return DISABLE;
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            if (this.m_mode == MODE_ONOFF) {
                buf.append(ON);
                buf.append(", ");
                buf.append(OFF);
            } else if (this.m_mode == MODE_TF) {
                buf.append(TRUE);
                buf.append(", ");
                buf.append(FALSE);
            } else if (this.m_mode == MODE_01) {
                buf.append(ONE);
                buf.append(", ");
                buf.append(ZERO);
            } else {
                buf.append(ENABLE);
                buf.append(", ");
                buf.append(DISABLE);
            }
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String str = field.toString();
            String val = this.getValue();
            return val.equalsIgnoreCase(str);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    static {
        MODE_TF = 1;
        MODE_01 = 2;
        MODE_ENDIS = 3;
    }
}

