/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEVPNKeyField;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;

public class LEVPNKeyFormLine
extends Panel
implements LEFormLine,
MouseListener,
ActionListener {
    LEFormLineListener m_listener;
    String m_valid;
    LEVPNKeyField m_key;
    Button m_random;
    int m_min;
    int m_max;
    boolean m_hex;

    public LEVPNKeyFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_key = new LEVPNKeyField(48);
        this.add(this.m_key);
        this.m_random = new Button("Random");
        this.add(this.m_random);
        this.addMouseListener(this);
        this.m_key.addMouseListener(this);
        this.m_random.addMouseListener(this);
        this.m_random.addActionListener(this);
        this.m_min = 8;
        this.m_max = 64;
        this.m_hex = false;
    }

    public void initFormLine(LEPortMaster pm, LEDataSpec spec) {
        String attr = (String)spec.getAttribute(LEAttributes.MINIMUM);
        if (attr != null) {
            this.m_min = Integer.parseInt(attr);
        }
        if ((attr = (String)spec.getAttribute(LEAttributes.MAXIMUM)) != null) {
            this.m_max = Integer.parseInt(attr);
            this.m_key.setColumns(this.m_max / 4);
        }
    }

    public void setListener(LEFormLineListener listener) {
        this.m_listener = listener;
    }

    public void setValue(Object field) {
        String value = field.toString();
        if (value.startsWith("0x") || value.startsWith("0X")) {
            this.m_key.setHex(true);
        } else {
            this.m_key.setNumeric(true);
        }
        ((TextComponent)this.m_key).setText(value);
    }

    public String getValue() {
        return this.m_key.getText();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("Decimal or Hexadecimal number ");
            if (this.m_min != this.m_max) {
                buf.append(this.m_min);
                buf.append(" to ");
            }
            buf.append(this.m_max);
            buf.append(" bits long");
            this.m_valid = buf.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object field) {
        if (field != null) {
            String oldVal = field.toString();
            String newVal = this.getValue();
            return newVal.equals(oldVal);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent event = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(event);
        }
    }

    public void setEnabled(boolean enable) {
        this.m_key.setEnabled(enable);
        this.m_random.setEnabled(enable);
        super.setEnabled(enable);
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent event) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    void setMaxKey(int max) {
        this.m_max = max;
        this.m_valid = null;
    }

    void setMinKey(int min) {
        this.m_min = min;
        this.m_valid = null;
    }

    public void actionPerformed(ActionEvent event) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        String value = this.generateRandomHexValue(this.m_max / 32);
        buf.append(value);
        buf.append("/");
        buf.append(this.m_max);
        ((TextComponent)this.m_key).setText(buf.toString());
        this.m_key.setHex(true);
    }

    protected String generateRandomHexValue(int length) {
        StringBuffer buf = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            int value = random.nextInt();
            String blah = Integer.toHexString(value);
            while (blah.length() < 8) {
                blah = String.valueOf(blah) + "3";
            }
            buf.append(blah);
            ++i;
        }
        return buf.toString();
    }
}

