/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.util.LECipher;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.Serializable;
import java.util.Hashtable;

public class LEPop
implements Serializable,
Cloneable {
    public static final String DEFAULT = "##DEFAULT##";
    String m_name;
    String m_password;
    String m_defaultUser = "!root";
    String m_defaultPW;
    LEVector m_ids = new LEVector();
    Hashtable m_hostnames = new Hashtable();
    Hashtable m_usernames = new Hashtable();
    Hashtable m_passwords = new Hashtable();

    public LEPop(String string, String string2) {
        this.m_name = string;
        this.m_password = LECipher.Encrypt(string2);
        this.m_defaultPW = LECipher.Encrypt("");
    }

    public synchronized Object clone() {
        LEPop lEPop = new LEPop(this.m_name, LECipher.Decrypt(this.m_password));
        lEPop.setDefaultUsername(this.getDefaultUsername());
        lEPop.setDefaultPassword(this.getDefaultPassword());
        int n = this.m_ids.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.m_ids.elementAt(n2);
            lEPop.setEntry(this.getHostnameFor(string), this.getUsernameFor(string), this.getPasswordFor(string));
            ++n2;
        }
        return lEPop;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPassword() {
        return LECipher.Decrypt(this.m_password);
    }

    public String getDefaultUsername() {
        return this.m_defaultUser;
    }

    public String getDefaultPassword() {
        return LECipher.Decrypt(this.m_defaultPW);
    }

    public LEVector getIDs() {
        return this.m_ids;
    }

    public String getHostnameFor(String string) {
        return (String)this.m_hostnames.get(string);
    }

    public String getUsernameFor(String string) {
        return (String)this.m_usernames.get(string);
    }

    public String getPasswordFor(String string) {
        String string2 = (String)this.m_passwords.get(string);
        if (string2 != null) {
            string2 = LECipher.Decrypt(string2);
        }
        return string2;
    }

    public String getActualUsernameFor(String string) {
        String string2 = this.getUsernameFor(string);
        if (DEFAULT.equals(string2)) {
            string2 = this.m_defaultUser;
        }
        return string2;
    }

    public String getActualPasswordFor(String string) {
        String string2 = this.getPasswordFor(string);
        if (DEFAULT.equals(string2)) {
            string2 = LECipher.Decrypt(this.m_defaultPW);
        }
        return string2;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setPassword(String string) {
        this.m_password = LECipher.Encrypt(string);
    }

    public void setDefaultUsername(String string) {
        this.m_defaultUser = string;
    }

    public void setDefaultPassword(String string) {
        this.m_defaultPW = LECipher.Encrypt(string);
    }

    public String setEntry(String string, String string2, String string3) {
        String string4 = LEResourceID.CreatePM_ID(string, string2);
        this.m_ids.addUnique(string4);
        this.m_hostnames.put(string4, string);
        this.m_usernames.put(string4, string2);
        this.m_passwords.put(string4, LECipher.Encrypt(string3));
        return string4;
    }

    public void removeEntry(String string, String string2) {
        String string3 = LEResourceID.CreatePM_ID(string, string2);
        this.removeEntry(string3);
    }

    public void removeEntry(String string) {
        if (this.m_ids.removeElement(string)) {
            this.m_hostnames.remove(string);
            this.m_usernames.remove(string);
            this.m_passwords.remove(string);
        }
    }
}

