/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.remote.LEServersFile;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEServerConnectClient;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEServerConnectPanel
extends Panel
implements ActionListener,
ItemListener {
    LEServerConnectClient m_client;
    TextField m_name;
    Choice m_apps;
    Choice m_servs;
    LETextField m_port;
    TextField m_pw;
    Button m_connect;
    Button m_cancel;
    LEServersFile m_servers;
    String m_server;
    int m_sport = -1;
    String m_password;
    boolean m_canceled;
    String m_app;

    public LEServerConnectPanel(LEServerConnectClient lEServerConnectClient, LEServersFile lEServersFile, boolean bl) {
        this(lEServerConnectClient, null, lEServersFile, bl);
    }

    public LEServerConnectPanel(LEServerConnectClient lEServerConnectClient, String[] stringArray, LEServersFile lEServersFile, boolean bl) {
        Label label;
        this.m_client = lEServerConnectClient;
        this.m_servers = lEServersFile;
        this.setLayout(new BorderLayout());
        int n = 4;
        if (stringArray != null) {
            if (stringArray.length == 1) {
                this.m_app = stringArray[0];
            } else if (stringArray.length > 0) {
                n = 5;
            }
        }
        int n2 = 0;
        Component[][] componentArray = new Component[n][2];
        if (n == 5) {
            int n3 = n2++;
            label = new Label("Application:");
            componentArray[n3][0] = label;
            label.setFont(LEFont.getBoldFont());
        }
        int n4 = n2++;
        label = new Label("Server:");
        componentArray[n4][0] = label;
        label.setFont(LEFont.getBoldFont());
        componentArray[n2++][0] = new Label("");
        int n5 = n2++;
        label = new Label("Port:");
        componentArray[n5][0] = label;
        label.setFont(LEFont.getBoldFont());
        int n6 = n2++;
        label = new Label("Password:");
        componentArray[n6][0] = label;
        label.setFont(LEFont.getBoldFont());
        n2 = 0;
        if (n == 5) {
            int n7 = n2++;
            this.m_apps = new Choice();
            componentArray[n7][1] = this.m_apps;
            int n8 = 0;
            while (n8 < stringArray.length) {
                this.m_apps.addItem(stringArray[n8]);
                ++n8;
            }
        }
        int n9 = n2++;
        this.m_name = new TextField(30);
        componentArray[n9][1] = this.m_name;
        int n10 = n2++;
        this.m_servs = new Choice();
        componentArray[n10][1] = this.m_servs;
        int n11 = n2++;
        this.m_port = new LETextField(5);
        componentArray[n11][1] = this.m_port;
        int n12 = n2++;
        this.m_pw = new TextField(30);
        componentArray[n12][1] = this.m_pw;
        this.m_port.setNumeric(true);
        this.m_port.setBounds(0L, 65535L);
        this.m_pw.setEchoChar('*');
        LEVector lEVector = this.m_servers.getServerNames();
        int n13 = lEVector.size();
        int n14 = 0;
        while (n14 < n13) {
            this.m_servs.addItem((String)lEVector.elementAt(n14));
            ++n14;
        }
        this.m_servs.addItemListener(this);
        this.add("Center", new LECompGrid(componentArray, 1));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        Panel panel2 = new Panel();
        if (bl) {
            panel2.setLayout(new GridLayout(1, 2, 5, 0));
        } else {
            panel2.setLayout(new GridLayout(1, 1));
        }
        this.m_connect = new Button("Connect");
        panel2.add(this.m_connect);
        this.m_connect.addActionListener(this);
        if (bl) {
            this.m_cancel = new Button("Cancel");
            panel2.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
        }
        panel.add(panel2);
        this.add("South", panel);
    }

    public void set(String string) {
        String string2 = null;
        if (string != null) {
            string2 = this.m_servers.getPortFor(string);
        }
        this.set(string, string2, null);
    }

    public void set(String string, String string2, String string3) {
        if (string != null) {
            ((TextComponent)this.m_name).setText(string);
        }
        if (string2 != null) {
            if (string2.equals("-1")) {
                ((TextComponent)this.m_port).setText("");
            } else {
                ((TextComponent)this.m_port).setText(string2);
            }
        }
        if (string3 != null) {
            ((TextComponent)this.m_pw).setText(string2);
        }
        this.m_pw.requestFocus();
    }

    public void setApplication(String string) {
        if (this.m_apps != null) {
            this.m_apps.select(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == this.m_connect) {
            this.connect();
            return;
        }
        this.m_client.connectCancel();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.set(this.m_servs.getSelectedItem());
        this.m_pw.requestFocus();
    }

    void connect() {
        String string;
        String string2 = null;
        if (this.m_apps != null) {
            string2 = this.m_apps.getSelectedItem();
        } else if (this.m_app != null) {
            string2 = this.m_app;
        }
        String string3 = this.m_name.getText();
        if (string3.length() == 0 && (string = this.m_servs.getSelectedItem()) != null && string.length() > 0) {
            string3 = string;
            ((TextComponent)this.m_name).setText(string);
            String string4 = this.m_servers.getPortFor(string);
            if (string4.equals("-1")) {
                ((TextComponent)this.m_port).setText("");
            } else {
                ((TextComponent)this.m_port).setText(string4);
            }
        }
        string = this.m_port.getText();
        int n = -1;
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        boolean bl = this.m_servers.getPortFor(string3) == null;
        String string5 = this.m_pw.getText();
        this.m_servers.set(string3, Integer.toString(n));
        this.m_servers.saveServers();
        if (bl) {
            this.m_servs.addItem(string3);
            this.m_servs.invalidate();
            this.invalidate();
            this.validate();
        }
        this.m_client.connectTo(string2, string3, n, string5);
    }
}

