/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.view;

import com.lucent.ra.nms.ui.LEPathBar;
import com.lucent.ra.nms.ui.LEPathEvent;
import com.lucent.ra.nms.ui.LEPathItem;
import com.lucent.ra.nms.ui.LEPathListener;
import com.lucent.ra.nms.ui.LETitleBar;
import com.lucent.ra.nms.ui.LETree;
import com.lucent.ra.nms.ui.LETreeItem;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.view.LEView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;

public class LEViewPanel
extends Panel
implements LEPathListener {
    LEView m_view;
    LEPathBar m_path;
    LETree m_tree;
    Component m_main;
    Component m_bottom;

    public LEViewPanel(LETree lETree) {
        this.setLayout(new BorderLayout(5, 5));
        this.m_tree = lETree;
        this.m_path = new LEPathBar();
        this.m_path.addListener(this);
        this.add("North", this.m_path);
    }

    public void onLEPathEvent(LEPathEvent lEPathEvent) {
        LETreeItem lETreeItem = (LETreeItem)lEPathEvent.getItem().getData();
        this.m_tree.select(lETreeItem, true);
    }

    public void lock() {
        this.m_path.setEnabled(false);
    }

    public void unlock() {
        this.m_path.setEnabled(true);
    }

    public void reset() {
        try {
            this.updatePath();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        if (this.m_view != null) {
            try {
                this.m_view.going();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        this.removePanels(true);
        if (this.m_view != null) {
            try {
                this.m_view.gone();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_view = null;
        }
    }

    public void setView(LEView lEView) {
        this.m_view = lEView;
        this.updatePath();
        try {
            this.m_main = this.m_view.getMainPanel();
            if (this.m_main != null) {
                this.add("Center", this.m_main);
                this.m_main.setVisible(true);
            }
            this.m_bottom = this.m_view.getBottomPanel();
            if (this.m_bottom != null) {
                this.m_bottom = this.buildBottomPanel(this.m_bottom);
                this.add("South", this.m_bottom);
                this.m_bottom.setVisible(true);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public void updatePath() {
        LETreeItem lETreeItem;
        LETreeItem lETreeItem2 = lETreeItem = this.m_tree.getSelectedItem();
        int n = 0;
        while (lETreeItem2 != null) {
            ++n;
            lETreeItem2 = lETreeItem2.m_parent;
        }
        LEPathItem[] lEPathItemArray = new LEPathItem[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            lEPathItemArray[n2] = new LEPathItem(lETreeItem.m_label, lETreeItem);
            lETreeItem = lETreeItem.m_parent;
            --n2;
        }
        this.m_path.setPath(lEPathItemArray);
    }

    public Component getMain() {
        return this.m_main;
    }

    public Component getBottom() {
        return this.m_bottom;
    }

    public LEView removeView() {
        this.removePanels(false);
        LEView lEView = this.m_view;
        this.m_view = null;
        return lEView;
    }

    void removePanels(boolean bl) {
        if (this.m_main != null) {
            try {
                if (bl) {
                    this.m_main.setVisible(false);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            try {
                this.remove(this.m_main);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_main = null;
        }
        if (this.m_bottom != null) {
            try {
                if (bl) {
                    this.m_bottom.setVisible(false);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            try {
                this.remove(this.m_bottom);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_bottom = null;
        }
    }

    Component buildBottomPanel(Component component) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("North", new LETitleBar());
        panel.add("Center", component);
        return panel;
    }
}

