/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import java.io.Serializable;

public class LEMonLinesMessage
extends LEEntityMessage
implements Serializable {
    public static final String LINE = "line";
    public static final String DASH = "-";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String ONE = "1";
    String m_status = "-";
    String m_status2 = "-";
    String m_recvLevel;
    long m_blueAlarm;
    long m_yellowAlarm;
    long m_carrierLoss;
    long m_syncLoss;
    long m_bipolarError;
    long m_crcError;
    long m_syncError;

    public LEMonLinesMessage(String id, int request, String name) {
        super(id, request, LINE + name);
        this.m_messageType = "MONITOR";
    }

    public String getStatus() {
        return this.m_status;
    }

    public String getStatus2() {
        return this.m_status2;
    }

    public String getRecvLevel() {
        return this.m_recvLevel;
    }

    public long getBlueAlarm() {
        return this.m_blueAlarm;
    }

    public long getYellowAlarm() {
        return this.m_yellowAlarm;
    }

    public long getCarrierLoss() {
        return this.m_carrierLoss;
    }

    public long getSyncLoss() {
        return this.m_syncLoss;
    }

    public long getBIPolarError() {
        return this.m_bipolarError;
    }

    public long getCRCError() {
        return this.m_crcError;
    }

    public long getSyncError() {
        return this.m_syncError;
    }

    public void setAttribute(int attribute, String value) {
        try {
            switch (attribute) {
                case 275: {
                    this.setBoard(value);
                    break;
                }
                case 17: {
                    this.m_status = value.equals(ONE) ? UP : DOWN;
                    break;
                }
                case 53: {
                    this.m_status2 = value.equals(ONE) ? DOWN : UP;
                    break;
                }
                case 28: {
                    this.m_recvLevel = value;
                    break;
                }
                case 29: {
                    this.m_blueAlarm = Long.parseLong(value);
                    break;
                }
                case 30: {
                    this.m_yellowAlarm = Long.parseLong(value);
                    break;
                }
                case 31: {
                    this.m_carrierLoss = Long.parseLong(value);
                    break;
                }
                case 32: {
                    this.m_syncLoss = Long.parseLong(value);
                    break;
                }
                case 33: {
                    this.m_bipolarError = Long.parseLong(value);
                    break;
                }
                case 34: {
                    this.m_crcError = Long.parseLong(value);
                    break;
                }
                case 35: {
                    this.m_syncError = Long.parseLong(value);
                    break;
                }
                case 560: {
                    this.setStartReceived();
                    break;
                }
                case 561: {
                    this.setEndReceived();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

