/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEITSParamParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LECustParamFormLine
extends LETextField
implements LEFormLine,
ActionListener,
MouseListener {
    public static final int DEFAULT_SIZE = 60;
    public static final char ECHO_CHAR = '*';
    LEFormLineListener m_listener;
    String m_valid;
    int m_maxLen;

    public LECustParamFormLine() {
        super(60);
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        if (lEDataSpec != null) {
            String string;
            if (lEDataSpec.getAttribute(LEAttributes.WRITEONLY) != null) {
                this.setEchoChar('*');
            }
            if ((string = (String)lEDataSpec.getAttribute(LEAttributes.MAXIMUM)) != null) {
                try {
                    this.m_maxLen = Math.min(Integer.parseInt(string), 60);
                    this.setColumns(this.m_maxLen);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                    return;
                }
            }
        }
    }

    public void setValue(Object object) {
        this.setText(object.toString().toUpperCase());
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public String getValue() {
        return this.getText().toUpperCase();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer("See PacketStar ITS Network Administration manual for valid syntax");
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            if (string2.compareTo("") == 0) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public boolean isValueValid() {
        LEITSParamParser lEITSParamParser = new LEITSParamParser();
        String string = this.getText().trim().toUpperCase();
        return lEITSParamParser.isValidString(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

