/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEIPRangesForm
extends LETableForm {
    private static final int MAX_RANGES = 8;
    String m_range;
    String m_size;
    String m_gateway;
    int m_numRanges;

    void addEntry(String string, LETable lETable, String string2) {
        if (lETable instanceof LEIPRanges) {
            this.m_numRanges = lETable.size();
        }
        super.addEntry(string, lETable, string2);
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        if (this.m_numRanges < 8) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            Component[][] componentArray = new Component[3][2];
            componentArray[0][0] = new Label(String.valueOf(lEDataSpec.getDescription()) + ": ");
            componentArray[0][0].setFont(LEFont.getBoldFont());
            componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
            LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("15");
            componentArray[1][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
            componentArray[1][0].setFont(LEFont.getBoldFont());
            componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
            lEDataSpec3 = lEDataSpec2.getSpecFor("522");
            componentArray[2][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
            componentArray[2][0].setFont(LEFont.getBoldFont());
            componentArray[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
            panel.add("Center", new LECompGrid(componentArray, 2, false));
            LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add IP Pool Range", panel);
            if (lEAddDialog.okay()) {
                this.m_range = ((LEFormLine)((Object)componentArray[0][1])).getValue();
                this.m_size = ((LEFormLine)((Object)componentArray[1][1])).getValue();
                this.m_gateway = ((LEFormLine)((Object)componentArray[2][1])).getValue();
                if (this.m_range.length() == 0) {
                    new LEErrorDialog(LEUiUtils.GetBaseFrame(), "An address must be specified");
                    return false;
                }
                return true;
            }
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You cannont have more than ");
        stringBuffer.append(8);
        stringBuffer.append(" ranges in an IP Pool.");
        new LEErrorDialog(LEUiUtils.GetBaseFrame(), stringBuffer.toString());
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LEIPRanges lEIPRanges = (LEIPRanges)this.getTable(lEPortMaster);
        LEVector lEVector = null;
        if (lEIPRanges.get(this.m_range) == null) {
            lEVector = lEIPRanges.add(this.m_range, this.m_size, this.m_gateway);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            } else {
                this.addEntry(lEPortMaster.getDescription(), lEIPRanges, this.m_range);
                lENewEntry = new LENewEntry(lEPortMaster, lEIPRanges, this.m_range);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "The IP pool already has a range of " + this.m_range);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEIPRanges)) {
            return;
        }
        LEIPRanges lEIPRanges = (LEIPRanges)lETable;
        try {
            LEVector lEVector = lEIPRanges.delete(string);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
        }
    }
}

