/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEBindings;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEDHCP
extends LEConfig {
    public static final String BINDINGS = "bindings";
    public static final String DOMAIN = "159";
    public static final String ENCAPSULATION = "190";
    public static final String GATEWAY = "75";
    public static final String IPPOOL = "ippool";
    public static final String LEASE = "200";
    public static final String NAMESERVER_1 = "157";
    public static final String NAMESERVER_2 = "158";
    public static final String NETBIOS_SCOPE = "201";
    public static final String NETMASK = "15";
    public static final String RELAY = "204";
    public static final String STATUS = "17";
    public static final String WINSERVER_1 = "202";
    public static final String WINSERVER_2 = "203";
    public static final int KEY_COUNT = 14;
    public static final String RESET = "reset dhcp";
    static String[] s_keys = null;
    boolean m_reset;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[14];
            int n = 0;
            LEDHCP.s_keys[n++] = BINDINGS;
            LEDHCP.s_keys[n++] = DOMAIN;
            LEDHCP.s_keys[n++] = ENCAPSULATION;
            LEDHCP.s_keys[n++] = GATEWAY;
            LEDHCP.s_keys[n++] = IPPOOL;
            LEDHCP.s_keys[n++] = LEASE;
            LEDHCP.s_keys[n++] = NAMESERVER_1;
            LEDHCP.s_keys[n++] = NAMESERVER_2;
            LEDHCP.s_keys[n++] = NETBIOS_SCOPE;
            LEDHCP.s_keys[n++] = NETMASK;
            LEDHCP.s_keys[n++] = RELAY;
            LEDHCP.s_keys[n++] = STATUS;
            LEDHCP.s_keys[n++] = WINSERVER_1;
            LEDHCP.s_keys[n++] = WINSERVER_2;
        }
        return s_keys;
    }

    public LEDHCP(LEConnectionFacade lEConnectionFacade) {
        super(lEConnectionFacade);
    }

    public Object clone() {
        LEDHCP lEDHCP = new LEDHCP(this.m_facade);
        lEDHCP.copy(this);
        return lEDHCP;
    }

    public boolean requiresReset(String string) {
        if (string.equals(BINDINGS)) {
            return true;
        }
        if (string.equals(DOMAIN)) {
            return true;
        }
        if (string.equals(ENCAPSULATION)) {
            return true;
        }
        if (string.equals(GATEWAY)) {
            return true;
        }
        if (string.equals(IPPOOL)) {
            return true;
        }
        if (string.equals(LEASE)) {
            return true;
        }
        if (string.equals(NAMESERVER_1)) {
            return true;
        }
        if (string.equals(NAMESERVER_2)) {
            return true;
        }
        if (string.equals(NETBIOS_SCOPE)) {
            return true;
        }
        if (string.equals(NETMASK)) {
            return true;
        }
        if (string.equals(WINSERVER_1)) {
            return true;
        }
        if (string.equals(WINSERVER_2)) {
            return true;
        }
        if (string.equals(STATUS)) {
            return true;
        }
        return string.equals(RELAY);
    }

    LEConfig createConfig(String string) {
        if (string.equals(BINDINGS)) {
            return new LEBindings(this.m_facade);
        }
        return new LEConfig(this.m_facade);
    }

    boolean getAllCommands(LEVector lEVector) {
        boolean bl = super.getAllCommands(lEVector);
        if (bl && this.m_reset) {
            lEVector.addElement("save all");
            lEVector.addElement(RESET);
            this.m_reset = false;
        }
        return bl;
    }

    boolean getChangedCommands(LEVector lEVector) {
        boolean bl = super.getChangedCommands(lEVector);
        if (bl && this.m_reset) {
            lEVector.addElement("save all");
            lEVector.addElement(RESET);
            this.m_reset = false;
        }
        return bl;
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        CharSequence charSequence;
        String string;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if (bl || lEVector.contains(DOMAIN)) {
            this.makeSetCommand(lEVector2, null, DOMAIN, "dhcp domain");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(ENCAPSULATION)) {
            this.makeSetCommand(lEVector2, null, ENCAPSULATION, "dhcp encapsulation");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(GATEWAY)) {
            this.makeSetCommand(lEVector2, null, GATEWAY, "dhcp gateway");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(IPPOOL)) {
            this.makeSetCommand(lEVector2, null, IPPOOL, "dhcp pool");
            this.m_reset = true;
        }
        if ((bl || lEVector.contains(LEASE)) && (string = (String)this.get(LEASE)) != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("set ");
            ((StringBuffer)charSequence).append("dhcp lease ");
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append(" minutes");
            lEVector2.addElement(((StringBuffer)charSequence).toString());
            this.m_reset = true;
        }
        if (bl || lEVector.contains(NAMESERVER_1)) {
            this.makeSetCommand(lEVector2, null, NAMESERVER_1, "dhcp nameserver 1");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(NAMESERVER_2)) {
            this.makeSetCommand(lEVector2, null, NAMESERVER_2, "dhcp nameserver 2");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(NETBIOS_SCOPE)) {
            this.makeSetCommand(lEVector2, null, NETBIOS_SCOPE, "dhcp netbios-scope");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(NETMASK)) {
            this.makeSetCommand(lEVector2, null, NETMASK, "dhcp netmask");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(WINSERVER_1)) {
            this.makeSetCommand(lEVector2, null, WINSERVER_1, "dhcp wins-server 1");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(WINSERVER_2)) {
            this.makeSetCommand(lEVector2, null, WINSERVER_2, "dhcp wins-server 2");
            this.m_reset = true;
        }
        if (bl || lEVector.contains(STATUS) || lEVector.contains(RELAY)) {
            string = (String)this.get(STATUS);
            if (string.equals("on")) {
                this.set(RELAY, "0.0.0.0");
                this.makeSetCommand(lEVector2, null, RELAY, "dhcp relay");
                this.makeSetCommand(lEVector2, null, STATUS, "dhcp server");
            } else if (string.equals("off")) {
                charSequence = (String)this.get(RELAY);
                if (charSequence != null && !((String)charSequence).equals("0.0.0.0")) {
                    this.makeSetCommand(lEVector2, null, STATUS, "dhcp server");
                    this.makeSetCommand(lEVector2, null, RELAY, "dhcp relay");
                } else {
                    this.makeSetCommand(lEVector2, null, RELAY, "dhcp relay");
                    this.makeSetCommand(lEVector2, null, STATUS, "dhcp server");
                }
            }
            this.m_reset = true;
        }
        return lEVector2.size() > n;
    }
}

