/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;

public class LEOrderedList
extends LEConfig {
    LEVector m_list = new LEVector();

    public LEOrderedList(LEConnectionFacade lEConnectionFacade) {
        super(lEConnectionFacade);
    }

    public Object clone() {
        LEOrderedList lEOrderedList = new LEOrderedList(this.m_facade);
        lEOrderedList.copy(this);
        return lEOrderedList;
    }

    public int length() {
        return this.m_list.size();
    }

    public LEVector getKeys(boolean bl) {
        LEVector lEVector = new LEVector();
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            lEVector.addElement(Integer.toString(n2));
            ++n2;
        }
        return lEVector;
    }

    public Object get(String string) {
        Object object = null;
        try {
            int n = Integer.parseInt(string);
            int n2 = this.length();
            if (n < n2) {
                object = this.get(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, "Bad key: " + string);
        }
        return object;
    }

    public Object get(int n) {
        return this.m_list.elementAt(n);
    }

    public void add(Object object) {
        this.m_list.addElement(object);
        this.markChanged();
    }

    public void deleteAll() {
        this.m_list.removeAllElements();
        this.markChanged();
    }

    public String getDescriptionFor(String string) {
        return string;
    }

    public LEDataSpec getSpecFor(String string) {
        LEDataSpec lEDataSpec = null;
        if (this.m_spec != null) {
            lEDataSpec = this.m_spec.getSpecFor("entry");
        }
        return lEDataSpec;
    }

    void markChanged() {
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
        this.setChanged();
        this.notifyObservers();
    }

    void clearList() {
        this.m_list.removeAllElements();
        this.setChanged();
        this.notifyObservers();
    }

    void addField(Object object) {
        this.m_list.addElement(object);
    }

    LEConfig addConfig() {
        int n = this.m_list.size();
        return this.getConfig(n);
    }

    LEConfig getConfig(int n) {
        int n2 = this.m_list.size();
        if (n < n2) {
            return (LEConfig)this.m_list.elementAt(n);
        }
        LEConfig lEConfig = this.createConfig();
        LEDataSpec lEDataSpec = this.getSpecFor(null);
        lEConfig.setSpec(lEDataSpec);
        this.addField(lEConfig);
        return lEConfig;
    }

    LEConfig createConfig() {
        return new LEConfig(this.m_facade);
    }
}

