/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEProperties;
import java.awt.Color;
import java.util.Hashtable;

public class LEColor {
    public static final String SELECT_BACKGROUND_FLAG = "-sb";
    public static final String SELECT_FOREGROUND_FLAG = "-sf";
    public static final String BLACK = "Black";
    public static final String BLUE = "Blue";
    public static final String CYAN = "Cyan";
    public static final String DARK_GRAY = "Dark Gray";
    public static final String GRAY = "Gray";
    public static final String GREEN = "Green";
    public static final String LIGHT_GRAY = "Light Gray";
    public static final String MAGENTA = "Magenta";
    public static final String ORANGE = "Orange";
    public static final String PINK = "Pink";
    public static final String RED = "Red";
    public static final String WHITE = "White";
    public static final String YELLOW = "Yellow";
    static Color m_background;
    static Color m_foreground;
    static Color m_shadowDark;
    static Color m_shadowLight;
    static Color m_selectBackground;
    static Color m_selectForeground;
    static Color m_selectShadowDark;
    static Color m_selectShadowLight;
    static Color m_textBackground;
    static Hashtable s_colorToName;
    static Hashtable s_nameToColor;

    public static void convertCMYK2RGB(double d, double d2, double d3, double d4, int[] nArray) {
        nArray[0] = (int)(2.55 * (100.0 - ((100.0 - d4) * (d / 100.0) + d4)));
        nArray[1] = (int)(2.55 * (100.0 - ((100.0 - d4) * (d2 / 100.0) + d4)));
        nArray[2] = (int)(2.55 * (100.0 - ((100.0 - d4) * (d3 / 100.0) + d4)));
    }

    public static Color getForeground() {
        if (m_foreground == null) {
            m_foreground = Color.black;
        }
        return m_foreground;
    }

    public static Color getBackground() {
        if (m_background == null) {
            m_background = Color.lightGray;
        }
        return m_background;
    }

    public static Color getShadowDark() {
        if (m_shadowDark == null) {
            m_shadowDark = Color.black;
        }
        return m_shadowDark;
    }

    public static Color getShadowLight() {
        if (m_shadowLight == null) {
            m_shadowLight = LEColor.getForeground().brighter();
        }
        return m_shadowLight;
    }

    public static Color getSelectBackground() {
        if (m_selectBackground == null) {
            m_selectBackground = new Color(0, 92, 209);
        }
        return m_selectBackground;
    }

    public static Color getSelectForeground() {
        if (m_selectForeground == null) {
            m_selectForeground = Color.white;
        }
        return m_selectForeground;
    }

    public static Color getSelectShadowDark() {
        if (m_selectShadowDark == null) {
            m_selectShadowDark = Color.black;
        }
        return m_selectShadowDark;
    }

    public static Color getSelectShadowLight() {
        if (m_selectShadowLight == null) {
            m_selectShadowLight = new Color(186, 239, 254);
        }
        return m_selectShadowLight;
    }

    public static Color getTextBackground() {
        if (m_textBackground == null) {
            m_textBackground = Color.white;
        }
        return m_textBackground;
    }

    public static void setForeground(Color color) {
        m_foreground = color;
    }

    public static void setSelectBackground(Color color) {
        m_selectBackground = color;
        m_selectShadowLight = color.brighter().brighter();
        m_selectShadowDark = color.darker().darker();
    }

    public static void setSelectForeground(Color color) {
        m_selectForeground = color;
    }

    public static void CheckColorFlags() {
        Color color;
        Object object;
        String string = LEAppInfo.getFlag(SELECT_BACKGROUND_FLAG);
        if (string != null && (object = LEColor.GetColorForSpec(string)) != null) {
            LEColor.setSelectBackground((Color)object);
        }
        if ((object = LEAppInfo.getFlag(SELECT_FOREGROUND_FLAG)) != null && (color = LEColor.GetColorForSpec((String)object)) != null) {
            LEColor.setSelectForeground(color);
        }
    }

    public static Color GetColorForSpec(String string) {
        Color color = null;
        try {
            int n = string.indexOf(46);
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(0, n);
            int n2 = Integer.parseInt(string2);
            int n3 = string.indexOf(46, n + 1);
            if (n3 == -1) {
                return null;
            }
            string2 = string.substring(n + 1, n3);
            int n4 = Integer.parseInt(string2);
            string2 = string.substring(n3 + 1);
            int n5 = Integer.parseInt(string2);
            color = new Color(n2, n4, n5);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return color;
    }

    public static String GetSpecForColor(Color color) {
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(color.getRed());
        stringBuffer.append('.');
        stringBuffer.append(color.getGreen());
        stringBuffer.append('.');
        stringBuffer.append(color.getBlue());
        return stringBuffer.toString();
    }

    public static Color GetColorForName(String string) {
        if (s_nameToColor == null) {
            LEColor.InitializeColorTables();
        }
        return (Color)s_nameToColor.get(string);
    }

    public static String GetNameForColor(Color color) {
        if (s_colorToName == null) {
            LEColor.InitializeColorTables();
        }
        return (String)s_colorToName.get(color);
    }

    public static Color GetColorProperty(String string) {
        Color color = null;
        String string2 = LEProperties.GetProperty(string);
        if (string2 != null && string2.length() > 0 && (color = LEColor.GetColorForName(string2)) == null) {
            color = LEColor.GetColorForSpec(string2);
        }
        return color;
    }

    public static void SetColorProperty(String string, Color color) {
        String string2 = LEColor.GetNameForColor(color);
        if (string2 == null) {
            string2 = LEColor.GetSpecForColor(color);
        }
        LEProperties.SetProperty(string, string2);
    }

    static void InitializeColorTables() {
        s_colorToName = new Hashtable();
        s_nameToColor = new Hashtable();
        s_colorToName.put(Color.black, BLACK);
        s_colorToName.put(Color.blue, BLUE);
        s_colorToName.put(Color.cyan, CYAN);
        s_colorToName.put(Color.darkGray, DARK_GRAY);
        s_colorToName.put(Color.gray, GRAY);
        s_colorToName.put(Color.green, GREEN);
        s_colorToName.put(Color.lightGray, LIGHT_GRAY);
        s_colorToName.put(Color.magenta, MAGENTA);
        s_colorToName.put(Color.orange, ORANGE);
        s_colorToName.put(Color.pink, PINK);
        s_colorToName.put(Color.red, RED);
        s_colorToName.put(Color.white, WHITE);
        s_colorToName.put(Color.yellow, YELLOW);
        s_nameToColor.put(BLACK, Color.black);
        s_nameToColor.put(BLUE, Color.blue);
        s_nameToColor.put(CYAN, Color.cyan);
        s_nameToColor.put(DARK_GRAY, Color.darkGray);
        s_nameToColor.put(GRAY, Color.gray);
        s_nameToColor.put(GREEN, Color.green);
        s_nameToColor.put(LIGHT_GRAY, Color.lightGray);
        s_nameToColor.put(MAGENTA, Color.magenta);
        s_nameToColor.put(ORANGE, Color.orange);
        s_nameToColor.put(PINK, Color.pink);
        s_nameToColor.put(RED, Color.red);
        s_nameToColor.put(WHITE, Color.white);
        s_nameToColor.put(YELLOW, Color.yellow);
    }

    static {
        s_colorToName = null;
        s_nameToColor = null;
    }
}

