/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEResource;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class LENotesView
extends Frame
implements ActionListener,
WindowListener {
    public static final String README = "README_";
    public static final String TXT_EXT = ".txt";
    Button m_browse;
    Button m_reset;
    TextArea m_text;
    Rectangle m_bounds;

    public LENotesView() {
        this((Rectangle)null);
    }

    public LENotesView(Rectangle rectangle) {
        super("Release Notes");
        this.m_bounds = rectangle == null || rectangle.width == 0 || rectangle.height == 0 ? new Rectangle(0, 0, 640, 480) : rectangle;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(Color.lightGray);
        this.m_text = new TextArea();
        this.add("Center", this.m_text);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 3, 10, 0));
        Button button = new Button("Close");
        button.addActionListener(this);
        panel2.add(button);
        this.m_browse = new Button("Browse...");
        panel2.add(this.m_browse);
        this.m_browse.addActionListener(this);
        this.m_reset = new Button("Reset");
        panel2.add(this.m_reset);
        this.m_reset.addActionListener(this);
        panel.add(panel2);
        this.add("South", panel);
        ((Component)this).setBounds(this.m_bounds);
        ((Component)this).setVisible(true);
    }

    public boolean loadReleaseNotes() {
        boolean bl = true;
        String string = README + LEAppInfo.getAppName();
        BufferedReader bufferedReader = LEResource.GetText(string);
        if (bufferedReader == null) {
            string = String.valueOf(string) + TXT_EXT;
            bufferedReader = LEResource.GetText(string);
        }
        if (bl = bufferedReader != null ? this.loadReader(bufferedReader) : false) {
            this.setTitle(string);
        } else {
            this.setText("Error: Could not locate the release notes");
        }
        return bl;
    }

    public boolean loadResource(String string) {
        boolean bl = true;
        BufferedReader bufferedReader = LEResource.GetText(string);
        bl = bufferedReader != null ? this.loadReader(bufferedReader) : false;
        if (bl) {
            this.setTitle(string);
        }
        return bl;
    }

    public boolean loadFile(String string) {
        boolean bl = true;
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            bl = this.loadReader(bufferedReader);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            bl = false;
        }
        if (bl) {
            this.setTitle(string);
        }
        return bl;
    }

    public boolean loadReader(BufferedReader bufferedReader) {
        boolean bl = true;
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            this.m_text.setText(new String(stringBuffer));
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            bl = false;
        }
        return bl;
    }

    public void setText(String string) {
        this.m_text.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_browse) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Load", 0);
            String string = LEAppInfo.getLastDirectory();
            if (string != null) {
                fileDialog.setDirectory(string);
            }
            fileDialog.show();
            string = fileDialog.getDirectory();
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                LEAppInfo.setLastDirectory(string);
                String string3 = LEAppInfo.createFullPath(string, string2);
                if (!this.loadFile(string3)) {
                    this.setText("ERROR: Could not load " + string3);
                    return;
                }
            }
        } else {
            if (object == this.m_reset) {
                this.loadReleaseNotes();
                return;
            }
            this.m_bounds = this.getBounds();
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public Rectangle getSavedBounds() {
        if (this.isShowing()) {
            this.m_bounds = this.getBounds();
        }
        return this.m_bounds;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.m_bounds = this.getBounds();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

