/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.bootp;

import COM.livingston.bootp.LEBootPClient;
import COM.livingston.bootp.LEBootPPacket;
import COM.livingston.util.LEDebug;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class LEBootPServer
implements Runnable {
    public static final int SERVER_PORT = 67;
    public static final int CLIENT_PORT = 68;
    private DatagramPacket m_received_packet;
    private DatagramSocket m_socket;
    private LEBootPClient m_client;
    private static LEBootPServer s_singleton = null;
    private Thread m_serverThread;

    public static LEBootPServer GetServer() throws SecurityException, SocketException {
        if (s_singleton == null) {
            s_singleton = new LEBootPServer();
        }
        return s_singleton;
    }

    private LEBootPServer() throws SecurityException, SocketException {
        byte[] byArray = new byte[300];
        this.m_received_packet = new DatagramPacket(byArray, byArray.length);
        this.m_socket = new DatagramSocket(67);
        this.m_client = null;
        this.m_serverThread = new Thread(this);
        this.m_serverThread.start();
    }

    public void setClient(LEBootPClient lEBootPClient) {
        this.m_client = lEBootPClient;
    }

    public void removeClient() {
        this.m_client = null;
    }

    private void notifyClient(LEBootPPacket lEBootPPacket) {
        if (this.m_client != null) {
            this.m_client.receivedPacket(lEBootPPacket);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.m_socket.receive(this.m_received_packet);
                    LEBootPPacket lEBootPPacket = new LEBootPPacket(this.m_received_packet.getData());
                    if (!lEBootPPacket.isRequest()) continue;
                    this.notifyClient(lEBootPPacket);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, "Exception " + exception.getClass().getName() + " Message " + exception.getMessage());
                continue;
            }
            break;
        }
    }

    public void sendPacket(LEBootPPacket lEBootPPacket, String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            DatagramPacket datagramPacket = new DatagramPacket(lEBootPPacket.dumpData(), lEBootPPacket.size(), inetAddress, 68);
            this.m_socket.send(datagramPacket);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, "Exception " + exception.getClass().getName() + " Message " + exception.getMessage());
            return;
        }
    }

    public void stopServer() {
        this.removeClient();
        this.m_serverThread.stop();
    }
}

