/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardAction;
import COM.livingston.wizard.LEWizardActionClient;
import COM.livingston.wizard.LEWizardDataModel;

public class LERestoreAction
extends LEWizardAction {
    public LERestoreAction(LEWizardDataModel model, LEWizardActionClient client) {
        super(model, client);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Restoring the configuration from backup.");
        this.restoreConfig();
    }

    private void restoreConfig() {
        LEPortMaster pm = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
        LEVector commands = (LEVector)this.m_model.getObject(LEPMWizardModel.COMMANDS);
        LEStatusManager manager = (LEStatusManager)this.m_model.getObject(LEPMWizardModel.STATUS_MANAGER);
        int len = commands.size();
        int i = 0;
        while (i < len) {
            if (i % 5 == 0 && manager instanceof LEStatusManager) {
                manager.setStatus(i * 100 / len);
            }
            String command = (String)commands.elementAt(i);
            try {
                manager.setStatus(command);
                LEPMCommand pmcommand = pm.execute(command);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
            ++i;
        }
        this.m_client.actionDone(this, LEThreadStatus.NO_MESSAGE, 0);
    }
}

