/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabPanel;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.arrowBox.ArrowBox;
import oracle.ewt.tabBar.SquareTabStyle;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarEvent;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabBar.TabBarListener;
import oracle.ewt.tabBar.TabStyle;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.tabPanel.TabPanelSheet;
import oracle.ewt.tabPanel.TabPanelValidateEvent;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class TabPanel
extends LWComponent
implements TabBarListener {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    private static final int _SHOW_PANEL_DELAY = 200;
    private TabPanelSheet _sheet;
    private ArrowBox _arrowBox;
    private TabBar _tabBar;
    private Vector _pagePack;
    private TabPanelPage _selectedPage;
    private ListenerManager _listeners;
    private Task _showTask;
    private static int _sInstanceCounter;
    private static String _sDefaultName;
    private static TaskScheduler _sTaskScheduler;

    public TabPanel() {
        this(SquareTabStyle.getTabStyle(), true);
    }

    public TabPanel(TabStyle tabStyle, boolean bl) {
        TabBar tabBar;
        if (tabStyle == null) {
            throw new IllegalArgumentException();
        }
        this.setLayout(new BorderLayout());
        this._tabBar = tabBar = this.createTabBar(tabStyle);
        this._arrowBox = new ArrowBox(tabBar, 0, 0);
        this._arrowBox.setArrowsTogether(true);
        this._pagePack = new Vector();
        this._sheet = new TabPanelSheet(this, bl);
        this.setOrientation(0);
        this.add("North", this._arrowBox);
        this.add("Center", this._sheet);
        tabBar.addTabBarListener(this);
    }

    public final TabPanelPage addPage(String string, Component component) {
        return this.addPage(string, component, null, false);
    }

    public final TabPanelPage addPage(String string, Component component, TabPanelPage tabPanelPage, boolean bl) {
        TabPanelPage tabPanelPage2 = new TabPanelPage(component, string);
        if (bl) {
            tabPanelPage2.setVisible(false);
        }
        return this.addPage(tabPanelPage2, tabPanelPage);
    }

    public final TabPanelPage addPage(TabPanelPage tabPanelPage) {
        return this.addPage(tabPanelPage, null);
    }

    public TabPanelPage addPage(TabPanelPage tabPanelPage, TabPanelPage tabPanelPage2) {
        TabBar tabBar = this.getTabBar();
        if (tabPanelPage.getParent() != null) {
            tabPanelPage.getParent().removePage(tabPanelPage);
        }
        Component component = tabPanelPage.getContent();
        component.setVisible(false);
        this._sheet.add(component);
        if (tabPanelPage2 == null) {
            this._pagePack.addElement(tabPanelPage);
            tabPanelPage.setParent(this);
            TabBarItem tabBarItem = tabPanelPage.getTabBarItem();
            tabBar.addItem(tabBarItem);
        } else {
            int n = this.getIndexOf(tabPanelPage2);
            this._pagePack.insertElementAt(tabPanelPage, n);
            tabPanelPage.setParent(this);
            TabBarItem tabBarItem = tabPanelPage.getTabBarItem();
            tabBar.addItem(tabBarItem, tabBar.getItem(n));
        }
        return tabPanelPage;
    }

    public TabPanelPage getPage(int n) {
        if (n < 0 || n >= this.getPageCount()) {
            throw new IllegalArgumentException();
        }
        return (TabPanelPage)this._pagePack.elementAt(n);
    }

    public int getIndexOf(TabPanelPage tabPanelPage) {
        if (tabPanelPage != null) {
            return this._pagePack.indexOf(tabPanelPage);
        }
        return -1;
    }

    public TabPanelPage getSelectedPage() {
        return this._selectedPage;
    }

    public synchronized int getPageCount() {
        return this._pagePack.size();
    }

    public synchronized void removeAllPages() {
        int n = this.getPageCount() - 1;
        while (n >= 0) {
            this.removePage(this.getPage(n--));
        }
    }

    public synchronized void removeAll() {
        this.removeAllPages();
        this._sheet.removeAll();
        super.removeAll();
        this._sheet = null;
        this._tabBar = null;
    }

    public synchronized void removePage(TabPanelPage tabPanelPage) {
        if (tabPanelPage == null) {
            throw new IllegalArgumentException();
        }
        this.getTabBar().removeItem(tabPanelPage.getTabBarItem());
        this._sheet.remove(tabPanelPage.getContent());
        this._pagePack.removeElement(tabPanelPage);
        tabPanelPage.setParent(null);
        if (tabPanelPage == this._selectedPage) {
            TabBarItem tabBarItem = this.getTabBar().getSelectedItem();
            if (tabBarItem == null) {
                this._selectedPage = null;
                return;
            }
            this._selectedPage = this.getPage(tabBarItem.indexOf());
        }
    }

    public void setOrientation(int n) {
        TabBar tabBar = this.getTabBar();
        if (n != tabBar.getOrientation()) {
            this.remove(this._arrowBox);
            tabBar.setOrientation(n);
            if (n == 0) {
                this.add("North", this._arrowBox);
            } else {
                this.add("South", this._arrowBox);
            }
            this._sheet.setOrientation(n);
            int n2 = this.getTabStyle().getVerticalGrowth();
            Insets insets = n == 0 ? new Insets(n2, 0, 0, 0) : new Insets(0, 0, n2, 0);
            this._arrowBox.setButtonInsets(insets);
            if (this.isTabsVisible()) {
                this.repaint();
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.getTabBar().setFont(font);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.getTabBar().setBackground(color);
        this._sheet.setBackground(color);
    }

    public void setContentBackground(Color color) {
        this.getTabBar().setItemBackground(color);
        this._sheet.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.getTabBar().setForeground(color);
        this._sheet.setForeground(color);
    }

    public void setTabsVisible(boolean bl) {
        TabBar tabBar = this.getTabBar();
        if (bl != tabBar.isVisible()) {
            tabBar.setVisible(bl);
            this._sheet.repaint();
        }
    }

    public boolean isTabsVisible() {
        return this.getTabBar().isVisible();
    }

    public int getOrientation() {
        return this.getTabBar().getOrientation();
    }

    public Color getContentBackground() {
        return this.getTabBar().getItemBackground();
    }

    public TabStyle getTabStyle() {
        return this.getTabBar().getStyle();
    }

    public void setTabStyle(TabStyle tabStyle) {
        this.getTabBar().setStyle(tabStyle);
    }

    public void addTabPanelListener(TabPanelListener tabPanelListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(tabPanelListener);
    }

    public void removeTabPanelListener(TabPanelListener tabPanelListener) {
        this._listeners.removeListener(tabPanelListener);
    }

    public void tabBarSelectionChanged(TabBarEvent tabBarEvent) {
        TabPanelPage tabPanelPage;
        TabPanel tabPanel = this;
        synchronized (tabPanel) {
            TabBarItem tabBarItem;
            tabPanelPage = this.getSelectedPage();
            if (tabPanelPage != null) {
                this._sheet.repaintItemBorder(this._getItemForPage(tabPanelPage));
            }
            if ((tabBarItem = tabBarEvent.getItem()) == null) {
                tabPanelPage = null;
            } else {
                this._sheet.repaintItemBorder(tabBarItem);
                tabPanelPage = this.getPage(tabBarItem.indexOf());
            }
            this.setSelectedPage(tabPanelPage);
            if (this._showTask == null) {
                this._showTask = new ShowTask();
            }
            _sTaskScheduler.schedule(this._showTask, 200);
        }
        this.processEvent(new TabPanelEvent(this, 2001, tabPanelPage));
    }

    public void tabBarSelectionChanging(TabBarEvent tabBarEvent) {
        TabBarItem tabBarItem = tabBarEvent.getItem();
        TabPanelPage tabPanelPage = this.getPage(tabBarItem.indexOf());
        TabPanelValidateEvent tabPanelValidateEvent = new TabPanelValidateEvent(this, 2000, tabPanelPage);
        this.processEvent(tabPanelValidateEvent);
        if (tabPanelValidateEvent.isCancelled()) {
            ((Cancelable)((Object)tabBarEvent)).cancel();
        }
    }

    public void tabBarLayoutChanged(TabBarEvent tabBarEvent) {
        this._sheet.repaintAllItems();
    }

    public synchronized void enable() {
        this.getTabBar().setEnabled(true);
        super.enable();
    }

    public synchronized void disable() {
        this.getTabBar().setEnabled(false);
        super.disable();
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TabPanelEvent) {
            this.processTabPanelEvent((TabPanelEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processTabPanelEvent(TabPanelEvent tabPanelEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                TabPanelListener tabPanelListener = (TabPanelListener)enumeration.nextElement();
                switch (tabPanelEvent.getID()) {
                    case 2000: {
                        tabPanelListener.tabPanelSelectionChanging(tabPanelEvent);
                        break;
                    }
                    case 2001: {
                        tabPanelListener.tabPanelSelectionChanged(tabPanelEvent);
                        break;
                    }
                }
            }
        }
    }

    protected TabBar getTabBar() {
        return this._tabBar;
    }

    protected TabBar createTabBar(TabStyle tabStyle) {
        return new TabBar(tabStyle);
    }

    protected void setSelectedPage(TabPanelPage tabPanelPage) {
        this._selectedPage = tabPanelPage;
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    void setContent(Component component, TabPanelPage tabPanelPage) {
        if (component == null) {
            throw new NullPointerException();
        }
        this._sheet.remove(tabPanelPage.getContent());
        tabPanelPage.setPageContent(component);
        component.setVisible(false);
        this._sheet.add(tabPanelPage.getLabel(), component);
        if (this.getSelectedPage() == tabPanelPage) {
            this._displaySelectedContents();
        }
    }

    void _setLabel(String string, TabPanelPage tabPanelPage) {
        Component component = tabPanelPage.getContent();
        this._sheet.remove(component);
        this._sheet.add(string, component);
        if (this.getSelectedPage() == tabPanelPage) {
            component.setVisible(false);
            this._displaySelectedContents();
        }
    }

    void _displaySelectedContents() {
        TabBarItem tabBarItem = this.getTabBar().getSelectedItem();
        if (tabBarItem != null) {
            this._sheet.displayContents(this.getSelectedPage().getContent());
        }
    }

    private TabBarItem _getItemForPage(TabPanelPage tabPanelPage) {
        return tabPanelPage.getTabBarItem();
    }

    static {
        _sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    }

    private class ShowTask
    implements Task {
        public void runTask(TaskEvent taskEvent) {
            TabPanel.this._displaySelectedContents();
        }

        ShowTask() {
            TabPanel.this = TabPanel.this;
        }
    }
}

