/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.border.SeparatorBorder;
import oracle.ewt.graphics.separator.InsetSeparatorPainter;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.lwAWT.BufferedPanel;
import oracle.ewt.splitter.Splitter;
import oracle.help.HelpBook;
import oracle.help.context.GlobalContext;
import oracle.help.navigator.CharsetEvent;
import oracle.help.navigator.CharsetListener;
import oracle.help.navigator.NavigatorMenuBar;
import oracle.help.navigator.NavigatorPanel;
import oracle.help.navigator.NavigatorTree;
import oracle.help.navigator.OptionsDialog;
import oracle.help.topicWindow.TopicWindowPanel;
import oracle.help.util.AboutBox;
import oracle.help.util.Library;
import oracle.help.util.LibraryEvent;
import oracle.help.util.LibraryListener;
import oracle.help.util.TreeNode;

public class NavigatorWindow
extends BufferedFrame
implements ActionListener,
ItemListener,
CharsetListener,
LibraryListener {
    private NavigatorMenuBar _menubar;
    private boolean _isDocked;
    private NavigatorPanel _navPanel;
    private BufferedPanel _bufferedPanel;
    private TopicWindowPanel _twPanel;
    private NavigatorTree _tree;
    private GlobalContext _context;
    private Splitter _splitter;

    public NavigatorWindow(GlobalContext globalContext) {
        this._context = globalContext;
        this._bufferedPanel = new BufferedPanel();
        this._bufferedPanel.setLayout(new BorderLayout());
        this.add((Component)this._bufferedPanel, "Center");
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Generic", Locale.getDefault());
        this.setTitle(resourceBundle.getString("navigator.title"));
        ((Component)this).setBackground(Color.lightGray);
        Dimension dimension = NavigatorWindow.GetInitialSize();
        ((Component)this).setSize(dimension.width, dimension.height);
        this._menubar = new NavigatorMenuBar(this);
        this._menubar.setEnableAll(false);
        this.setMenuBar(this._menubar);
        this._isDocked = false;
        this._splitter = new Splitter(false);
        this._navPanel = new NavigatorPanel(this, this._context);
        this._tree = this._navPanel.getNavigatorTree();
        this._navPanel.setBorder(new SeparatorBorder(2, InsetSeparatorPainter.getSeparatorPainter(), 0));
        this._bufferedPanel.add((Component)this._splitter, "Center");
        this._splitter.add(this._navPanel);
        this.enableEvents(64L);
        this.addNotify();
        globalContext.getLibrary().addLibraryListener(this);
        this._updateMenus();
    }

    public void dockTopicWindowPanel(TopicWindowPanel topicWindowPanel, Dimension dimension) {
        this._menubar.setDockedState();
        if (this._isDocked) {
            this._splitter.remove(this._twPanel);
        }
        this._twPanel = topicWindowPanel;
        this._isDocked = true;
        int n = this.getSize().width + dimension.width + this._splitter.getSeparator().getSize();
        int n2 = this.getSize().height;
        if (this.getSize().height < dimension.height) {
            n2 = dimension.height;
        }
        ((Component)this).setSize(n, n2);
        this._splitter.add(this._twPanel);
        this._splitter.setSplitterPosition(n - dimension.width - this._splitter.getSeparator().getSize() - 1);
        this._twPanel.setNavigatorWindow(this);
        this._updateMenus();
        this._navPanel.syncMenus();
        this._twPanel.setSyncGoMenu(this._menubar);
    }

    public void undockTopicPanel(boolean bl, boolean bl2) {
        if (!this._isDocked) {
            return;
        }
        this._menubar.setUndockedState();
        this._isDocked = false;
        this._updateMenus();
        this._navPanel.syncMenus();
        this._splitter.remove(this._twPanel);
        ((Component)this).setSize(this._navPanel.getSize().width, this.getSize().height);
        Dimension dimension = new Dimension();
        dimension.width = this._twPanel.getSize().width + this.getInsets().left + this.getInsets().right;
        dimension.height = this.getSize().height;
        if (bl) {
            this._context.undockTopicWindowPanel(this._twPanel, dimension);
        }
        this._isDocked = false;
        this._twPanel = null;
    }

    public boolean isDocked() {
        return this._isDocked;
    }

    public void displayNode(TreeNode treeNode, boolean bl) {
        if (treeNode == null || treeNode.isBranch()) {
            return;
        }
        try {
            URL uRL = new URL(String.valueOf(treeNode.getRoot().getBaseURL()) + treeNode.getUrl());
            this.displayUrl(treeNode.getRoot().getBook(), uRL, bl);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void displayUrl(HelpBook helpBook, URL uRL, boolean bl) {
        if (!bl && this._isDocked) {
            this.displayUrlDocked(helpBook, uRL);
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        this._context.displayURL(helpBook, uRL, bl);
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    public void displayUrlDocked(HelpBook helpBook, URL uRL) {
        if (this._isDocked) {
            this._twPanel.displayUrl(helpBook, uRL);
        }
    }

    public URL getDockedUrl() {
        if (this._isDocked) {
            return this._twPanel.getURL();
        }
        return null;
    }

    public HelpBook getDockedBook() {
        if (this._isDocked) {
            return this._twPanel.getBook();
        }
        return null;
    }

    public void showContents() {
        this._navPanel.setContentsPage();
    }

    public void showIndex() {
        this._navPanel.setIndexPage();
    }

    public boolean isContentsVisible() {
        if (this._navPanel == null) {
            return false;
        }
        return this._navPanel.isContentsVisible();
    }

    public boolean isIndexVisible() {
        if (this._navPanel == null) {
            return false;
        }
        return this._navPanel.isIndexVisible();
    }

    public void search() {
        this._context.showSearchDialog();
    }

    public void showOptionsDialog() {
        Point point = this.getLocation();
        OptionsDialog optionsDialog = this._context.getOptionsDialog();
        optionsDialog.addCharsetListener(this);
        if (this._isDocked) {
            optionsDialog.setMakeDefault(false);
            optionsDialog.setCharset(this._twPanel.getCharset());
        } else {
            optionsDialog.setMakeDefault(true);
            optionsDialog.setCharset(this._context.getDefaultCharset());
        }
        ((Component)optionsDialog).setLocation(point.x + 100, point.y + 100);
        optionsDialog.show();
        optionsDialog.removeCharsetListener(this);
    }

    public void charsetChanged(CharsetEvent charsetEvent) {
        if (charsetEvent.makeDefault()) {
            this._context.setDefaultCharset(charsetEvent.getCharset());
            return;
        }
        this.setCharset(charsetEvent.getCharset());
    }

    public void libraryChanged(LibraryEvent libraryEvent) {
        this._updateMenus();
    }

    public NavigatorMenuBar getMenubar() {
        return this._menubar;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (itemEvent.getStateChange() != 1 && itemEvent.getStateChange() != 2) {
            return;
        }
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        String string = checkboxMenuItem.getLabel();
        if (string.equals("Contents")) {
            bl = true;
        } else if (string.equals("Index")) {
            bl = false;
        } else {
            return;
        }
        if (bl) {
            this.showContents();
            return;
        }
        this.showIndex();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        String string = menuItem.getActionCommand();
        if (string.equals("Display")) {
            this.displayNode(this._navPanel.getActiveNode(), false);
            return;
        }
        if (string.equals("Display_New")) {
            this.displayNode(this._navPanel.getActiveNode(), true);
            return;
        }
        if (string.equals("Close")) {
            this.closeWindow();
            return;
        }
        if (string.equals("Exit")) {
            this._context.setVisible(false);
            return;
        }
        if (string.equals("Contents")) {
            this.showContents();
            return;
        }
        if (string.equals("Index")) {
            this.showIndex();
            return;
        }
        if (string.equals("Expand")) {
            this._tree.expandSelectedNode();
            return;
        }
        if (string.equals("Collapse")) {
            this._tree.collapseSelectedNode();
            return;
        }
        if (string.equals("Expand_All")) {
            this._tree.expandAll();
            return;
        }
        if (string.equals("Collapse_All")) {
            this._tree.collapseAll();
            return;
        }
        if (string.equals("Refresh")) {
            this.refresh();
            return;
        }
        if (string.equals("Back")) {
            this._twPanel.goBack();
            return;
        }
        if (string.equals("Forward")) {
            this._twPanel.goForward();
            return;
        }
        if (string.equals("Search")) {
            this.search();
            return;
        }
        if (string.equals("Preferences")) {
            this.showOptionsDialog();
            return;
        }
        if (string.equals("Undock")) {
            this.undockTopicPanel(true, true);
            return;
        }
        if (string.equals("About")) {
            AboutBox aboutBox = AboutBox.getAboutBox(this);
            Point point = this.getLocation();
            ((Component)aboutBox).setLocation(point.x + 24, point.y + 24);
            aboutBox.show();
            return;
        }
        if (string.equals("HelpOnHelp")) {
            this._context.showHelpOnHelp();
            return;
        }
        if (string.equals("PrintTree")) {
            this._tree.printTree();
            return;
        }
        if (string.equals("PrintTopic")) {
            this._twPanel.printTopic();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.closeWindow();
        } else if (windowEvent.getID() == 205) {
            if (this.isDocked()) {
                this._context.setCurrentWindow(null);
            }
            this.refresh();
        }
        super.processWindowEvent(windowEvent);
    }

    public void refresh() {
        if (this._navPanel == null || !this._navPanel.isContentsVisible()) {
            return;
        }
        URL uRL = null;
        uRL = this._context.getCurrentWindowUrl();
        if (this._navPanel != null) {
            this._navPanel.refreshBooks();
        }
        if (this._tree != null) {
            if (uRL != null) {
                this._tree.makeNodeVisible(uRL, this._context.getCurrentWindowBook());
                return;
            }
            this._tree.deselectAll();
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this._navPanel.refreshBooks();
            this.refresh();
        }
    }

    public void closeWindow() {
        this.setVisible(false);
        if (this._isDocked) {
            this.undockTopicPanel(false, false);
        }
    }

    public void setCharset(String string) {
        if (this._isDocked) {
            this._twPanel.setCharset(string);
        }
    }

    private static Dimension GetInitialSize() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults");
        String string = resourceBundle.getString("navigator.width");
        String string2 = resourceBundle.getString("navigator.height");
        Dimension dimension = new Dimension(Integer.parseInt(string), Integer.parseInt(string2));
        return dimension;
    }

    private void _updateMenus() {
        Library library = this._context.getLibrary();
        NavigatorMenuBar navigatorMenuBar = this.getMenubar();
        if (library.getVisibleBookCount() == 0) {
            this._navPanel.setEnabled(false);
            navigatorMenuBar.setContentsIndexEnabled(false);
            return;
        }
        HelpBook[] helpBookArray = library.getVisibleBooks();
        boolean bl = false;
        int n = 0;
        while (n < helpBookArray.length) {
            if (helpBookArray[n].containsToc()) {
                bl = true;
                break;
            }
            ++n;
        }
        this._navPanel.setContentsEnabled(bl);
        bl = false;
        int n2 = 0;
        while (n2 < helpBookArray.length) {
            if (helpBookArray[n2].containsIndex()) {
                bl = true;
                break;
            }
            ++n2;
        }
        this._navPanel.setIndexEnabled(bl);
        bl = false;
        int n3 = 0;
        while (n3 < helpBookArray.length) {
            if (helpBookArray[n3].containsSearch()) {
                bl = true;
                break;
            }
            ++n3;
        }
        this._navPanel.setSearchEnabled(bl);
    }
}

