/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LETextField;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.PropertyResourceBundle;

public class LEBackupReqPage
extends LEWizardDataPage
implements ItemListener,
ActionListener {
    public static final String NO_FILE = "You did not specify a backup file.";
    public static final String BROWSE = "Browse";
    private static final String INSTRUCTION_TAG = "BACKUPREQ_INST";
    private static final String HELP_TAG = "Back_Up";
    private static final String TITLE_TAG = "BACKUPREQ_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    Frame m_topFrame = LEUiUtils.GetBaseFrame();
    Checkbox m_backup;
    Label m_loclabel;
    LETextField m_location;
    Button m_browse;
    PropertyResourceBundle m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);

    public LEBackupReqPage(LEWizardDataModel model) {
        super(model);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        String s = new String("Do you want to make a backup file?");
        this.m_component = new Label(s);
        Panel backupConfirm = new Panel();
        backupConfirm.add(this.m_component);
        CheckboxGroup backupGroup = new CheckboxGroup();
        this.m_backup = new Checkbox("Yes", true, backupGroup);
        this.m_backup.addItemListener(this);
        backupConfirm.add(this.m_backup);
        Checkbox nobackup = new Checkbox("No", false, backupGroup);
        nobackup.addItemListener(this);
        backupConfirm.add(nobackup);
        this.m_panel.add((Component)backupConfirm, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        s = new String("Set the location of your backup file:");
        this.m_loclabel = new Label(s);
        this.m_panel.add((Component)this.m_loclabel, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_location = new LETextField(50);
        this.m_location.setLimitLength(false);
        String backupDir = LEAppInfo.getUserAppDir();
        String backupFile = this.m_model.get(LEPMWizardModel.BACKUP_FILE);
        ((TextComponent)this.m_location).setText(LEAppInfo.createFullPath(backupDir, backupFile));
        this.m_panel.add((Component)this.m_location, this.m_gbc);
        this.m_gbc.insets.right = 0;
        this.m_gbc.insets.left = 0;
        this.m_browse = new Button(BROWSE);
        this.m_browse.setActionCommand(BROWSE);
        this.m_browse.addActionListener(this);
        this.m_panel.add((Component)this.m_browse, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        if (this.m_backup.getState()) {
            String loc = this.m_location.getText();
            String sep = System.getProperty("file.separator");
            int pos = loc.lastIndexOf(sep);
            String file = loc.substring(pos + 1);
            String path = loc.substring(0, pos);
            if (file.equals("") || path.equals("")) {
                this.m_problem = NO_FILE;
                return false;
            }
            this.m_model.set(LEPMWizardModel.BACKUP_DIR, path);
            this.m_model.set(LEPMWizardModel.BACKUP_FILE, file);
        } else {
            this.m_model.set(LEPMWizardModel.BACKUP_DIR, "");
            this.m_model.set(LEPMWizardModel.BACKUP_FILE, "");
        }
        return true;
    }

    public Panel getPanel() {
        Panel panel = this.m_panel;
        if (this.m_panel == null) {
            this.m_panel = panel = this.createPanel();
        } else {
            this.m_loclabel.setEnabled(true);
            if (!this.m_backup.getState()) {
                this.m_loclabel.setEnabled(false);
            }
            this.m_loclabel.invalidate();
            this.m_loclabel.validate();
        }
        return panel;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_backup.getState()) {
            this.m_loclabel.setEnabled(true);
            this.m_location.setEnabled(true);
            this.m_browse.setEnabled(true);
        } else {
            this.m_loclabel.setEnabled(false);
            this.m_location.setEnabled(false);
            this.m_browse.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals(BROWSE)) {
            this.browse();
        }
    }

    private void browse() {
        String loc = this.m_location.getText();
        String sep = System.getProperty("file.separator");
        int pos = loc.lastIndexOf(sep);
        String file = loc.substring(pos + 1);
        String dir_path = loc.substring(0, pos);
        FileDialog fd = new FileDialog(this.m_topFrame, "Save Configuration", 1);
        fd.setDirectory(dir_path);
        fd.setFile(file);
        fd.show();
        dir_path = fd.getDirectory();
        file = fd.getFile();
        if (file != null) {
            String path = LEAppInfo.createFullPath(dir_path, file);
            ((TextComponent)this.m_location).setText(path);
        }
    }
}

