/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LETextField;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.util.PropertyResourceBundle;

public class LEHighWaterPage
extends LEWizardDataPage {
    public static final String BAD_MARK = "The high water is too large.";
    private static final String INSTRUCTION_TAG = "HIGHWATER_INST";
    private static final String HELP_TAG = "";
    private static final String TITLE_TAG = "HIGHWATER_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    LETextField m_water;
    static LEVector s_template_keys;
    PropertyResourceBundle m_resource;

    public LEHighWaterPage(LEWizardDataModel model) {
        super(model);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
    }

    public Panel createPanel() {
        super.createPanel();
        this.m_component = new Label("Enter the high water mark:");
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_water = new LETextField(5);
        ((TextComponent)this.m_water).setText(this.m_model.get(LEPMWizardModel.HIGHWATER));
        this.m_water.setNumeric(true);
        this.m_panel.add((Component)this.m_water, this.m_gbc);
        this.m_component = new Label("bytes");
        this.m_panel.add(this.m_component, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        String water = this.m_water.getText();
        int water_val = Integer.parseInt(water);
        if (water_val > 65535) {
            this.m_problem = BAD_MARK;
            return false;
        }
        this.m_model.set(LEPMWizardModel.HIGHWATER, water);
        return true;
    }

    public static LEVector GetTemplateKeys() {
        if (s_template_keys == null) {
            s_template_keys = new LEVector();
            s_template_keys.add("high_water");
        }
        return s_template_keys;
    }
}

