/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.util.LEAppInfo;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.PropertyResourceBundle;

public class LESummary_Page
extends LEWizardDataPage {
    private static final String INSTRUCTION_TAG = "PM_SUMMARY_INST";
    private static final String HELP_TAG = "Summary";
    private static final String TITLE_TAG = "PM_SUMMARY_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    static final int MIN_NUM_CONFIG_ENTRIES = 100;
    int m_numRows;
    int m_loc;
    LECompGrid m_summaryGrid;
    Label[][] m_summary;
    LEScrollablePanel m_scrollablePanel;
    LEScrollPanel m_scrollPanel;
    String m_model_type;
    PropertyResourceBundle m_resource;

    public LESummary_Page(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        this.setTitle(this.m_resource.getString(TITLE_TAG));
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.m_model_type = lEWizardDataModel.get(LEPMWizardModel.MODEL_TYPE);
        this.setHelpTag(HELP_TAG);
        this.m_panel = null;
    }

    public Panel createPanel() {
        BorderLayout borderLayout = new BorderLayout();
        LEBorderPanel lEBorderPanel = new LEBorderPanel(2);
        lEBorderPanel.setInsets(4, 8, 4, 4);
        lEBorderPanel.setLayout(borderLayout);
        this.updateSummary();
        this.m_scrollablePanel = new LEScrollablePanel(this.m_summaryGrid, true, false);
        this.m_scrollPanel = new LEScrollPanel(this.m_scrollablePanel);
        this.m_component = this.m_scrollPanel;
        lEBorderPanel.add("Center", this.m_component);
        return lEBorderPanel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        return true;
    }

    public void updateSummary() {
        this.fillSummary();
        this.m_summaryGrid = new LECompGrid(this.m_summary, 0);
    }

    public Panel getPanel() {
        Panel panel = this.m_panel;
        if (this.m_panel == null) {
            this.m_panel = panel = this.createPanel();
        } else {
            this.m_panel.removeAll();
            this.fillSummary();
            this.m_summaryGrid = new LECompGrid(this.m_summary, 0);
            this.m_scrollablePanel = new LEScrollablePanel(this.m_summaryGrid, true, false);
            this.m_scrollPanel = new LEScrollPanel(this.m_scrollablePanel);
            this.m_component = this.m_scrollPanel;
            this.m_panel.add("Center", this.m_component);
        }
        return panel;
    }

    private void fillSummary() {
        Object object;
        this.m_loc = 0;
        this.m_numRows = 100;
        String string = this.m_model.get(LEPMWizardModel.MODEL_TYPE);
        this.m_summary = new Label[this.m_numRows][2];
        this.m_summary[this.m_loc][0] = new Label("System name: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.SYSTEM_NAME));
        ++this.m_loc;
        if (string.equals("PM-3")) {
            this.m_summary[this.m_loc][0] = new Label("Internet address:");
        } else if (string.equals("PM-4")) {
            this.m_summary[this.m_loc][0] = new Label("Ether1 address:");
        }
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMWizardModel.IPADDRESS));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Netmask: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMWizardModel.NETMASK));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Gateway: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMWizardModel.GATEWAY));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Loghost: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.LOGHOST));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Name service: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.NAMESERVICE));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Name server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.NAMESERVER));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Domain name: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.DOMAIN));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Default routing: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.DEFAULT_ROUTES));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("RIP routing: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMWizardModel.ROUTING));
        ++this.m_loc;
        if (string.equals("PM-3")) {
            this.m_summary[this.m_loc][0] = new Label("Address pool base: ");
            this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.POOL_ADDRESS));
            ++this.m_loc;
            this.m_summary[this.m_loc][0] = new Label("Address pool size: ");
            this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.POOL_SIZE));
            ++this.m_loc;
        }
        this.m_summary[this.m_loc][0] = new Label("Radius authentication server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.RADIUS_SERVER));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Radius authentication alternate server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.RADIUS_SERVER2));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Radius accounting server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.RADIUS_ACCOUNTING));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("Radius accounting alternate server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.RADIUS_ACCOUNTING2));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("ChoiceNet server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.CHOICENET_SERVER));
        ++this.m_loc;
        this.m_summary[this.m_loc][0] = new Label("ChoiceNet alternate server: ");
        this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.CHOICENET_SERVER2));
        ++this.m_loc;
        if (string.equals("PM-3")) {
            object = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
            if (((LEPortMaster)object).get("131072") != null) {
                this.fillLinesSummary(this.m_model);
            }
        } else if (string.equals("PM-4")) {
            this.fillBoardsSummary();
        }
        if (string.equals("PM-3") && !this.m_model.get(LEPMDataModel.MCPPP).equals("")) {
            this.m_summary[this.m_loc][0] = new Label("Multichassis PPP endpoint: ");
            this.m_summary[this.m_loc][1] = new Label(this.m_model.get(LEPMDataModel.MCPPP));
            ++this.m_loc;
        }
        if (!this.m_model.get(LEPMWizardModel.BACKUP_DIR).equals("")) {
            this.m_summary[this.m_loc][0] = new Label("Backup file: ");
            object = LEAppInfo.createFullPath(this.m_model.get(LEPMWizardModel.BACKUP_DIR), this.m_model.get(LEPMWizardModel.BACKUP_FILE));
            this.m_summary[this.m_loc][1] = new Label((String)object);
            ++this.m_loc;
        }
    }

    private void determineLines() {
    }

    private void fillLinesSummary(LEWizardDataModel lEWizardDataModel) {
        lEWizardDataModel.get(LEPMDataModel.ISDN_SWITCH);
        String string = lEWizardDataModel.get(LEPMDataModel.LINE_TYPE);
        String string2 = lEWizardDataModel.get(LEPMDataModel.LINE_TYPE_2);
        String string3 = lEWizardDataModel.get(LEPMDataModel.LINE_TYPE_3);
        String string4 = lEWizardDataModel.get(LEPMDataModel.LINE_TYPE_4);
        String string5 = lEWizardDataModel.get(LEPMDataModel.CLOCKING);
        this.m_summary[this.m_loc][0] = new Label("Line type for line0: ");
        this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.LINE_TYPE));
        ++this.m_loc;
        if (string.equals("ISDN")) {
            this.m_summary[this.m_loc][0] = new Label("ISDN switch type: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ISDN_SWITCH));
            ++this.m_loc;
        } else if (string.equals("Channelized T1")) {
            this.m_summary[this.m_loc][0] = new Label("Line0 signaling: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.SIGNALING));
            ++this.m_loc;
        }
        if (!string.equals("ISDN")) {
            this.m_summary[this.m_loc][0] = new Label("Line0 framing: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.FRAMING));
            ++this.m_loc;
            this.m_summary[this.m_loc][0] = new Label("Line0 encoding: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ENCODING));
            ++this.m_loc;
        }
        if (!string2.equals("")) {
            this.m_summary[this.m_loc][0] = new Label("Line type for line1: ");
            this.m_summary[this.m_loc][1] = new Label(string2);
            ++this.m_loc;
        }
        if (string2.equals("Channelized T1")) {
            this.m_summary[this.m_loc][0] = new Label("Line1 signaling: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.SIGNALING_2));
            ++this.m_loc;
        }
        if (!string2.equals("ISDN")) {
            this.m_summary[this.m_loc][0] = new Label("Line1 framing: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.FRAMING_2));
            ++this.m_loc;
            this.m_summary[this.m_loc][0] = new Label("Line1 encoding: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ENCODING_2));
            ++this.m_loc;
        }
        if (!string.equals("ISDN") && string2.equals("ISDN")) {
            this.m_summary[this.m_loc][0] = new Label("ISDN switch type: ");
            this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ISDN_SWITCH));
            ++this.m_loc;
        }
        if (string3 != null) {
            this.m_summary[this.m_loc][0] = new Label("Line type for line2: ");
            this.m_summary[this.m_loc][1] = new Label(string3);
            ++this.m_loc;
            if (string3.equals("Channelized T1")) {
                this.m_summary[this.m_loc][0] = new Label("Line2 signaling: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.SIGNALING_3));
                ++this.m_loc;
            }
            if (!string3.equals("ISDN")) {
                this.m_summary[this.m_loc][0] = new Label("Line2 framing: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.FRAMING_3));
                ++this.m_loc;
                this.m_summary[this.m_loc][0] = new Label("Line2 encoding: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ENCODING_3));
                ++this.m_loc;
            }
            if (!string.equals("ISDN") && !string2.equals("ISDN") && string3.equals("ISDN")) {
                this.m_summary[this.m_loc][0] = new Label("ISDN Switch type: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ISDN_SWITCH));
                ++this.m_loc;
            }
            if (string5 != null) {
                this.m_summary[this.m_loc][0] = new Label("Clocking for line2: ");
                this.m_summary[this.m_loc][1] = new Label(string5);
                ++this.m_loc;
            }
        }
        if (string4 != null) {
            this.m_summary[this.m_loc][0] = new Label("Line type for line3: ");
            this.m_summary[this.m_loc][1] = new Label(string4);
            ++this.m_loc;
            if (string4.equals("Channelized T1")) {
                this.m_summary[this.m_loc][0] = new Label("Line3 signaling: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.SIGNALING_4));
                ++this.m_loc;
            }
            if (!string4.equals("ISDN")) {
                this.m_summary[this.m_loc][0] = new Label("Line3 framing: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.FRAMING_4));
                ++this.m_loc;
                this.m_summary[this.m_loc][0] = new Label("Line3 encoding: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ENCODING_4));
                ++this.m_loc;
            }
            if (!string.equals("ISDN") && !string2.equals("ISDN") && !string3.equals("ISDN") && string4.equals("ISDN")) {
                this.m_summary[this.m_loc][0] = new Label("ISDN switch type: ");
                this.m_summary[this.m_loc][1] = new Label(lEWizardDataModel.get(LEPMDataModel.ISDN_SWITCH));
                ++this.m_loc;
            }
        }
    }

    private void fillBoardsSummary() {
        int n;
        int n2 = n = LEPMDataModel.SLOT0.intValue();
        while (n2 <= n + 10) {
            LEPMDataModel lEPMDataModel = (LEPMDataModel)this.m_model.getObject(new Integer(n2));
            if (lEPMDataModel != null) {
                String string = lEPMDataModel.get(LEPMWizardModel.MODEL_TYPE);
                if (string.equals("Quad T1") || string.equals("Tri E1")) {
                    this.m_summary[this.m_loc][0] = new Label("Board info for slot " + lEPMDataModel.get(LEPMDataModel.SLOT_NUM));
                    this.m_summary[this.m_loc][0].setFont(LEFont.getBoldFont());
                    this.m_summary[this.m_loc][1] = new Label("");
                    ++this.m_loc;
                    this.m_summary[this.m_loc][0] = new Label("Address pool base: ");
                    this.m_summary[this.m_loc][1] = new Label(lEPMDataModel.get(LEPMDataModel.POOL_ADDRESS));
                    ++this.m_loc;
                    this.m_summary[this.m_loc][0] = new Label("Address pool size: ");
                    this.m_summary[this.m_loc][1] = new Label(lEPMDataModel.get(LEPMDataModel.POOL_SIZE));
                    ++this.m_loc;
                    this.fillLinesSummary(lEPMDataModel);
                } else if (string.equals("System Manager")) {
                    this.m_summary[this.m_loc][0] = new Label("Ether0 info ");
                    this.m_summary[this.m_loc][0].setFont(LEFont.getBoldFont());
                    this.m_summary[this.m_loc][1] = new Label("");
                    ++this.m_loc;
                    this.m_summary[this.m_loc][0] = new Label("Internet address: ");
                    this.m_summary[this.m_loc][1] = new Label(lEPMDataModel.get(LEPMWizardModel.IPADDRESS));
                    ++this.m_loc;
                    this.m_summary[this.m_loc][0] = new Label("Netmask: ");
                    this.m_summary[this.m_loc][1] = new Label(lEPMDataModel.get(LEPMWizardModel.NETMASK));
                    ++this.m_loc;
                    this.m_summary[this.m_loc][0] = new Label("RIP packet routing: ");
                    this.m_summary[this.m_loc][1] = new Label(lEPMDataModel.get(LEPMWizardModel.ROUTING));
                    ++this.m_loc;
                }
            }
            ++n2;
        }
    }
}

