/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.io.File;
import java.io.FilenameFilter;

class FileUtils {
    private FileUtils() {
    }

    public static boolean areDirectoriesEqual(File file, File file2) {
        int n;
        String string;
        if (file.equals(file2)) {
            return true;
        }
        String string2 = FileUtils._removeTrailingSeparator(file.getPath());
        if (string2.equals(string = FileUtils._removeTrailingSeparator(file2.getPath()))) {
            return true;
        }
        return FileUtils._isWindowsDirectory(string2) && FileUtils._isWindowsDirectory(string) && (n = string2.length()) == string.length() && string2.regionMatches(true, 0, string, 0, 1) && string2.regionMatches(false, 1, string, 1, n - 1);
    }

    public static String getName(File file) {
        String string = file.getPath();
        if (FileUtils._hasTrailingSeparator(string)) {
            file = new File(FileUtils._removeTrailingSeparator(string));
        }
        return file.getName();
    }

    public static String getParent(File file) {
        String string = file.getPath();
        if (FileUtils._hasTrailingSeparator(string)) {
            file = new File(FileUtils._removeTrailingSeparator(string));
        }
        return file.getParent();
    }

    public static boolean isDirectory(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getPath();
            if (!FileUtils._hasTrailingSeparator(string)) {
                File file2 = new File(FileUtils._addTrailingSeparator(string));
                return file2.isDirectory();
            }
        }
        return false;
    }

    public static String[] list(File file, FilenameFilter filenameFilter) {
        String string = file.getPath();
        if (FileUtils._isWindowsDrive(string) && FileUtils._hasTrailingSeparator(string)) {
            file = new File(FileUtils._removeTrailingSeparator(string));
        }
        return file.list(filenameFilter);
    }

    private static String _addTrailingSeparator(String string) {
        if (!FileUtils._hasTrailingSeparator(string)) {
            return String.valueOf(string) + File.separatorChar;
        }
        return string;
    }

    private static boolean _hasTrailingSeparator(String string) {
        int n = string.length();
        return n > 1 && string.charAt(n - 1) == File.separatorChar;
    }

    private static boolean _isWindowsDirectory(String string) {
        return string.length() >= 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':';
    }

    private static boolean _isWindowsDrive(String string) {
        int n = string.length();
        return FileUtils._isWindowsDirectory(string) && (n == 2 || n == 3 && FileUtils._hasTrailingSeparator(string));
    }

    private static String _removeTrailingSeparator(String string) {
        if (FileUtils._hasTrailingSeparator(string)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

