/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import oracle.ewt.graphics.FontUtils;
import oracle.ewt.lwAWT.lwText.AutoScroller;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.StaticTextPosition;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.lwAWT.lwText.displayFilter.DisplayStringFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.IdentityDisplayFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.Range;

public class LWTextField
extends LWCommonText {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    private static final int _DRAW_INSERTION_HACK = 0;
    private static final int _MARGIN_LEFT = 1;
    private static final int _MARGIN_RIGHT = 1;
    private static final int _MARGIN_TOP = 1;
    private static final int _MARGIN_BOTTOM = 1;
    private static final int _MINSIZE_COLUMNS = 10;
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private String _text;
    private boolean _mouseDown;
    private ActionListener _actionListener;
    private DisplayStringFilter _displayFilter = IdentityDisplayFilter.getDisplayStringFilter();

    public LWTextField() {
        this("");
    }

    public LWTextField(String string) {
        this._init(string);
    }

    public LWTextField(int n) {
        this("", n);
    }

    public LWTextField(String string, int n) {
        super(n);
        this._init(string);
    }

    public void setDisplayStringFilter(DisplayStringFilter displayStringFilter) {
        if (displayStringFilter == null) {
            displayStringFilter = IdentityDisplayFilter.getDisplayStringFilter();
        }
        if (this._displayFilter != displayStringFilter) {
            this._displayFilter = displayStringFilter;
            this.repaint(10L);
        }
    }

    public DisplayStringFilter getDisplayStringFilter() {
        return this._displayFilter;
    }

    public void addActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, actionListener);
    }

    public String getText() {
        return this._text;
    }

    public Dimension getPreferredSize() {
        return this._columnsToSize(this.getColumns());
    }

    public Dimension getMinimumSize() {
        int n = this.getColumns();
        int n2 = n <= 10 ? n : 10;
        return this._columnsToSize(n2);
    }

    public void removeNotify() {
        AutoScroller.getAutoScroller().cancel(this);
        super.removeNotify();
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && (mouseEvent.getModifiers() & 0x10) != 0) {
            int n = mouseEvent.getX() - this.getInnerOrigin().x;
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!this.getInnerBounds().contains(mouseEvent.getX(), mouseEvent.getY()) || mouseEvent.getClickCount() != 1) break;
                    TextPosition textPosition = this.getPosition(this.canvasPixelToSelectionIndex(n));
                    if (mouseEvent.isShiftDown()) {
                        this.growSelection(textPosition);
                    } else {
                        this.setCaretPosition(textPosition);
                    }
                    this._mouseDown = true;
                    this.requestFocus();
                    return;
                }
                case 500: {
                    int n2 = mouseEvent.getClickCount();
                    if (n2 <= 1) break;
                    if (n2 == 2) {
                        this._selectWord(this.canvasPixelToSelectionIndex(n));
                        return;
                    }
                    this.selectAll();
                    return;
                }
                case 502: {
                    AutoScroller.getAutoScroller().cancel();
                    this._mouseDown = false;
                    return;
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && this._mouseDown && mouseEvent.getID() == 506) {
            int n;
            AutoScroller autoScroller = AutoScroller.getAutoScroller();
            int n2 = FontUtils.getAverageWidth(this.getFont());
            int n3 = mouseEvent.getX() - this.getInnerOrigin().x;
            if (n3 < n2 || n3 > this.getInnerSize().width - n2) {
                n = n2 + (n2 - 1);
                n = n3 < n2 ? -n : (n -= this.getInnerSize().width);
                autoScroller.schedule(this, (n3 + n) / n2);
            } else {
                autoScroller.cancel();
            }
            n = this.canvasPixelToSelectionIndex(n3);
            this.growSelection(this.getPosition(n));
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
            this.processEvent(new ActionEvent(this, 1001, ""));
            keyEvent.consume();
        }
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    protected Dimension layoutCanvas() {
        return this._calculateCanvasSize();
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = this._isOKToDrawSelection;
        if (rectangle.width > 0 && rectangle.height > 0) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = this._getDrawingAdjustment();
            int n2 = 1 + fontMetrics.getLeading();
            this.getCanvasOrigin();
            String string = this._getDisplayString();
            Color color = null;
            if (!this.isEnabled()) {
                color = graphics.getColor();
                graphics.setColor(SystemColor.textInactiveText);
            }
            if (string != null) {
                graphics.drawString(string, n, n2 + fontMetrics.getAscent());
                if (bl && this.hasFocus()) {
                    this._paintSelection(graphics, n, n2, this.getSelectionStart(), this.getSelectionEnd());
                }
            }
            if (color != null) {
                graphics.setColor(color);
            }
        }
    }

    protected String paramString() {
        String string = super.paramString();
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        if (displayStringFilter != this && displayStringFilter != IdentityDisplayFilter.getDisplayStringFilter()) {
            string = String.valueOf(string) + ", " + displayStringFilter.toString();
        }
        return string;
    }

    int canvasPixelToSelectionIndex(int n) {
        String string = this.getText();
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        int n2 = LWTextField._pixelToIndex(displayStringFilter.convertString(string), this.getFontMetrics(this.getFont()), this._canvasPixelToStringPixel(n));
        return displayStringFilter.displayIndexToValueIndex(string, n2);
    }

    boolean deleteText(boolean bl) {
        Serializable serializable;
        TextPosition textPosition = null;
        boolean bl2 = false;
        if (super.deleteText(bl)) {
            serializable = this;
            synchronized (serializable) {
                int n = this.getTextLength();
                int n2 = this.getSelectionStart();
                boolean bl3 = true;
                if (bl) {
                    if (--n2 < 0) {
                        bl3 = false;
                    }
                } else if (++n2 > n) {
                    bl3 = false;
                }
                bl2 = true;
                if (bl3) {
                    textPosition = this.getPosition(n2);
                }
            }
        }
        if (textPosition != null && (serializable = this.scrollSelectionIntoView(textPosition)) != null) {
            this.setCanvasOrigin(((Point)serializable).x, ((Point)serializable).y);
        }
        return bl2;
    }

    char translateKeyChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return '\u0000';
            }
        }
        return super.translateKeyChar(c);
    }

    TextPosition getPosition(int n) {
        if (n == 0) {
            return StaticTextPosition.getZeroPosition();
        }
        return new StaticTextPosition(n);
    }

    Point scrollSelectionIntoView(TextPosition textPosition) {
        int n = textPosition.getIndex();
        Font font = this.getFont();
        if (font != null) {
            boolean bl;
            String string = this.getText();
            DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
            String string2 = displayStringFilter.convertString(string);
            int n2 = displayStringFilter.valueIndexToDisplayIndex(string, n);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth(string2.substring(0, n2));
            int n4 = this._stringPixelToCanvasPixel(n3);
            int n5 = n4 - 1;
            int n6 = this.getInnerSize().width - 1 - 1;
            int n7 = this.getCanvasOrigin().x;
            boolean bl2 = bl = n5 < 0;
            if (!bl) {
                boolean bl3 = bl = (n5 -= n6) > 0;
                if (!bl && n7 != 0) {
                    bl = (n5 += fontMetrics.stringWidth(string2.substring(n2))) < 0;
                }
            } else {
                int n8 = n6 - fontMetrics.stringWidth(string2.substring(n2));
                if (n8 > 0) {
                    n5 -= n8;
                }
            }
            if (bl) {
                if ((n7 -= n5) > 0) {
                    n7 = 0;
                }
                return new Point(n7, 0);
            }
        }
        return null;
    }

    Rectangle replaceRangeValue(String string, int n, int n2) {
        this._text = String.valueOf(this._text.substring(0, n)) + string + this._text.substring(n2);
        Dimension dimension = this._calculateCanvasSize();
        this.setCanvasSize(dimension.width, dimension.height);
        Graphics graphics = this.getCanvasGraphics();
        if (graphics != null) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.dispose();
            return rectangle;
        }
        return null;
    }

    Rectangle getSelectionBounds(TextPosition textPosition, TextPosition textPosition2) {
        Dimension dimension = this.getCanvasSize();
        Dimension dimension2 = this.getInnerSize();
        return new Rectangle(0, 0, Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    private int _getAlignmentOffset() {
        int n = 0;
        int n2 = this.getAlignment();
        if (n2 != 0) {
            String string = this._getDisplayString();
            int n3 = string != null ? this.getFontMetrics(this.getFont()).stringWidth(string) : 0;
            n = this.getInnerSize().width - 1 - 1 - n3;
            if (n2 == 2) {
                n >>= 1;
            }
            if (n < 0) {
                n = 0;
            }
        }
        return n;
    }

    private int _canvasPixelToStringPixel(int n) {
        return n - 1 - this.getCanvasOrigin().x - this._getAlignmentOffset();
    }

    private int _getDrawingAdjustment() {
        return 1 + this._getAlignmentOffset();
    }

    private int _stringPixelToCanvasPixel(int n) {
        return n + this.getCanvasOrigin().x + this._getDrawingAdjustment();
    }

    private static int _pixelToIndex(String string, FontMetrics fontMetrics, int n) {
        int n2;
        int n3;
        if (n <= 0 || string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n4 = FontUtils.getAverageWidth(fontMetrics);
        int n5 = n / n4;
        if (n5 > (n3 = cArray.length)) {
            n5 = n3;
        }
        if ((n2 = fontMetrics.charsWidth(cArray, 0, n5)) < n) {
            while (n5 < n3) {
                int n6 = fontMetrics.charWidth(cArray[n5]);
                if ((n2 += n6) > n) {
                    if (n + (n6 >> 1) > n2) {
                        ++n5;
                    }
                    break;
                }
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n2 > n && n5 > 0) {
                n7 = fontMetrics.charWidth(cArray[--n5]);
                n2 -= n7;
            }
            if (n - (n7 >> 1) > n2) {
                ++n5;
            }
        }
        return n5;
    }

    private Dimension _calculateCanvasSize() {
        Font font = this.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            return new Dimension(1 + fontMetrics.stringWidth(this._getDisplayString()) + 1, 1 + fontMetrics.getHeight() + 1);
        }
        return this.getInnerSize();
    }

    private void _paintInsertionPoint(Graphics graphics, FontMetrics fontMetrics, int n, int n2, String string, int n3, int n4, boolean bl) {
        if (bl) {
            if (string != null) {
                n += fontMetrics.stringWidth(string.substring(0, n3));
            }
            graphics.drawLine(n, n2, n, n2 + n4);
        }
    }

    private void _paintSelectionRange(Graphics graphics, FontMetrics fontMetrics, int n, int n2, String string, int n3, int n4, int n5, boolean bl) {
        int n6 = fontMetrics.stringWidth(string.substring(n3, n4));
        graphics.clipRect(n += fontMetrics.stringWidth(string.substring(0, n3)), n2, n6, n5);
        if (bl) {
            graphics.fillRect(n, n2, n6, n5);
            return;
        }
        graphics.drawRect(n, n2, n6 - 1, n5 - 1);
    }

    private Dimension _columnsToSize(int n) {
        FontMetrics fontMetrics;
        int n2 = 0;
        int n3 = 0;
        Font font = this.getFont();
        if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
            n2 = FontUtils.getAverageWidth(fontMetrics) * n;
            n3 = fontMetrics.getHeight();
        }
        return this.convertInnerToOuterSize(n2 + 1 + 1, n3 + 1 + 1);
    }

    private void _selectWord(int n) {
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        String string = this.getText();
        String string2 = displayStringFilter.convertString(string);
        n = displayStringFilter.valueIndexToDisplayIndex(string, n);
        char[] cArray = string2.toCharArray();
        int n2 = LWCommonText.findWordStart(cArray, n);
        n2 = displayStringFilter.displayIndexToValueIndex(string, n2);
        int n3 = LWCommonText.findWordEnd(cArray, n);
        n3 = displayStringFilter.displayIndexToValueIndex(string, n3);
        this.select(n2, n3);
    }

    private void _init(String string) {
        this._text = string;
        this.enableEvents(184L);
    }

    private String _getDisplayString() {
        return this.getDisplayStringFilter().convertString(this.getText());
    }

    private void _paintSelection(Graphics graphics, int n, int n2, int n3, int n4) {
        DisplayStringFilter displayStringFilter = this.getDisplayStringFilter();
        String string = this.getText();
        String string2 = displayStringFilter.convertString(string);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n5 = fontMetrics.getAscent() + fontMetrics.getDescent();
        boolean bl = true;
        if (n3 == n4) {
            this._paintInsertionPoint(graphics, fontMetrics, n += 0, n2, string2, displayStringFilter.valueIndexToDisplayIndex(string, n3), n5, bl);
            return;
        }
        Shape shape = graphics.getClip();
        Color color = graphics.getColor();
        Range[] rangeArray = displayStringFilter.getDisplaySelectionRanges(string, n3, n4);
        int n6 = n2 + fontMetrics.getAscent() + fontMetrics.getLeading();
        int n7 = 0;
        while (n7 < rangeArray.length) {
            graphics.setColor(SystemColor.textHighlight);
            this._paintSelectionRange(graphics, fontMetrics, n, n2, string2, rangeArray[n7].start, rangeArray[n7].end, n5, bl);
            graphics.setColor(SystemColor.textHighlightText);
            graphics.drawString(string2, n, n6);
            graphics.setClip(shape);
            ++n7;
        }
        graphics.setColor(color);
    }
}

