/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.tabBar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;

public abstract class TabStyle {
    private static final int _SELECTED_GROWTH = 2;
    private static final int _MAX_BORDER_WD = 2;

    public void paint(Graphics graphics, TabBarItem tabBarItem) {
        this.drawBorder(graphics, tabBarItem);
        this.drawInterior(graphics, tabBarItem);
    }

    public Dimension getPreferredSize(TabBarItem tabBarItem) {
        int n;
        TabBar tabBar = tabBarItem.getParent();
        Font font = tabBar.getSelectFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = tabBar.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(tabBarItem.getLabel());
        int n3 = fontMetrics.getAscent() + fontMetrics.getDescent() + 2;
        Image image = tabBarItem.getIcon();
        int n4 = n = image != null ? image.getWidth(tabBarItem) : 0;
        n2 = n > 0 ? (n2 += n + n3) : (n2 += n3 / 3 * 2);
        return new Dimension(n2, n3 += this.getVerticalGrowth());
    }

    public int getPreferredOverlap(TabBarItem tabBarItem) {
        return 0;
    }

    public int getVerticalGrowth() {
        return 2;
    }

    protected abstract void drawBorder(Graphics var1, TabBarItem var2);

    protected void drawInterior(Graphics graphics, TabBarItem tabBarItem) {
        Image image;
        int n;
        Rectangle rectangle = tabBarItem.getBounds();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.height;
        TabBar tabBar = tabBarItem.getParent();
        int n5 = tabBar.getOrientation();
        boolean bl = tabBarItem.isSelected();
        Font font = bl ? tabBar.getSelectFont() : tabBar.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        n2 += n4 / 3 + tabBar.getOverlap();
        int n6 = n = n5 == 0 ? 2 + this.getVerticalGrowth() : 0;
        if (bl && tabBar.hasFocus()) {
            GraphicUtils.drawFocusRect(graphics, n2 - 3, n3 + n, rectangle.width - 2 * (n2 - rectangle.x) + 6, n4 - 5);
        }
        if ((image = tabBarItem.getIcon()) != null) {
            int n7 = image.getWidth(tabBarItem);
            int n8 = image.getHeight(tabBarItem);
            if (n4 - 4 > n8) {
                n8 = n4 - 4;
            }
            graphics.drawImage(image, n2, n3 + n, n7, n8, tabBarItem);
            n2 += n7 + n4 / 3;
        }
        n3 += n4 / 2 - fontMetrics.getDescent() + fontMetrics.getHeight() / 2;
        n3 = n5 == 0 ? (n3 += 2) : (n3 -= 2);
        graphics.setFont(font);
        if (tabBarItem.isEnabled()) {
            graphics.drawString(tabBarItem.getLabel(), n2, n3);
            return;
        }
        GraphicUtils.drawDisabledString(graphics, tabBarItem.getLabel(), n2, n3);
    }

    protected final int getOverlap(TabBar tabBar) {
        return tabBar.getOverlap();
    }

    protected final Font getSelectFont(TabBar tabBar) {
        return tabBar.getSelectFont();
    }

    protected final int getAllowedHorizGrowth(TabBar tabBar) {
        return tabBar.getAllowedHorizGrowth();
    }
}

