/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.bootp;

import COM.livingston.bootp.LEBootPPacket;
import COM.livingston.bootp.LEBootPPacketHandler;
import COM.livingston.bootp.LEBootPServer;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import java.io.BufferedReader;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LEBootPARPTableHandler
extends LEBootPPacketHandler {
    private LEOctets m_serverIPAddress;
    private LEOctets m_broadcastIPAddress;
    private Hashtable m_arpTable;

    public LEBootPARPTableHandler(Hashtable hashtable, String string, String string2) throws SecurityException, SocketException {
        this.m_arpTable = hashtable;
        this.m_serverIPAddress = new LEOctets(string);
        this.m_broadcastIPAddress = new LEOctets(string2);
    }

    public LEBootPARPTableHandler(BufferedReader bufferedReader, String string, String string2) throws SecurityException, SocketException {
        this.m_serverIPAddress = new LEOctets(string);
        this.m_broadcastIPAddress = new LEOctets(string2);
        this.createARPTable(bufferedReader);
    }

    public void receivedLEBootPPacket(LEBootPPacket lEBootPPacket) {
        byte[] byArray;
        String string;
        String string2 = lEBootPPacket.getClientIPAddress().toString();
        if (string2.equals("0.0.0.0") && this.m_arpTable != null && this.m_arpTable.containsKey(string = this.convertHardwareAddress(byArray = lEBootPPacket.getClientHardwareAddress(), lEBootPPacket.getHardwareAddressLength()))) {
            String string3 = (String)this.m_arpTable.get(string);
            LEOctets lEOctets = new LEOctets(string3);
            lEBootPPacket.setReply();
            lEBootPPacket.setYourIPAddress(lEOctets);
            lEBootPPacket.setServerIPAddress(this.m_serverIPAddress);
            this.sendBootPPacket(lEBootPPacket);
        }
    }

    public void sendBootPPacket(LEBootPPacket lEBootPPacket) {
        try {
            LEBootPServer.GetServer().sendPacket(lEBootPPacket, this.m_broadcastIPAddress.toString());
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void updateARPTable(Hashtable hashtable) {
        this.m_arpTable = hashtable;
    }

    public Hashtable appendARPTable(Hashtable hashtable) {
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.m_arpTable.containsKey(string)) {
                String string2 = (String)this.m_arpTable.get(string);
                if (string2.equals((String)hashtable.get(string))) continue;
                hashtable2.put(string, string2);
                this.m_arpTable.remove(string);
                this.m_arpTable.put(string, hashtable.get(string));
                continue;
            }
            this.m_arpTable.put(string, hashtable.get(string));
        }
        return hashtable2;
    }

    private String convertHardwareAddress(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(":");
            }
            int n3 = byArray[n2] & 0xF0;
            char c = Character.forDigit(n3 /= 16, 16);
            stringBuffer.append(c);
            n3 = byArray[n2] & 0xF;
            c = Character.forDigit(n3, 16);
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void createARPTable(BufferedReader bufferedReader) {
        this.m_arpTable = new Hashtable();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreElements()) continue;
                String string3 = stringTokenizer.nextToken();
                this.m_arpTable.put(string3, string2);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

