/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardAction;
import COM.livingston.wizard.LEWizardActionClient;
import COM.livingston.wizard.LEWizardDataModel;
import java.io.IOException;

public class LEBackupAction
extends LEWizardAction {
    public LEBackupAction(LEWizardDataModel lEWizardDataModel, LEWizardActionClient lEWizardActionClient) {
        super(lEWizardDataModel, lEWizardActionClient);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart("Saving the configurations to a backup file ");
        this.backupConfig();
    }

    private void backupConfig() {
        LEPortMaster lEPortMaster = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
        if (lEPortMaster == null) {
            this.m_client.actionDone("Could not get the Portmaster", -1);
            return;
        }
        LEVector lEVector = new LEVector();
        if (!lEPortMaster.getCommands(lEVector)) {
            this.m_client.actionDone("Could not get the configurations", -1);
            return;
        }
        String string = LEAppInfo.createFullPath(this.m_model.get(LEPMWizardModel.BACKUP_DIR), this.m_model.get(LEPMWizardModel.BACKUP_FILE));
        LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string, 1);
        String string2 = "IP_ADDRESS ";
        string2 = String.valueOf(string2) + this.m_model.get(LEPMWizardModel.IPADDRESS);
        String string3 = "NET_MASK ";
        string3 = String.valueOf(string3) + this.m_model.get(LEPMWizardModel.NETMASK);
        try {
            lEDSSFlatFile.connect();
            lEDSSFlatFile.writeComments(string2);
            lEDSSFlatFile.writeComments(string3);
            lEDSSFlatFile.writeConfig(lEVector);
            lEDSSFlatFile.disconnect();
        }
        catch (IOException iOException) {
            String string4 = "Could not open the selected backup file.  \n\nPress Retry and verify that the location ";
            string4 = String.valueOf(string4) + "for the backup file exists, or press Cancel to save the current configuration and exit the wizard.";
            this.m_client.actionDone(string4, -1);
            return;
        }
        this.m_client.actionDone(LEThreadStatus.NO_MESSAGE, 0);
    }
}

