/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.pm_wizard.LERestoreAction;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEBusyPanel;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEImageView;
import COM.livingston.ui.LELEDs;
import COM.livingston.ui.LEMultiLineLabel;
import COM.livingston.ui.LEProgressPanel;
import COM.livingston.ui.LETitleBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardAction;
import COM.livingston.wizard.LEWizardActionClient;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import oracle.help.Book;
import oracle.help.Help;

public class LEPMWizPanel
extends Frame
implements ActionListener,
LEWizardActionClient,
LEConfirmClient,
WindowListener {
    public static final String PREVIOUS = new String("previous");
    public static final String NEXT = new String("next");
    public static final String CANCEL = new String("cancel");
    public static final String CONFIG = new String("config");
    public static final String HELP = new String("help");
    public static final String ABOUT = "About";
    private static final String RESOURCE_LOCATION = "resources/PMWizard/pmwizard";
    LEVector m_listeners = new LEVector();
    Button m_previous;
    Button m_next;
    Button m_cancel;
    Button m_config;
    Button m_help;
    LEWizardDataPage m_currentPage;
    LEWizardDataModel m_model;
    LEPMWizardDataIterator m_wizardIterator;
    LEPMWizardActionIterator m_actionIterator;
    LEImageView m_imageView;
    LETitleBar m_panelTitle;
    Panel m_mainPanel;
    Panel m_configPanel;
    Panel m_currentPanel;
    LEMultiLineLabel m_instructions;
    Panel m_buttonPanel;
    Label[] m_configMsg;
    LEProgressPanel m_progress;
    int m_screenWidth;
    int m_screenHeight;
    Help m_Ohelp;
    Book m_book;
    CardLayout m_cardlayout;
    Hashtable m_wizardPanels;
    static /* synthetic */ Class class$pmwizhlp$Pmwizhlp;

    public LEPMWizPanel(LEWizardDataModel lEWizardDataModel) {
        this.addNotify();
        LEUiUtils.SetBaseFrame(this);
        LELEDs.Initialize();
        this.m_model = lEWizardDataModel;
        ((Component)this).setBackground(LEColor.getBackground());
        this.addWindowListener(this);
        PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle(RESOURCE_LOCATION);
        if (propertyResourceBundle != null) {
            this.m_model.putObject(LEPMWizardModel.RESOURCE_BUNDLE, propertyResourceBundle);
        }
        this.m_wizardIterator = new LEPMWizardDataIterator(lEWizardDataModel);
        this.m_actionIterator = new LEPMWizardActionIterator(lEWizardDataModel, this);
        LEStatusManager lEStatusManager = new LEStatusManager();
        this.m_model.putObject(LEPMWizardModel.STATUS_MANAGER, lEStatusManager);
        this.m_model.set(LEPMWizardModel.CONNECTED, "off");
        Image image = LEResource.GetImage("lucent_32.gif");
        if (image instanceof Image) {
            this.setIconImage(image);
        }
        this.setTitle(LEAppInfo.getAppTitle());
        this.m_cardlayout = new CardLayout();
        this.m_currentPanel = new Panel(this.m_cardlayout);
        this.m_wizardPanels = new Hashtable();
        this.m_currentPage = this.m_wizardIterator.firstPage();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.m_screenWidth = dimension.width;
        this.m_screenHeight = dimension.height;
        this.createDataFrame();
        this.m_book = Help.createBook((Class)(class$pmwizhlp$Pmwizhlp != null ? class$pmwizhlp$Pmwizhlp : (class$pmwizhlp$Pmwizhlp = LEPMWizPanel.class$("pmwizhlp.Pmwizhlp"))), (String)".", (String)"Pmwizhlp", (String)"PMWizard Help");
        this.m_Ohelp = new Help();
        if (this.m_book != null) {
            this.m_Ohelp.addBook(this.m_book);
        }
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(PREVIOUS)) {
            this.previousPage();
            return;
        }
        if (string.equals(NEXT)) {
            this.nextPage();
            return;
        }
        if (string.equals(CONFIG)) {
            this.setupConfiguration();
            this.m_actionIterator.addActions();
            this.m_actionIterator.startActions();
            return;
        }
        if (string.equals(CANCEL)) {
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
            if (lEPortMaster instanceof LEPortMaster) {
                lEPortMaster.disconnect();
            }
            System.exit(0);
            return;
        }
        if (string.equals(HELP)) {
            this.showHelp();
        }
    }

    Panel mainPanel() {
        Panel panel = new Panel(new BorderLayout(15, 15));
        this.m_instructions = new LEMultiLineLabel(this.m_currentPage.getInstructions());
        this.m_instructions.setMinHeight(100);
        this.m_instructions.setBorder(10);
        panel.add((Component)this.m_instructions, "North");
        Panel panel2 = this.m_currentPage.getPanel();
        if (this.m_wizardPanels.get(this.m_currentPage.getTitle()) == null) {
            this.m_wizardPanels.put(this.m_currentPage.getTitle(), panel2);
            this.m_currentPanel.add(this.m_currentPage.getTitle(), panel2);
        }
        this.m_cardlayout.show(this.m_currentPanel, this.m_currentPage.getTitle());
        panel.add((Component)this.m_currentPanel, "Center");
        return panel;
    }

    void setInstructions(String string) {
        this.m_mainPanel.remove(this.m_instructions);
        this.m_instructions = new LEMultiLineLabel(string);
        this.m_mainPanel.add((Component)this.m_instructions, "North");
    }

    Panel buttonPanel() {
        Insets insets;
        Panel panel = new Panel(new BorderLayout());
        LETitleBar lETitleBar = new LETitleBar();
        lETitleBar.setBorder(1);
        panel.add((Component)lETitleBar, "North");
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = insets = new Insets(5, 20, 5, 0);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        Button button = this.m_cancel = new Button("Cancel");
        this.m_cancel.addActionListener(this);
        this.m_cancel.setActionCommand(CANCEL);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 20;
        ++gridBagConstraints.gridx;
        button = this.m_previous = new Button("< Back");
        this.m_previous.addActionListener(this);
        this.m_previous.setActionCommand(PREVIOUS);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 0;
        ++gridBagConstraints.gridx;
        button = this.m_next = new Button("Next  >");
        this.m_next.addActionListener(this);
        this.m_next.setActionCommand(NEXT);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 20;
        ++gridBagConstraints.gridx;
        button = this.m_config = new Button("Configure");
        this.m_config.addActionListener(this);
        this.m_config.setActionCommand(CONFIG);
        this.m_config.setEnabled(false);
        panel2.add((Component)button, gridBagConstraints);
        insets.left = 20;
        ++gridBagConstraints.gridx;
        this.m_help = new Button("Help...");
        this.m_help.addActionListener(this);
        this.m_help.setActionCommand(HELP);
        panel2.add((Component)this.m_help, gridBagConstraints);
        panel.add((Component)panel2, "South");
        return panel;
    }

    Panel configurePanel() {
        Panel panel = new Panel(new BorderLayout());
        panel.setBackground(Color.lightGray);
        this.m_progress = new LEProgressPanel((LEStatusManager)this.m_model.getObject(LEPMWizardModel.STATUS_MANAGER));
        panel.add((Component)this.m_progress, "North");
        Panel panel2 = new Panel(new BorderLayout(0, 0));
        Panel panel3 = new Panel(new FlowLayout(1, 0, 0));
        this.m_cancel = new Button("Cancel");
        panel3.add(this.m_cancel);
        panel2.add((Component)panel3, "Center");
        LEBusyPanel lEBusyPanel = new LEBusyPanel(0);
        panel2.add((Component)lEBusyPanel, "East");
        lEBusyPanel.start();
        panel.add((Component)panel2, "South");
        this.m_cancel.addActionListener(this);
        this.m_cancel.setActionCommand(CANCEL);
        return panel;
    }

    public void actionStart(String string) {
    }

    public void updateStatus(String string, int n) {
        ((LEStatusManager)this.m_model.getObject(LEPMWizardModel.STATUS_MANAGER)).setStatus(string, n);
    }

    public void actionDone(String string, int n) {
        if (n == 0) {
            String string2 = new String("The wizard is finished");
            ((LEStatusManager)this.m_model.getObject(LEPMWizardModel.STATUS_MANAGER)).setStatus(String.valueOf(string) + "\n", 101);
            String[] stringArray = new String[]{LEConfirmDialog.OK};
            LEConfirmDialog lEConfirmDialog = new LEConfirmDialog((Frame)this, (LEConfirmClient)this, string2, stringArray, null);
            ((Component)lEConfirmDialog).setVisible(true);
            this.m_cancel.setLabel("Finished");
            return;
        }
        if (n == -1) {
            String[] stringArray = new String[]{"Retry", LEConfirmDialog.CANCEL};
            LEMultiLineLabel lEMultiLineLabel = new LEMultiLineLabel(string);
            lEMultiLineLabel.setMinWidth(400);
            lEMultiLineLabel.setBorder(10);
            LEConfirmDialog lEConfirmDialog = new LEConfirmDialog((Frame)this, (LEConfirmClient)this, lEMultiLineLabel, stringArray, null);
            ((Component)lEConfirmDialog).setVisible(true);
            return;
        }
        String[] stringArray = new String[]{LEConfirmDialog.OK};
        LEMultiLineLabel lEMultiLineLabel = new LEMultiLineLabel(string);
        lEMultiLineLabel.setMinWidth(400);
        lEMultiLineLabel.setBorder(10);
        LEConfirmDialog lEConfirmDialog = new LEConfirmDialog((Frame)this, (LEConfirmClient)this, lEMultiLineLabel, stringArray, null);
        ((Component)lEConfirmDialog).setVisible(true);
    }

    public void actionCancel(String string) {
        System.exit(0);
    }

    public void confirmAction(String string, Object object) {
        if (string.equals("Retry")) {
            this.removeAll();
            this.m_actionIterator.removeAllActions();
            this.createDataFrame();
            if (this.m_wizardIterator.atEnd() && this.m_model.get(LEPMWizardModel.CONNECTED).equals("on")) {
                this.m_next.setEnabled(false);
                this.m_config.setEnabled(true);
            }
            this.invalidate();
            this.validate();
            ((Component)this).setVisible(true);
            return;
        }
        if (string.equals("Save")) {
            this.removeAll();
            this.m_actionIterator.removeAllActions();
            this.m_actionIterator.addBackupAction();
            this.setupConfiguration();
            this.m_actionIterator.startActions();
            return;
        }
        if (string.equals(LEConfirmDialog.NO)) {
            System.exit(0);
            return;
        }
        if (string.equals(LEConfirmDialog.OK)) {
            System.exit(0);
            return;
        }
        if (!this.m_model.get(LEPMWizardModel.BACKUP_DIR).equals("")) {
            String[] stringArray = new String[]{LEConfirmDialog.NO, "Save"};
            String string2 = "Do you still wish to save the backup file?";
            LEConfirmDialog lEConfirmDialog = new LEConfirmDialog((Frame)this, (LEConfirmClient)this, string2, stringArray, null);
            ((Component)lEConfirmDialog).setVisible(true);
            return;
        }
        System.exit(0);
    }

    public void cancelAction(Object object) {
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void createDataFrame() {
        BorderLayout borderLayout = new BorderLayout(10, 10);
        this.setLayout(borderLayout);
        Panel panel = new Panel(new FlowLayout(1, 0, 0));
        Image image = this.m_currentPage.getImage();
        this.m_imageView = image instanceof Image ? new LEImageView(this.m_currentPage.getImage()) : new LEImageView("");
        LEBorderPanel lEBorderPanel = new LEBorderPanel(2);
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.add((Component)this.m_imageView, "Center");
        panel.add("Center", lEBorderPanel);
        this.add((Component)panel, "West");
        this.m_panelTitle = new LETitleBar(this.m_currentPage.getTitle(), 1);
        this.m_panelTitle.setFont(LEFont.getBoldFont());
        this.add((Component)this.m_panelTitle, "North");
        this.m_mainPanel = this.mainPanel();
        this.add((Component)this.m_mainPanel, "Center");
        this.m_buttonPanel = this.buttonPanel();
        this.add((Component)this.m_buttonPanel, "South");
        if (this.m_wizardIterator.atBeginning()) {
            this.m_previous.setEnabled(false);
        }
        if (this.m_wizardIterator.atEnd()) {
            this.m_next.setEnabled(false);
        }
        int n = 640;
        int n2 = 480;
        int n3 = this.m_screenWidth / 2 - n / 2;
        int n4 = this.m_screenHeight / 2 - n2 / 2;
        ((Component)this).setLocation(n3, n4);
        ((Component)this).setSize(n, n2);
    }

    private void nextPage() {
        Object object;
        if (!this.m_currentPage.processPanelData()) {
            new LEErrorDialog((Frame)this, this.m_currentPage.describePanelProblem());
            return;
        }
        if (this.m_model.get(LEPMWizardModel.CONNECTED).equals("off") && this.m_model.getObject(LEPMWizardModel.PORTMASTER) != null) {
            if (this.m_model.getObject(LEPMWizardModel.COMMANDS) != null) {
                this.setupConfiguration();
                object = new LERestoreAction(this.m_model, this.m_actionIterator);
                this.m_actionIterator.addAction((LEWizardAction)object);
                this.m_actionIterator.startActions();
            } else {
                int n = this.m_wizardIterator.size() - 1;
                while (n > 0) {
                    this.m_wizardIterator.removeDataPager(n);
                    --n;
                }
                this.m_wizardIterator.addDataPagers();
                this.m_model.set(LEPMWizardModel.CONNECTED, "on");
            }
        }
        if (!this.m_wizardIterator.atEnd()) {
            this.m_currentPage = this.m_wizardIterator.nextPage();
            object = this.m_currentPage.getTitle();
            this.m_panelTitle.setTitle((String)object);
            this.m_previous.setEnabled(true);
            Panel panel = this.m_currentPage.getPanel();
            Panel panel2 = (Panel)this.m_wizardPanels.get(object);
            this.setInstructions(this.m_currentPage.getInstructions());
            if (panel2 == null) {
                this.m_wizardPanels.put(object, panel);
                this.m_currentPanel.add((String)object, panel);
            } else if (panel2 != panel) {
                this.m_wizardPanels.remove(object);
                this.m_wizardPanels.put(object, panel);
                this.m_currentPanel.remove(panel2);
                this.m_currentPanel.add((String)object, panel);
            }
            this.m_cardlayout.show(this.m_currentPanel, (String)object);
            this.m_panelTitle.repaint();
            this.invalidate();
            this.validate();
        }
        if (this.m_wizardIterator.atEnd() && this.m_model.get(LEPMWizardModel.CONNECTED).equals("on")) {
            this.m_next.setEnabled(false);
            this.m_config.setEnabled(true);
        }
    }

    private void previousPage() {
        this.m_currentPage = null;
        this.m_currentPage = this.m_wizardIterator.previousPage();
        this.m_panelTitle.setTitle(this.m_currentPage.getTitle());
        this.setInstructions(this.m_currentPage.getInstructions());
        this.m_next.setEnabled(true);
        this.m_cardlayout.show(this.m_currentPanel, this.m_currentPage.getTitle());
        this.m_panelTitle.repaint();
        if (this.m_wizardIterator.atBeginning()) {
            this.m_previous.setEnabled(false);
        }
        this.m_config.setEnabled(false);
        this.invalidate();
        this.validate();
        ((Component)this).setVisible(true);
    }

    private void setupConfiguration() {
        ((Component)this).setVisible(false);
        this.removeAll();
        this.m_mainPanel = this.configurePanel();
        this.add((Component)this.m_mainPanel, "Center");
        this.pack();
        Dimension dimension = this.getSize();
        int n = this.m_screenWidth / 2 - dimension.width / 2;
        int n2 = this.m_screenHeight / 2 - dimension.height / 2;
        ((Component)this).setLocation(n, n2);
        ((Component)this).setVisible(true);
    }

    private void showHelp() {
        this.m_Ohelp.showTopic(this.m_book, this.m_currentPage.getHelpTag());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

