/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEIPPanel;
import COM.livingston.ui.LETextField;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;

public class LEPoolAddressPage
extends LEWizardDataPage {
    static final String INC_IPADDRESS = new String("The Internet address is incomplete.");
    static final String PM3_POOL_ERROR = "The pool size must be 0 - 64";
    static final String PM4_POOL_ERROR = "The pool size must be 0 - 96";
    private static final int PM4_MAX_POOL = 96;
    private static final int PM3_MAX_POOL = 64;
    private static final String INSTRUCTION_TAG = "POOLADDRESS_INST";
    private static final String HELP_TAG = "Assigned_Pool_Address";
    private static final String TITLE_TAG = "POOLADDRESS_TITLE";
    private static final String IMAGE_TAG = "DEFAULT_IMAGE";
    private static final String SLOT_TAG = "SLOT_LABEL";
    LEIPPanel m_ippanel;
    LETextField m_poolsize;
    PropertyResourceBundle m_resource;

    public LEPoolAddressPage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);
        StringBuffer stringBuffer = new StringBuffer();
        String string = lEWizardDataModel.get(LEPMDataModel.TITLE_PREPEND);
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.m_resource.getString(TITLE_TAG));
        this.setTitle(stringBuffer.toString());
        this.setImage(this.m_resource.getString(IMAGE_TAG));
        this.setResourceInstructions(this.m_resource.getString(INSTRUCTION_TAG));
        this.setHelpTag(HELP_TAG);
        if (this.m_model.get(LEPMDataModel.POOL_ADDRESS) == null) {
            this.m_model.set(LEPMDataModel.POOL_ADDRESS, "");
        }
        if (this.m_model.get(LEPMDataModel.POOL_SIZE) == null) {
            this.m_model.set(LEPMDataModel.POOL_SIZE, "");
        }
    }

    public Panel createPanel() {
        Object[] objectArray;
        super.createPanel();
        ++this.m_gbc.gridy;
        String string = this.m_model.get(LEPMDataModel.SLOT_NUM);
        if (string != null) {
            objectArray = new Object[]{this.m_model.get(LEPMDataModel.SLOT_NUM)};
            String string2 = MessageFormat.format(this.m_resource.getString(SLOT_TAG), objectArray);
            this.m_component = new Label(string2);
            this.m_component.setFont(LEFont.getBoldFont());
            this.m_panel.add(this.m_component, this.m_gbc);
            ++this.m_gbc.gridy;
        }
        objectArray = new String("Enter the assigned address pool's base address: ");
        this.m_component = new Label((String)objectArray);
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_ippanel = new LEIPPanel(this.m_model.get(LEPMDataModel.POOL_ADDRESS));
        this.m_panel.add((Component)this.m_ippanel, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_component = new Label("Enter your pool size: ");
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        this.m_poolsize = new LETextField(3);
        ((TextComponent)this.m_poolsize).setText(this.m_model.get(LEPMDataModel.POOL_SIZE));
        this.m_poolsize.setNumeric(true);
        this.m_panel.add((Component)this.m_poolsize, this.m_gbc);
        return this.m_panel;
    }

    public boolean processPanelData() {
        this.m_problem = null;
        String string = this.m_poolsize.getText();
        int n = Integer.parseInt(string);
        LEConfig lEConfig = (LEConfig)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
        if (lEConfig instanceof LEPortMaster) {
            if (n > 64) {
                this.m_problem = PM3_POOL_ERROR;
                return false;
            }
        } else if (lEConfig instanceof LEBoard && n > 96) {
            this.m_problem = PM4_POOL_ERROR;
            return false;
        }
        this.m_model.set(LEPMDataModel.POOL_ADDRESS, this.m_ippanel.getAddress());
        this.m_model.set(LEPMDataModel.POOL_SIZE, string);
        return true;
    }
}

