/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.AWTEvent;
import java.util.Enumeration;
import oracle.ewt.border.Border;
import oracle.ewt.button.ButtonContent;
import oracle.ewt.button.EwtButton;
import oracle.ewt.button.PulsingButtonEvent;
import oracle.ewt.button.PulsingButtonListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class PulsingButton
extends EwtButton {
    private Runnable _runnable;
    private PulseTask _task;
    private TaskScheduler _scheduler = TaskScheduler.getDefaultTaskScheduler();
    private boolean _running;
    private int _delay = 200;
    private ListenerManager _listeners;
    private static final int _PULSE_DELAY = 200;

    public PulsingButton(ButtonContent buttonContent, Runnable runnable) {
        super(buttonContent);
        this._runnable = runnable;
    }

    public PulsingButton(ButtonContent buttonContent, Border border, Border border2, Runnable runnable) {
        super(buttonContent, border, border2);
        this._runnable = runnable;
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int n) {
        this._delay = n;
    }

    public void addPulsingButtonListener(PulsingButtonListener pulsingButtonListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(pulsingButtonListener);
    }

    public void removePulsingButtonListener(PulsingButtonListener pulsingButtonListener) {
        this._listeners.removeListener(pulsingButtonListener);
    }

    public void activate() {
    }

    protected void setArmed(boolean bl) {
        if (bl != this.isArmed()) {
            super.setArmed(bl);
            int n = bl ? 2000 : 2001;
            this.processEvent(new PulsingButtonEvent(this, n));
            if (bl) {
                PulsingButton pulsingButton = this;
                synchronized (pulsingButton) {
                    this._running = true;
                    if (this._task == null) {
                        this._task = new PulseTask();
                    }
                    this._runnable.run();
                }
                if (this._running) {
                    this._scheduler.schedule(this._task, this.getDelay());
                    return;
                }
            } else {
                this._running = false;
                this._scheduler.cancel(this._task);
            }
        }
    }

    void handlePulse(TaskEvent taskEvent) {
        this._runnable.run();
        PulsingButton pulsingButton = this;
        synchronized (pulsingButton) {
            if (this._running) {
                this._scheduler.schedule(this._task, this.getDelay());
            }
            return;
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PulsingButtonEvent) {
            this.processPulsingButtonEvent((PulsingButtonEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processPulsingButtonEvent(PulsingButtonEvent pulsingButtonEvent) {
        Enumeration enumeration;
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                PulsingButtonListener pulsingButtonListener = (PulsingButtonListener)enumeration.nextElement();
                switch (pulsingButtonEvent.getID()) {
                    case 2000: {
                        pulsingButtonListener.pulseStartPulsing(pulsingButtonEvent);
                        break;
                    }
                    case 2001: {
                        pulsingButtonListener.pulseEndPulsing(pulsingButtonEvent);
                        break;
                    }
                }
            }
        }
    }

    private class PulseTask
    implements Task {
        public void runTask(TaskEvent taskEvent) {
            PulsingButton.this.handlePulse(taskEvent);
        }

        PulseTask() {
            PulsingButton.this = PulsingButton.this;
        }
    }
}

