/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ppp;

import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.ppp.LEPPPOptionList2;
import COM.livingston.ppp.LEPPPUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEPPPBAPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList2 m_optionList;
    public static final Hashtable BAP_OPTIONS = new Hashtable();
    public static final String BAP_CALL_REQUEST = "01";
    public static final String BAP_CALL_RESPONSE = "02";
    public static final String BAP_CALLBACK_REQUEST = "03";
    public static final String BAP_CALLBACK_RESPONSE = "04";
    public static final String BAP_LINK_DROP_QUERY_REQUEST = "05";
    public static final String BAP_LINK_DROP_QUERY_RESPONSE = "06";
    public static final String BAP_CALL_STATUS_INDICATION = "07";
    public static final String BAP_CALL_STATUS_RESPONSE = "08";
    public static final Hashtable BAP_CODES;
    public static final Hashtable BAP_RESPONSE_CODES;

    public LEPPPBAPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPBAPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
    }

    public LEPPPBAPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPBAPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList2 lEPPPOptionList2) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_optionList = lEPPPOptionList2;
    }

    void setOptionList(LEPPPOptionList2 lEPPPOptionList2) {
        this.m_optionList = lEPPPOptionList2;
    }

    void setCode(String string) {
        this.m_code = string;
    }

    public String getCode() {
        return this.m_code;
    }

    void setID(String string) {
        this.m_id = string;
    }

    public String getID() {
        return this.m_id;
    }

    void setLength(String string) {
        this.m_length = string;
    }

    public String getLength() {
        return this.m_length;
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\t[BAP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        if (this.m_optionList != null) {
            LEPPPOptionList2 lEPPPOptionList2 = this.m_optionList;
            while (lEPPPOptionList2 != null) {
                String string;
                String string2 = lEPPPOptionList2.getOption();
                if (this.m_code.equals(BAP_CALL_RESPONSE) || this.m_code.equals(BAP_CALLBACK_RESPONSE) || this.m_code.equals(BAP_LINK_DROP_QUERY_RESPONSE) || this.m_code.equals(BAP_CALL_STATUS_RESPONSE)) {
                    stringBuffer.append("\n\t Response Code:");
                    string = lEPPPOptionList2.getOption();
                    int n = Integer.parseInt(string, 16);
                    Enumeration enumeration = BAP_RESPONSE_CODES.keys();
                    String string3 = null;
                    while (enumeration.hasMoreElements()) {
                        string3 = (String)enumeration.nextElement();
                        int n2 = Integer.parseInt(string3, 2);
                        if (n2 == n) break;
                    }
                    if (string3 != null) {
                        stringBuffer.append(" [0b");
                        stringBuffer.append(string3);
                        stringBuffer.append("] ");
                        stringBuffer.append((String)BAP_RESPONSE_CODES.get(string3));
                    }
                } else {
                    if (BAP_OPTIONS.containsKey(string2)) {
                        stringBuffer.append("\n\t ");
                        string = (String)BAP_OPTIONS.get(string2);
                        stringBuffer.append(string);
                        stringBuffer.append("[0x");
                        stringBuffer.append(string2);
                        stringBuffer.append("], length: (");
                        stringBuffer.append(String.valueOf(lEPPPOptionList2.getILength()));
                        stringBuffer.append(" bytes)");
                    } else {
                        stringBuffer.append("\n\t [0x");
                        stringBuffer.append(string2);
                        stringBuffer.append("], length: (");
                        stringBuffer.append(String.valueOf(lEPPPOptionList2.getILength()));
                        stringBuffer.append(" bytes)");
                    }
                    stringBuffer.append("[0x");
                    stringBuffer.append(LEPPPUtil.outhex(lEPPPOptionList2.getData()));
                    stringBuffer.append("]");
                }
                lEPPPOptionList2 = lEPPPOptionList2.getNextOptionList();
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static {
        BAP_OPTIONS.put(BAP_CALL_REQUEST, "Link-Type");
        BAP_OPTIONS.put(BAP_CALL_RESPONSE, "Phone-Delta");
        BAP_OPTIONS.put(BAP_CALLBACK_REQUEST, "No-Phone-Number-Needed");
        BAP_OPTIONS.put(BAP_CALLBACK_RESPONSE, "Reason");
        BAP_OPTIONS.put(BAP_LINK_DROP_QUERY_REQUEST, "Link-Discriminator");
        BAP_OPTIONS.put(BAP_LINK_DROP_QUERY_RESPONSE, "Call-Status");
        BAP_CODES = new Hashtable();
        BAP_CODES.put(BAP_CALL_REQUEST, "Call-Request");
        BAP_CODES.put(BAP_CALL_RESPONSE, "Call-Response");
        BAP_CODES.put(BAP_CALLBACK_REQUEST, "Callback-Request");
        BAP_CODES.put(BAP_CALLBACK_RESPONSE, "Callback-Response");
        BAP_CODES.put(BAP_LINK_DROP_QUERY_REQUEST, "Link-Drop-Query-Request");
        BAP_CODES.put(BAP_LINK_DROP_QUERY_RESPONSE, "Link-Drop-Query-Response");
        BAP_CODES.put(BAP_CALL_STATUS_INDICATION, "Call-Status-Indication");
        BAP_CODES.put(BAP_CALL_STATUS_RESPONSE, "Call-Status-Response");
        BAP_RESPONSE_CODES = new Hashtable();
        BAP_RESPONSE_CODES.put("00000000", "Request-Ack");
        BAP_RESPONSE_CODES.put("00000001", "Request-Nak");
        BAP_RESPONSE_CODES.put("00000010", "Request-Rej");
        BAP_RESPONSE_CODES.put("00000011", "Request-Full-Nak");
    }
}

