/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tables;

import sunw.hotjava.doc.Measurement;
import sunw.hotjava.tables.CellSpec;
import sunw.hotjava.tables.ConstraintSummary;

class CellInfoVector {
    CellSpec[] cells;
    int maxSpan;
    int cellPadding;
    int cellSpacing;

    CellInfoVector(int n, int n2, int n3) {
        this.cells = new CellSpec[n];
        this.cellPadding = n2;
        this.cellSpacing = n3;
    }

    void addConstraintInfo(int n, int n2, Measurement measurement, int n3) {
        this.maxSpan = Math.max(this.maxSpan, n2);
        CellSpec cellSpec = this.cells[n];
        if (cellSpec == null) {
            cellSpec = this.cells[n] = new CellSpec();
        }
        if (cellSpec.constraints == null) {
            cellSpec.constraints = new ConstraintSummary(n2, measurement, n3);
            return;
        }
        if (cellSpec.constraints.cellsSpanned > n2) {
            ConstraintSummary constraintSummary = new ConstraintSummary(n2, measurement, n3);
            constraintSummary.next = cellSpec.constraints;
            cellSpec.constraints = constraintSummary;
            return;
        }
        ConstraintSummary constraintSummary = cellSpec.constraints;
        while (constraintSummary != null) {
            if (constraintSummary.cellsSpanned == n2) {
                constraintSummary.accumulateInfo(measurement, n3);
                return;
            }
            if (constraintSummary.next == null || constraintSummary.next.cellsSpanned > n2) break;
            constraintSummary = constraintSummary.next;
        }
        ConstraintSummary constraintSummary2 = new ConstraintSummary(n2, measurement, n3);
        constraintSummary2.next = constraintSummary.next;
        constraintSummary.next = constraintSummary2;
    }

    ConstraintSummary getConstraintFor(int n, int n2) {
        if (n >= 0 && n < this.cells.length && this.cells[n] != null) {
            ConstraintSummary constraintSummary = this.cells[n].constraints;
            while (constraintSummary != null && constraintSummary.cellsSpanned <= n2) {
                if (constraintSummary.cellsSpanned == n2) {
                    return constraintSummary;
                }
                constraintSummary = constraintSummary.next;
            }
        }
        return null;
    }

    int getAssignedSize(int n) {
        if (n >= this.cells.length || n < 0) {
            return 0;
        }
        CellSpec cellSpec = this.cells[n];
        if (cellSpec != null) {
            return cellSpec.assignedSize;
        }
        return 0;
    }

    void setAssignedSize(int n, int n2) {
        CellSpec cellSpec;
        if (n < this.cells.length && n >= 0 && (cellSpec = this.cells[n]) != null) {
            cellSpec.assignedSize = n2;
        }
    }

    void measure(Measurement measurement) {
        CellSpec cellSpec;
        int n = 0;
        while (n < this.cells.length) {
            cellSpec = this.cells[n];
            if (cellSpec == null) {
                this.cells[n] = cellSpec = new CellSpec();
            }
            cellSpec.cumulativeMinSize = 0;
            cellSpec.cumulativePrefSize = 0;
            ConstraintSummary constraintSummary = cellSpec.constraints;
            while (constraintSummary != null) {
                int n2 = constraintSummary.minSize;
                int n3 = constraintSummary.prefSize;
                int n4 = n - constraintSummary.cellsSpanned;
                if (n4 >= 0) {
                    n2 += this.cells[n4].cumulativeMinSize + this.cellSpacing;
                    n3 += this.cells[n4].cumulativePrefSize + this.cellSpacing;
                }
                cellSpec.cumulativeMinSize = Math.max(cellSpec.cumulativeMinSize, n2);
                cellSpec.cumulativePrefSize = Math.max(cellSpec.cumulativePrefSize, n3);
                constraintSummary = constraintSummary.next;
            }
            ++n;
        }
        if (this.cells == null || this.cells.length == 0) {
            measurement.setMinWidth(0);
            measurement.setPreferredWidth(0);
            return;
        }
        cellSpec = this.cells[this.cells.length - 1];
        measurement.setMinWidth(cellSpec.cumulativeMinSize);
        measurement.setPreferredWidth(cellSpec.cumulativePrefSize);
    }

    int length() {
        return this.cells.length;
    }

    int getMaxSpan() {
        return this.maxSpan;
    }
}

