/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.diag.userlocator.LEHoundDog;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;

class UTBoardPanel
extends LEBorderPanel
implements ItemListener {
    UTFrame m_parent;
    Hashtable m_PMToCurBoard;
    Hashtable m_PMDescToPanels;

    UTBoardPanel(UTFrame uTFrame) {
        this.m_parent = uTFrame;
        this.m_PMToCurBoard = new Hashtable();
        this.m_PMDescToPanels = new Hashtable();
        this.setLayout(new FlowLayout());
        this.setBorderType(3);
    }

    public int addPortMaster(LEPortMaster lEPortMaster) {
        int n = -1;
        if (lEPortMaster == null) {
            return n;
        }
        this.m_PMToCurBoard.put(lEPortMaster, new Integer(-1));
        Panel panel = this.createPMBoardPanel(lEPortMaster);
        this.m_PMDescToPanels.put(lEPortMaster, panel);
        this.add(panel);
        if (this.m_PMToCurBoard.containsKey(lEPortMaster)) {
            n = (Integer)this.m_PMToCurBoard.get(lEPortMaster);
        }
        return n;
    }

    public boolean removePortMaster(LEPortMaster lEPortMaster) {
        if (lEPortMaster == null) {
            return false;
        }
        if (this.m_PMToCurBoard.containsKey(lEPortMaster)) {
            this.m_PMToCurBoard.remove(lEPortMaster);
            this.m_PMDescToPanels.remove(lEPortMaster);
            this.reLayoutPanels();
            return true;
        }
        return false;
    }

    public boolean changeBoard(LEPortMaster lEPortMaster, int n) {
        return lEPortMaster != null;
    }

    Panel createPMBoardPanel(LEPortMaster lEPortMaster) {
        LEBorderPanel lEBorderPanel = new LEBorderPanel();
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.setBorderType(4);
        String string = lEPortMaster.getDescription();
        Label label = new Label(string);
        lEBorderPanel.add((Component)label, "West");
        Choice choice = new Choice();
        choice.setName(string);
        if (lEPortMaster.getHardwareType().equals("PM-4")) {
            LEBoards lEBoards = (LEBoards)lEPortMaster.get("2555904");
            if (lEBoards != null) {
                LEVector lEVector = lEBoards.getKeys();
                int n = lEVector.size();
                int n2 = 0;
                while (n2 < n) {
                    String string2 = (String)lEVector.elementAt(n2);
                    LEBoard lEBoard = (LEBoard)lEBoards.get(string2);
                    if (lEBoard != null) {
                        String string3 = (String)lEBoard.get(LEBoard.BOARD_TYPE);
                        if (this.isValidBoardType(string3)) {
                            int n3;
                            if (this.m_PMToCurBoard.containsKey(lEPortMaster) && (n3 = ((Integer)this.m_PMToCurBoard.get(lEPortMaster)).intValue()) == -1) {
                                this.m_PMToCurBoard.put(lEPortMaster, new Integer(string2));
                            }
                            choice.add(string2);
                        }
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            choice.setEnabled(false);
        }
        choice.addItemListener(this);
        lEBorderPanel.add((Component)choice, "East");
        return lEBorderPanel;
    }

    void reLayoutPanels() {
        this.removeAll();
        Enumeration enumeration = this.m_PMDescToPanels.keys();
        while (enumeration.hasMoreElements()) {
            Panel panel = (Panel)this.m_PMDescToPanels.get((LEPortMaster)enumeration.nextElement());
            this.add(panel);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Choice) {
            Choice choice = (Choice)itemSelectable;
            String string = choice.getName();
            LEHoundDog lEHoundDog = LEHoundDog.GetHoundDog();
            LEPortMaster lEPortMaster = this.getPMFromHT(string);
            Integer n = (Integer)this.m_PMToCurBoard.get(lEPortMaster);
            int n2 = n;
            int n3 = Integer.parseInt(choice.getSelectedItem());
            lEHoundDog.changeBoard(lEPortMaster, n2, n3);
            this.m_PMToCurBoard.put(lEPortMaster, new Integer(n3));
        }
    }

    boolean isValidBoardType(String string) {
        return string.equals("Quad T1") || string.equals("Tri E1");
    }

    LEPortMaster getPMFromHT(String string) {
        Enumeration enumeration = this.m_PMToCurBoard.keys();
        while (enumeration.hasMoreElements()) {
            LEPortMaster lEPortMaster = (LEPortMaster)enumeration.nextElement();
            if (!lEPortMaster.getDescription().equals(string)) continue;
            return lEPortMaster;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.doLayout();
        this.repaint();
    }
}

