/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LECmdFailedFactory;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDebugFactory;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.diag.LEDebugFileReader;
import com.lucent.ra.nms.diag.userlocator.LEHoundDog;
import com.lucent.ra.nms.diag.userlocator.LEHoundDogMessage;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEAboutDialog;
import com.lucent.ra.nms.ui.LEActionClient;
import com.lucent.ra.nms.ui.LEActionDialog;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEConnectDialog;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LELoginClient;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LENotesView;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LESplitterPanel;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEProperties;
import com.lucent.ra.nms.util.LEResource;
import com.lucent.ra.nms.util.LEStatusManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.help.Book;
import oracle.help.Help;

public class UTFrame
extends Frame
implements ActionListener,
MouseListener,
LEObserver,
LELoginClient,
LEActionClient {
    LEHoundDog m_hd;
    LENotesView m_notes;
    LEPortMaster m_pm;
    LEConnectionManager m_cm;
    LEAMManager_RI m_amm;
    LEAMRouter_RI m_router;
    String m_hostname;
    String m_username;
    String m_password;
    LEConnectDialog m_condial;
    UTPMGrid m_pmGrid;
    Hashtable m_ht_name_to_pm = new Hashtable();
    UTFoundPanel m_foundPanel;
    UTBoardPanel m_boardPanel;
    Vector m_usersToWatch = new Vector();
    Vector m_prevUsersToWatch = new Vector();
    Vector m_callerIDsToWatch = new Vector();
    Vector m_prevCallerIDsToWatch = new Vector();
    Book m_book;
    Help m_help;
    public static final int NUM_OF_VISIBLE_ITEMS_IN_LIST = 10;
    public static final float MIN_VERSION = 3.8f;
    public static final String VERSION_40 = "4.0";
    List m_userWatchList = new List(10);
    List m_callerIDList = new List(10);
    Hashtable m_callerIDToUserIDHT = new Hashtable();
    TextArea m_ta;
    Rectangle m_mainBounds;
    Rectangle m_rnBounds;
    public static final String CONNECT = "CONNECT";
    public static final String DISCONNECT = "DISCONNECT";
    public static final String RECONNECT = "RECONNECT";
    public static final String REMOVE_PM = "REMOVE_PM";
    public static final String READ_FILE = "READ_FILE";
    public static final String EXIT = "EXIT";
    public static final String ADD_USER = "ADD_USER";
    public static final String MODIFY_USERS = "MODIFY_USERS";
    public static final String MODIFY_CALLERIDS = "MODIFY_CALLERIDS";
    public static final String REMOVE_SELECTED_USERS = "remove selected users";
    public static final String REMOVE_SELECTED_CALLERIDS = "remove selected callerids";
    public static final String ACTION_RELNOTES = "releasenotes";
    public static final String HELP = "Help";
    public static final String PROPS_FILE = "utprops.cfg";
    public static final String PROP_NUM_USERS = "num_users";
    public static final String PROP_NUM_CALLERIDS = "num_callerids";
    public static final String PROP_USER = "user";
    public static final String PROP_CALLERID = "callerid";
    public static final String PROP_MAIN_X = "main_x";
    public static final String PROP_MAIN_Y = "main_y";
    public static final String PROP_MAIN_W = "main_w";
    public static final String PROP_MAIN_H = "main_h";
    public static final String PROP_RN_X = "rn_x";
    public static final String PROP_RN_Y = "rn_y";
    public static final String PROP_RN_W = "rn_w";
    public static final String PROP_RN_H = "rn_h";
    public static final String ABOUT = "About";
    static /* synthetic */ Class class$UserTracker;

    public UTFrame() {
        this.addNotify();
        this.initializeSingletons();
        LEProperties.SetPropertyFile(LEAppInfo.getUserAppDirPath(PROPS_FILE));
        this.loadProps();
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        this.m_hd = LEHoundDog.GetHoundDog();
        this.m_userWatchList.setMultipleMode(false);
        this.m_callerIDList.setMultipleMode(false);
        this.m_pmGrid = new UTPMGrid();
        this.m_pmGrid.setMinDisplayRows(3);
        this.m_pmGrid.getMinimumSize();
        this.m_boardPanel = new UTBoardPanel(this);
        LEBorderPanel lEBorderPanel = new LEBorderPanel();
        lEBorderPanel.setLayout(new BorderLayout());
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_pmGrid);
        lEBorderPanel.add("Center", lEScrollPanel);
        lEBorderPanel.setBorderType(3);
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        lESplitterPanel.addColumn(100);
        lESplitterPanel.addComponent((Component)lEBorderPanel, 100);
        lESplitterPanel.addComponent((Component)this.m_boardPanel, 45);
        LESplitterPanel lESplitterPanel2 = new LESplitterPanel();
        lESplitterPanel2.addColumn(100);
        lESplitterPanel2.addComponent((Component)lESplitterPanel, 165);
        lESplitterPanel2.addComponent((Component)this.usersAddedPanel(), 0);
        this.add("Center", lESplitterPanel2);
        this.setTitle(String.valueOf(LEAppInfo.getAppName()) + LEAppInfo.getAppVersion());
        this.setMenuBar(this.createMenuBar());
        Image image = LEResource.GetImage("lucent_32.gif");
        if (image instanceof Image) {
            this.setIconImage(image);
        }
        this.setPosition();
        WinAdapter winAdapter = new WinAdapter();
        this.addWindowListener(winAdapter);
        try {
            this.m_book = Help.createBook((Class)(class$UserTracker != null ? class$UserTracker : (class$UserTracker = UTFrame.class$("UserTracker"))), (String)".", (String)"TrackerHelp", (String)"UserTracker Help");
            if (this.m_book != null) {
                this.m_help = new Help();
                this.m_help.addBook(this.m_book);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
    }

    public static void main(String[] stringArray) {
        ((Component)new UTFrame()).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ADD_USER)) {
            UTAddUserDialog uTAddUserDialog = new UTAddUserDialog(this);
            ((Component)uTAddUserDialog).setVisible(true);
            String string2 = uTAddUserDialog.getUserToAdd();
            String string3 = uTAddUserDialog.getCallerIDToAdd();
            this.addUserID(string2);
            this.addCallerID(string3);
            if (string2 != null && string3 != null) {
                this.m_callerIDToUserIDHT.put(string3, string2);
                return;
            }
        } else {
            if (string.equals(MODIFY_USERS)) {
                this.processModifyUsers();
                return;
            }
            if (string.equals(MODIFY_CALLERIDS)) {
                this.processModifyCallerids();
                return;
            }
            if (string.equals(CONNECT)) {
                this.m_condial = new LEConnectDialog((Frame)this, this);
                this.m_condial.show();
                return;
            }
            if (string.equals(DISCONNECT)) {
                this.disconnectSelectedPortMasters();
                return;
            }
            if (string.equals(RECONNECT)) {
                this.reconnectSelectedPortMasters();
                return;
            }
            if (string.equals(REMOVE_PM)) {
                this.removeSelectedPortMasters();
                return;
            }
            if (string.equals(READ_FILE)) {
                this.readFile_ActionPerformed();
                return;
            }
            if (string.equals(EXIT)) {
                this.shutdown();
                return;
            }
            if (string.equals(REMOVE_SELECTED_USERS)) {
                this.removeSelectedUsers();
                return;
            }
            if (string.equals(REMOVE_SELECTED_CALLERIDS)) {
                this.removeSelectedCallerIDs();
                return;
            }
            if (string.equals(HELP)) {
                this.showHelp();
                return;
            }
            if (string.equals(ABOUT)) {
                LEAboutDialog.Show(this);
                return;
            }
            if (string.equals(ACTION_RELNOTES)) {
                if (this.m_notes == null) {
                    this.m_notes = new LENotesView(this.m_rnBounds);
                    this.m_notes.loadReleaseNotes();
                    return;
                }
                ((Component)this.m_notes).setVisible(true);
                this.m_notes.show();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        block20: {
            block17: {
                block19: {
                    block18: {
                        if (mouseEvent.getSource() != this.m_userWatchList) break block17;
                        if (mouseEvent.getClickCount() % 2 != 0) break block18;
                        UTModifyIDDialog uTModifyIDDialog = new UTModifyIDDialog((Frame)this, this.m_userWatchList.getSelectedItem(), "Modify User ID");
                        ((Component)uTModifyIDDialog).setVisible(true);
                        if (uTModifyIDDialog.hasChanged()) {
                            int n = this.m_userWatchList.getSelectedIndex();
                            String string = uTModifyIDDialog.getNewID();
                            String string2 = uTModifyIDDialog.getOldID();
                            if (n >= 0) {
                                this.m_userWatchList.replaceItem(string, n);
                                this.m_usersToWatch.setElementAt(string, n);
                            } else {
                                this.m_userWatchList.addItem(string);
                                this.m_usersToWatch.addElement(string);
                            }
                            this.m_hd.addUserID(string, this);
                            this.m_hd.removeUserID(string2, this);
                            return;
                        }
                        break block19;
                    }
                    String string = this.m_userWatchList.getSelectedItem();
                    if (string != null && this.m_callerIDToUserIDHT.contains(string)) {
                        Enumeration enumeration = this.m_callerIDToUserIDHT.keys();
                        while (enumeration.hasMoreElements()) {
                            String string3 = (String)enumeration.nextElement();
                            String string4 = (String)this.m_callerIDToUserIDHT.get(string3);
                            if (!string.equals(string4)) continue;
                            String[] stringArray = this.m_callerIDList.getItems();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                if (stringArray[n2].equals(string3)) {
                                    this.m_callerIDList.select(n2);
                                    return;
                                }
                                ++n2;
                            }
                            int n3 = this.m_callerIDList.getSelectedIndex();
                            if (n3 < 0) continue;
                            this.m_callerIDList.deselect(n3);
                        }
                    }
                    break block20;
                }
                return;
            }
            if (mouseEvent.getSource() == this.m_callerIDList) {
                if (mouseEvent.getClickCount() % 2 == 0) {
                    UTModifyIDDialog uTModifyIDDialog = new UTModifyIDDialog((Frame)this, this.m_callerIDList.getSelectedItem(), "Modify Caller ID");
                    ((Component)uTModifyIDDialog).setVisible(true);
                    if (uTModifyIDDialog.hasChanged()) {
                        int n = this.m_callerIDList.getSelectedIndex();
                        String string = uTModifyIDDialog.getNewID();
                        String string5 = uTModifyIDDialog.getOldID();
                        if (n >= 0) {
                            this.m_callerIDList.replaceItem(string, n);
                            this.m_callerIDsToWatch.setElementAt(string, n);
                        } else {
                            this.m_callerIDList.addItem(string);
                            this.m_callerIDsToWatch.addElement(string);
                        }
                        this.m_hd.addCallerStationID(string, this);
                        this.m_hd.removeCallerStationID(string5, this);
                        return;
                    }
                } else {
                    String string = this.m_callerIDList.getSelectedItem();
                    if (string != null && this.m_callerIDToUserIDHT.containsKey(string)) {
                        String string6 = (String)this.m_callerIDToUserIDHT.get(string);
                        String[] stringArray = this.m_userWatchList.getItems();
                        int n = stringArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            if (stringArray[n4].equals(string6)) {
                                this.m_userWatchList.select(n4);
                                return;
                            }
                            ++n4;
                        }
                        int n5 = this.m_userWatchList.getSelectedIndex();
                        if (n5 >= 0) {
                            this.m_userWatchList.deselect(n5);
                        }
                    }
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    void setUsersToWatch(Vector vector) {
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.addUserID((String)vector.elementAt(n2));
                ++n2;
            }
        }
    }

    void addUserID(String string) {
        if (string != null && !string.equals("")) {
            this.m_userWatchList.add(string);
            this.m_hd.addUserID(string, this);
        }
    }

    void removeUserID(String string) {
        if (string != null && !string.equals("")) {
            int n = this.m_userWatchList.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_userWatchList.getItem(n2).equals(string)) {
                    this.m_userWatchList.delItem(n2);
                    break;
                }
                ++n2;
            }
            this.m_hd.removeUserID(string, this);
        }
    }

    void addCallerID(String string) {
        if (string != null && !string.equals("")) {
            this.m_callerIDList.add(string);
            this.m_hd.addCallerStationID(string, this);
        }
    }

    void removeCallerID(String string) {
        if (string != null && !string.equals("")) {
            int n = this.m_callerIDList.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                if (this.m_callerIDList.getItem(n2).equals(string)) {
                    this.m_callerIDList.delItem(n2);
                    break;
                }
                ++n2;
            }
            this.m_hd.removeCallerStationID(string, this);
        }
    }

    void processModifyUsers() {
        UTModifyDialog uTModifyDialog = new UTModifyDialog((Frame)this, "User", this.m_prevUsersToWatch, this.m_usersToWatch);
        uTModifyDialog.show();
        if (uTModifyDialog.isChanged()) {
            this.m_usersToWatch = uTModifyDialog.getActiveItems();
            this.m_prevUsersToWatch = uTModifyDialog.getNonActiveItems();
            Vector vector = uTModifyDialog.getAddedItems();
            Vector vector2 = uTModifyDialog.getRemovedItems();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.addUserID((String)vector.elementAt(n2));
                ++n2;
            }
            int n3 = vector2.size();
            int n4 = 0;
            while (n4 < n3) {
                this.removeUserID((String)vector2.elementAt(n4));
                ++n4;
            }
        }
    }

    void processModifyCallerids() {
        UTModifyDialog uTModifyDialog = new UTModifyDialog((Frame)this, "CallerID", this.m_prevCallerIDsToWatch, this.m_callerIDsToWatch);
        uTModifyDialog.show();
        if (uTModifyDialog.isChanged()) {
            this.m_callerIDsToWatch = uTModifyDialog.getActiveItems();
            this.m_prevCallerIDsToWatch = uTModifyDialog.getNonActiveItems();
            Vector vector = uTModifyDialog.getAddedItems();
            Vector vector2 = uTModifyDialog.getRemovedItems();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                this.addCallerID((String)vector.elementAt(n2));
                ++n2;
            }
            int n3 = vector2.size();
            int n4 = 0;
            while (n4 < n3) {
                this.removeCallerID((String)vector2.elementAt(n4));
                ++n4;
            }
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        try {
            if (object instanceof LEHoundDogMessage) {
                LEHoundDogMessage lEHoundDogMessage = (LEHoundDogMessage)object;
                this.m_foundPanel.addMessage(lEHoundDogMessage);
                return;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    Panel usersAddedPanel() {
        this.m_userWatchList.addMouseListener(this);
        this.m_callerIDList.addMouseListener(this);
        Panel panel = new Panel(new BorderLayout());
        panel.setBackground(Color.lightGray);
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        lESplitterPanel.addColumn(80);
        LEBorderPanel lEBorderPanel = new LEBorderPanel(3);
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.add("North", new Label("  User ID"));
        lEBorderPanel.add("Center", this.m_userWatchList);
        Button button = new Button("Modify");
        button.setActionCommand(MODIFY_USERS);
        button.addActionListener(this);
        lEBorderPanel.add("South", button);
        Dimension dimension = this.m_userWatchList.getMinimumSize();
        lESplitterPanel.addComponent((Component)lEBorderPanel, dimension.height);
        lEBorderPanel = new LEBorderPanel(3);
        lEBorderPanel.setLayout(new BorderLayout());
        lEBorderPanel.add("North", new Label("  Caller ID"));
        lEBorderPanel.add("Center", this.m_callerIDList);
        Button button2 = new Button("Modify");
        button2.setActionCommand(MODIFY_CALLERIDS);
        button2.addActionListener(this);
        lEBorderPanel.add("South", button2);
        lESplitterPanel.addComponent((Component)lEBorderPanel, 0);
        lESplitterPanel.addColumn(40);
        this.m_foundPanel = new UTFoundPanel();
        lESplitterPanel.addComponent((Component)this.m_foundPanel, 0);
        panel.add("Center", lESplitterPanel);
        return panel;
    }

    MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Modify");
        Menu menu3 = new Menu("Message");
        Menu menu4 = new Menu("PortMaster");
        Menu menu5 = new Menu(HELP);
        MenuItem menuItem = new MenuItem("Read Log File...");
        menuItem.setActionCommand(READ_FILE);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        MenuItem menuItem2 = new MenuItem("Exit");
        menuItem2.setActionCommand(EXIT);
        menuItem2.addActionListener(this);
        menu.add(menuItem2);
        MenuItem menuItem3 = new MenuItem("Delete Selected");
        menuItem3.setActionCommand("MESSAGE_DELETE");
        menuItem3.addActionListener(this.m_foundPanel);
        menu3.add(menuItem3);
        MenuItem menuItem4 = new MenuItem("Delete All");
        menuItem4.setActionCommand("MESSAGE_DELETE_ALL");
        menuItem4.addActionListener(this.m_foundPanel);
        menu3.add(menuItem4);
        MenuItem menuItem5 = new MenuItem("Delete All with Same ID");
        menuItem5.setActionCommand("MESSAGE_DELETE_SAME");
        menuItem5.addActionListener(this.m_foundPanel);
        menu3.add(menuItem5);
        MenuItem menuItem6 = new MenuItem("Connect...");
        menuItem6.setActionCommand(CONNECT);
        menuItem6.addActionListener(this);
        menu4.add(menuItem6);
        MenuItem menuItem7 = new MenuItem("Disconnect");
        menuItem7.setActionCommand(DISCONNECT);
        menuItem7.addActionListener(this);
        menu4.add(menuItem7);
        MenuItem menuItem8 = new MenuItem("Reconnect");
        menuItem8.setActionCommand(RECONNECT);
        menuItem8.addActionListener(this);
        menu4.add(menuItem8);
        MenuItem menuItem9 = new MenuItem("Remove");
        menuItem9.setActionCommand(REMOVE_PM);
        menuItem9.addActionListener(this);
        menu4.add(menuItem9);
        MenuItem menuItem10 = new MenuItem("Users ID's...");
        menuItem10.setActionCommand(MODIFY_USERS);
        menuItem10.addActionListener(this);
        menu2.add(menuItem10);
        MenuItem menuItem11 = new MenuItem("Caller ID's...");
        menuItem11.setActionCommand(MODIFY_CALLERIDS);
        menuItem11.addActionListener(this);
        menu2.add(menuItem11);
        MenuItem menuItem12 = new MenuItem("Help Contents...");
        menuItem12.setActionCommand(HELP);
        menuItem12.addActionListener(this);
        menu5.add(menuItem12);
        menu5.addSeparator();
        MenuItem menuItem13 = new MenuItem("About UserTracker...");
        menuItem13.setActionCommand(ABOUT);
        menuItem13.addActionListener(this);
        menu5.add(menuItem13);
        MenuItem menuItem14 = new MenuItem("Release Notes...");
        menuItem14.setActionCommand(ACTION_RELNOTES);
        menuItem14.addActionListener(this);
        menu5.add(menuItem14);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu4);
        menuBar.add(menu3);
        menuBar.add(menu5);
        return menuBar;
    }

    void shutdown() {
        ((Component)this).setVisible(false);
        this.disconnectAllConnectedPMs();
        this.saveProperties();
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {}
        this.dispose();
        System.exit(0);
    }

    void disconnectAllConnectedPMs() {
        Enumeration enumeration = this.m_ht_name_to_pm.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_ht_name_to_pm.get(string);
            if (!lEPortMaster.isConnected()) continue;
            lEPortMaster.disconnect();
        }
    }

    Panel multiListFoundPanel() {
        Panel panel = new Panel(new BorderLayout());
        LEMultiList lEMultiList = new LEMultiList(1, 0, 3);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(lEMultiList);
        panel.add("Center", lEScrollPanel);
        return panel;
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        block10: {
            try {
                this.m_pm = LEPMFactory.GetFromPM(this.m_cm, this.m_hostname, this.m_username, this.m_password);
                if (this.m_hostname == null) {
                    this.m_pm.disconnect();
                    this.m_pm = null;
                    return;
                }
                LEDSS lEDSS = this.m_pm.getDSS();
                if (!(lEDSS instanceof LEDSSPortMaster)) {
                    this.m_pm = null;
                    return;
                }
                LEDSSPortMaster lEDSSPortMaster = (LEDSSPortMaster)lEDSS;
                if (lEDSSPortMaster == null || !lEDSSPortMaster.isConnected()) {
                    new LEErrorDialog((Frame)this, new String("Failed to connect to " + this.m_hostname));
                    this.m_pm = null;
                }
                String string = this.m_pm.getSoftwareVersion();
                try {
                    Float f = Float.valueOf(string.substring(0, 3));
                    if (f.floatValue() < 3.8f) {
                        new LEErrorDialog((Frame)this, new String("Must be running ComOS " + 3.8f + " or Greater"));
                        this.m_pm = null;
                        return;
                    }
                    if (string.indexOf(VERSION_40) == 0) {
                        new LEErrorDialog((Frame)this, new String("This version does not work with this version of ComOS"));
                        this.m_pm = null;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
            catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
                this.m_pm = null;
                new LEErrorDialog((Frame)this, new String("Invalid password!"));
                return;
            }
            catch (Exception exception) {
                this.m_pm = null;
                LEDebug.getLog().logln(20, exception);
                if (this.m_hostname == null) break block10;
                new LEErrorDialog((Frame)this, exception.getMessage());
            }
        }
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (this.m_pm != null && !this.m_ht_name_to_pm.containsKey(this.m_pm.getDescription())) {
            int n = this.m_boardPanel.addPortMaster(this.m_pm);
            this.validate();
            this.m_hd.addPortMasterToMonitor(this.m_pm);
            this.m_hd.changeBoard(this.m_pm, -1, n);
            this.m_pmGrid.addPortMaster(this.m_pm);
            this.m_ht_name_to_pm.put(this.m_pm.getDescription(), this.m_pm);
        }
    }

    public void actionCancel(LEActionDialog lEActionDialog) {
        this.m_hostname = null;
        this.m_username = null;
        this.m_password = null;
    }

    public void loginTo(String string, String string2, String string3) {
        this.m_hostname = string;
        this.m_username = string2;
        this.m_password = string3;
        LEActionDialog lEActionDialog = new LEActionDialog((Frame)this, "Connecting", this, LEStatusManager.GetManager());
        new Thread(lEActionDialog).start();
        ((Component)lEActionDialog).setVisible(true);
    }

    void removeSelectedUsers() {
        String string;
        int n = this.m_userWatchList.getSelectedIndex();
        if (n != -1 && (string = this.m_userWatchList.getSelectedItem()) != null) {
            this.removeUserID(string);
        }
    }

    void removeSelectedCallerIDs() {
        String string;
        int n = this.m_callerIDList.getSelectedIndex();
        if (n != -1 && (string = this.m_callerIDList.getSelectedItem()) != null) {
            this.removeCallerID(string);
        }
    }

    void readFile_ActionPerformed() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
        String string = LEAppInfo.getLastDirectory();
        if (string != null) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setLocation(50, 20);
        fileDialog.show();
        string = fileDialog.getDirectory();
        String string2 = this.m_hostname = fileDialog.getFile();
        if (string2 != null) {
            this.m_hd.addFileNameToMonitor(string2);
            LEDebugFileReader.ReadFile(fileDialog.getDirectory(), string2);
            LEAppInfo.setLastDirectory(string);
            this.m_pmGrid.addFilename(string2);
        }
    }

    void disconnectSelectedPortMasters() {
        LEPortMaster[] lEPortMasterArray = this.m_pmGrid.getSelectedPMs();
        int n = lEPortMasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = lEPortMasterArray[n2];
            lEPortMaster.disconnect();
            this.m_hd.removePortMasterToMonitor(lEPortMaster);
            ++n2;
        }
    }

    void reconnectSelectedPortMasters() {
        LEPortMaster[] lEPortMasterArray = this.m_pmGrid.getSelectedPMs();
        int n = lEPortMasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = lEPortMasterArray[n2];
            if (!lEPortMaster.isConnected()) {
                lEPortMaster.reconnect();
            }
            ++n2;
        }
    }

    void removeSelectedPortMasters() {
        LEPortMaster[] lEPortMasterArray = this.m_pmGrid.getSelectedPMs();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            LEPortMaster lEPortMaster = lEPortMasterArray[n];
            this.m_boardPanel.removePortMaster(lEPortMaster);
            this.m_hd.removePortMasterToMonitor(lEPortMaster);
            this.m_ht_name_to_pm.remove(lEPortMaster.getDescription());
            ++n;
        }
        this.m_boardPanel.doLayout();
        this.m_pmGrid.removeSelectedPMs();
    }

    void initializeSingletons() {
        this.m_amm = LEAMManager_RI.Initialize();
        LECmdFailedFactory.Register();
        LEStatusFactory.Register();
        LEMonitorFactory.Register();
        LEDebugFactory.Register();
        this.m_cm = LEConnectionManager.Initialize();
        this.m_router = LEAMRouter_RI.GetAMRouter();
    }

    void setPosition() {
        ((Component)this).setLocation(this.m_mainBounds.x, this.m_mainBounds.y);
        ((Component)this).setSize(this.m_mainBounds.width, this.m_mainBounds.height);
    }

    void loadProps() {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 640;
            int n2 = 500;
            int n3 = dimension.width / 2 - n / 2;
            int n4 = dimension.height / 2 - n2 / 2;
            String string = LEProperties.GetProperty(PROP_MAIN_X);
            if (string != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_Y)) != null) {
                n4 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_W)) != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_H)) != null) {
                n2 = Integer.parseInt(string);
            }
            this.m_mainBounds = new Rectangle(n3, n4, n, n2);
            this.getPropXIDs(PROP_NUM_USERS, PROP_USER, this.m_prevUsersToWatch);
            this.getPropXIDs(PROP_NUM_CALLERIDS, PROP_CALLERID, this.m_prevCallerIDsToWatch);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void getPropXIDs(String string, String string2, Vector vector) {
        int n = 0;
        try {
            n = Integer.parseInt(LEProperties.GetProperty(string));
        }
        catch (Exception exception) {
            n = 0;
        }
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(LEProperties.GetProperty(String.valueOf(string2) + n2));
            ++n2;
        }
    }

    void showHelp() {
        System.out.println("Attempting to show help");
        if (this.m_help != null) {
            this.m_help.showContents();
        }
    }

    public void saveProperties() {
        try {
            Rectangle rectangle = this.getBounds();
            LEProperties.SetProperty(PROP_MAIN_X, Integer.toString(rectangle.x));
            LEProperties.SetProperty(PROP_MAIN_Y, Integer.toString(rectangle.y));
            LEProperties.SetProperty(PROP_MAIN_W, Integer.toString(rectangle.width));
            LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height));
            this.savePropXIDs(this.m_usersToWatch, this.m_prevUsersToWatch, PROP_NUM_USERS, PROP_USER);
            this.savePropXIDs(this.m_callerIDsToWatch, this.m_prevCallerIDsToWatch, PROP_NUM_CALLERIDS, PROP_CALLERID);
            if (this.m_notes != null) {
                rectangle = this.m_notes.getSavedBounds();
                LEProperties.SetProperty(PROP_RN_X, Integer.toString(rectangle.x));
                LEProperties.SetProperty(PROP_RN_Y, Integer.toString(rectangle.y));
                LEProperties.SetProperty(PROP_RN_W, Integer.toString(rectangle.width));
                LEProperties.SetProperty(PROP_RN_H, Integer.toString(rectangle.height));
            }
            LEProperties.SaveProperties();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void savePropXIDs(Vector vector, Vector vector2, String string, String string2) {
        int n = 0;
        int n2 = vector.size();
        int n3 = vector2.size();
        int n4 = n2 + n3;
        LEProperties.SetProperty(string, Integer.toString(n4));
        int n5 = 0;
        while (n5 < n2) {
            LEProperties.SetProperty(String.valueOf(string2) + n, (String)vector.elementAt(n5));
            ++n5;
            ++n;
        }
        int n6 = 0;
        while (n6 < n3) {
            LEProperties.SetProperty(String.valueOf(string2) + n, (String)vector2.elementAt(n6));
            ++n6;
            ++n;
        }
    }

    void processInitFlags() {
        try {
            String string = LEAppInfo.getFlag("-h");
            ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
            if (string != null) {
                String string2 = LEAppInfo.getFlag("-p");
                String string3 = LEAppInfo.getFlag("-u") != null ? LEAppInfo.getFlag("-u") : "!root";
                this.loginTo(string, string3, string2);
            }
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            String string4 = LEAppInfo.getFlag("-userids");
            this.processUserIDInitFlag(string4);
            String string5 = LEAppInfo.getFlag("-callerids");
            this.processCallerIDInitFlag(string5);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void processUserIDInitFlag(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.addUserID(string2);
        }
    }

    void processCallerIDInitFlag(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.addCallerID(string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class WinAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            UTFrame.this.shutdown();
        }

        public void windowClosed(WindowEvent windowEvent) {
            UTFrame.this.shutdown();
        }

        WinAdapter() {
            UTFrame.this = UTFrame.this;
        }
    }
}

