/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMOpFailureException;
import com.lucent.ra.nms.backend.LEDSSPMTftpUpgrade;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEInteger;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEStatusManager;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class LEDSSPMUpgrade
extends LEObservable {
    static final int UpgradeModeOpCode = 0;
    static final int UpgradeModeOpDownHeader = 1;
    static final int UpgradeModeOpDownData = 2;
    static final int UpgradeModeOpRenameHeader = 3;
    static final int UpgradeModeOpDownLoaderStart = 4;
    static final int UpgradeModeOpDownLoaderData = 5;
    static final int UpgradeModeOpPatch = 6;
    static final int UpgradeModeOpPatchData = 7;
    static final int UpgradeModeOpNoopNew = 8;
    static final int UpgradeInstOpDownload = 1;
    static final int UpgradeInstOpRename = 2;
    static final int UpgradeInstOpLoader = 3;
    static final int UpgradeInstOpPatch = 4;
    static final int UpgradeInstOpNoop = 5;
    static final int TIMEOUT = 80000;
    int m_mode;
    int m_toRead;
    int m_flashSpecialHandling;
    int m_loadingOS;
    int m_nBytes;
    int m_totalBytes;
    byte[] m_data;
    File m_inputFile;
    FileInputStream m_inStream;
    String m_fileName;
    String m_release;
    int m_sendCount;
    int m_nRead;
    LEDSSPortMaster m_dss;
    LEStatusManager m_status;

    public LEDSSPMUpgrade(File file, LEDSSPortMaster lEDSSPortMaster) throws FileNotFoundException {
        this.m_inputFile = file;
        this.m_dss = lEDSSPortMaster;
        this.m_status = new LEStatusManager();
    }

    public LEStatusManager getStatusManager() {
        return this.m_status;
    }

    public void doUpgrade() throws LEDSSException, IOException {
        this.m_inStream = new FileInputStream(this.m_inputFile);
        this.m_dss.startUpgrade();
        Exception exception = null;
        try {
            if (this.isTftpFile()) {
                this.doTFTPUpgrade();
            } else {
                this.doBinaryUpgrade();
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        this.m_dss.stopUpgrade();
        if (exception instanceof LEDSSException) {
            throw (LEDSSException)exception;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception != null) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_inStream.close();
        this.m_inStream = null;
        this.m_status = null;
    }

    boolean isTftpFile() throws IOException {
        boolean bl = true;
        int n = 512;
        this.m_data = new byte[n];
        this.m_nRead = this.m_inStream.read(this.m_data, 0, n);
        int n2 = 0;
        while (n2 < n) {
            if (this.m_data[n2] != 10 && this.m_data[n2] != 13 && !this.isPrint(this.m_data[n2])) {
                bl = false;
                break;
            }
            ++n2;
        }
        this.m_inStream.close();
        this.m_inStream = new FileInputStream(this.m_inputFile);
        return bl;
    }

    void doTFTPUpgrade() throws LEDSSException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.m_inStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        LEDSSPMTftpUpgrade lEDSSPMTftpUpgrade = new LEDSSPMTftpUpgrade(this.m_dss, bufferedReader, this.m_status);
        lEDSSPMTftpUpgrade.doTftpUpgrade();
    }

    void doBinaryUpgrade() throws LEDSSException, IOException {
        this.m_data = new byte[256];
        int n = -1;
        this.dump("Doing Upgrade");
        this.m_status.setStatus(0);
        this.m_mode = 0;
        this.m_toRead = 1;
        while (this.m_toRead > 0) {
            this.m_nRead = this.m_inStream.read(this.m_data, 0, this.m_toRead);
            LEDebug.getLog().logln(40, "Read " + Integer.toString(this.m_nRead) + " bytes");
            if (this.m_nRead == -1) {
                if (this.m_mode != 0) {
                    throw new EOFException();
                }
                return;
            }
            this.m_toRead = 0;
            switch (this.m_mode) {
                case 0: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Reading OP Code", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpCode();
                    break;
                }
                case 1: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Downloading Header", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpDownHeader();
                    break;
                }
                case 2: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Downloading Data", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpDownData();
                    break;
                }
                case 3: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Renaming Header", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpRenameHeader();
                    break;
                }
                case 4: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Starting Downloader", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpDownLoaderStart();
                    break;
                }
                case 5: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Downloading Data", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpDownLoaderData();
                    break;
                }
                case 6: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Starting Patch", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpPatch();
                    break;
                }
                case 7: {
                    if (n != this.m_mode) {
                        this.m_status.setStatus("Patching Data", 0);
                    }
                    n = this.m_mode;
                    this.doUpgradeModeOpPatchData();
                    break;
                }
                case 8: {
                    n = this.m_mode;
                    this.doUpgradeModeOpNoopNew();
                    break;
                }
                default: {
                    this.dump("Mode: Unknown");
                    break;
                }
            }
        }
    }

    void doUpgradeModeOpCode() throws LEDSSException, IOException {
        switch (this.m_data[0]) {
            case 1: {
                this.dump("OP Code: UpgradeInstOpDownload");
                this.m_mode = 1;
                this.m_toRead = 36;
                return;
            }
            case 2: {
                this.dump("OP Code: UpgradeInstOpRename");
                this.m_mode = 3;
                this.m_toRead = 64;
                return;
            }
            case 3: {
                this.dump("OP Code: UpgradeInstOpLoader");
                this.m_mode = 4;
                this.m_toRead = 36;
                return;
            }
            case 4: {
                this.dump("OP Code: UpgradeInstOpPatch");
                this.m_mode = 6;
                this.m_toRead = 4;
                return;
            }
            case 5: {
                this.dump("OP Code: UpgradeInstOpNoop");
                this.m_mode = 0;
                this.m_toRead = 1;
                return;
            }
        }
        this.m_toRead = 0;
    }

    void doUpgradeModeOpDownHeader() throws LEDSSException, IOException {
        this.m_fileName = new String(this.m_data, 0, 16);
        this.m_release = new String(this.m_data, 16, 16);
        this.m_nBytes = this.m_totalBytes = LEInteger.ParseInt(this.m_data, 32);
        this.dump("Download Header Filename: " + this.m_fileName + " Release: " + this.m_release);
        this.dump("Num Bytes = " + Integer.toString(this.m_totalBytes));
        this.send((byte)5, this.m_fileName);
        this.m_toRead = this.m_totalBytes > 256 ? 256 : this.m_totalBytes;
        this.m_mode = 2;
        this.m_sendCount = 0;
    }

    void doUpgradeModeOpDownData() throws LEDSSException, IOException {
        int n;
        LEDebug.getLog().logln(40, "Sending " + Integer.toString(this.m_nRead) + " bytes");
        this.send((byte)6, (short)this.m_nRead, this.m_data);
        this.m_nBytes -= this.m_nRead;
        int n2 = this.m_toRead = this.m_nBytes > 256 ? 256 : this.m_nBytes;
        if (this.m_toRead == 0) {
            this.send((byte)6, (short)0, this.m_data);
            this.m_mode = 0;
            this.m_toRead = 1;
        }
        if ((n = (this.m_totalBytes - this.m_nBytes) * 100 / this.m_totalBytes) != this.m_status.getPercent()) {
            this.m_status.setStatus(n);
        }
    }

    void doUpgradeModeOpRenameHeader() throws LEDSSException, IOException {
        String string = new String(this.m_data, 0, 32);
        String string2 = new String(this.m_data, 32, 32);
        int n = string.length();
        int n2 = string2.length();
        byte[] byArray = new byte[n + n2 + 2];
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, n);
        byArray2 = string2.getBytes();
        System.arraycopy(byArray2, 0, byArray, n + 1, n2);
        this.send((byte)7, (short)(n + n2 + 2), byArray);
    }

    void doUpgradeModeOpDownLoaderStart() {
    }

    void doUpgradeModeOpDownLoaderData() {
    }

    void doUpgradeModeOpPatch() {
        this.m_mode = 7;
        this.m_toRead = this.m_totalBytes = LEInteger.ParseInt(this.m_data);
    }

    void doUpgradeModeOpPatchData() throws LEDSSException, IOException {
        this.send((byte)10, (short)(this.m_data[3] + 4), this.m_data);
        this.m_mode = 0;
        this.m_toRead = 1;
    }

    void doUpgradeModeOpNoopNew() {
    }

    void dump(String string) {
    }

    void send(byte by, String string) throws LEDSSException, IOException {
        byte[] byArray = string.getBytes();
        this.send(by, (short)string.length(), byArray);
    }

    void send(byte by, short s, byte[] byArray) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Sending " + LEDSSPortMaster_RI.GetOpCodeString(by) + " Length: " + Integer.toString(this.m_nRead) + " bytes");
        LESendResponse lESendResponse = this.m_dss.send(by, s, byArray, false, 80000);
        if (!lESendResponse.successful()) {
            throw new LEDSSPMOpFailureException("Data Send Failed: " + LEDSSPortMaster_RI.GetOpCodeString(by));
        }
    }

    boolean isPrint(byte by) {
        if (by >= 32 && by <= 126) {
            return true;
        }
        return by == 9 || by == 10 || by == 13;
    }
}

