/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag;

import com.lucent.ra.nms.util.LEDebug;
import java.util.StringTokenizer;

public class LEDiagUtil {
    public static final String[] END_POINT_CLASS = new String[]{"00", "Null Class", "01", "Locally Assigned Address", "02", "IP Address", "03", "IEEE 802.1 MAC Address", "04", "PPP Magic-Number Block", "05", "Public Switched Network Directory Number"};

    public static String toHexString(int n) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        String string = Integer.toHexString(n);
        if ((string = string.toUpperCase()).length() % 2 == 1) {
            stringBuffer.append("0");
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static Integer hex2dec(String string) {
        try {
            Integer n = new Integer(Integer.parseInt(string, 16));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
            return new Integer(-1);
        }
    }

    public static String hex2decStr(String string) {
        try {
            return String.valueOf(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
            return null;
        }
    }

    public static String hex2str(String string, int n) {
        int n2 = string.length();
        if (n == 0) {
            n = n2;
        }
        n = n * 3 >= n2 ? n2 : (n *= 3);
        StringBuffer stringBuffer = new StringBuffer(20);
        int n3 = 0;
        while (n3 < n) {
            try {
                String string2 = new String(new char[]{string.charAt(n3), string.charAt(n3 + 1)});
                byte[] byArray = new byte[]{new Integer(Integer.parseInt(string2, 16)).byteValue()};
                stringBuffer.append(new String(byArray));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                LEDebug.getLog().logln(20, string);
                LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
            n3 += 3;
        }
        return stringBuffer.toString();
    }

    public static String hex2ip(String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        String string2 = new String(".");
        try {
            if (string.length() <= 11) {
                String string3 = string.substring(0, 2);
                stringBuffer.append(String.valueOf(Integer.parseInt(string3, 16)));
                stringBuffer.append(string2);
                string3 = string.substring(3, 5);
                stringBuffer.append(String.valueOf(Integer.parseInt(string3, 16)));
                stringBuffer.append(string2);
                string3 = string.substring(6, 8);
                stringBuffer.append(String.valueOf(Integer.parseInt(string3, 16)));
                stringBuffer.append(string2);
                string3 = string.substring(9);
                stringBuffer.append(String.valueOf(Integer.parseInt(string3, 16)));
                return stringBuffer.toString();
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
            return null;
        }
    }

    public static String outhex(String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String ParseEndPoint(String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        String string2 = LEDiagUtil.outhex(string.substring(0, 2));
        String string3 = string.substring(3);
        stringBuffer.append("\n\t\t Class [");
        stringBuffer.append(LEDiagUtil.outhex(string2));
        stringBuffer.append("]: ");
        int n = 0;
        while (n < END_POINT_CLASS.length) {
            if (END_POINT_CLASS[n].equals(string2)) {
                stringBuffer.append(END_POINT_CLASS[n + 1]);
                stringBuffer.append(" ");
                break;
            }
            n += 2;
        }
        if (string2.equals("02")) {
            stringBuffer.append(LEDiagUtil.hex2ip(string3));
        } else if (string2.equals("05")) {
            stringBuffer.append(LEDiagUtil.hex2str(string3, string3.length() / 3 + 1));
        } else if (string2.equals("00")) {
            stringBuffer.append("Null Address");
        } else {
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String BuildDescriptiveID(String string) {
        StringBuffer stringBuffer = new StringBuffer("file://");
        stringBuffer.append(string);
        stringBuffer.append("/!root");
        return stringBuffer.toString();
    }
}

