/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import java.util.Hashtable;

public class LEIEConnectedSubAddress
extends LEInfoElement {
    int m_length;
    int m_typeOfSubaddress;
    int m_oddEvenIndicator;
    int[] m_subaddressInfo;
    public static final String[] TYPE_OF_NUMBER = new String[]{"Unknown", "International number", "National number", "Network specific number", "Subscriber number", "UNKNOWN", "Abbreviated number", "Reserved for extension"};
    public static final Hashtable NUMBER_PLAN_ID = new Hashtable();
    public static final String[] PRES_INDICATOR;
    public static final String[] SCREEN_INDICATOR;

    public LEIEConnectedSubAddress(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_typeOfSubaddress = (this.m_data[2] & 0x70) >> 4;
        this.m_oddEvenIndicator = (this.m_data[2] & 8) >> 3;
        this.m_subaddressInfo = new int[this.m_length - 1];
        int n = 3;
        while (n < this.m_length - 1) {
            this.m_subaddressInfo[n - 3] = this.m_data[n];
            ++n;
        }
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tConnected Subaddress Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append(" Type of Subaddress:");
        if (this.m_typeOfSubaddress == 0) {
            stringBuffer.append("NSAP");
        } else if (this.m_typeOfSubaddress == 2) {
            stringBuffer.append("User specified");
        } else {
            stringBuffer.append("RESERVED");
        }
        stringBuffer.append(" ,ODD/EVEN Indicator:");
        if (this.m_oddEvenIndicator == 0) {
            stringBuffer.append("Even number of subaddress signals");
        } else {
            stringBuffer.append("Odd number of subaddress signals");
        }
        stringBuffer.append("\n\t\tSubAddress Info:");
        int n = 0;
        while (n < this.m_subaddressInfo.length) {
            stringBuffer.append(" ");
            stringBuffer.append(this.m_subaddressInfo[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        NUMBER_PLAN_ID.put(new Integer(0), "Unknown or not identified");
        NUMBER_PLAN_ID.put(new Integer(1), "ISDN/telephony numbering plan");
        NUMBER_PLAN_ID.put(new Integer(3), "Data numbering plan");
        NUMBER_PLAN_ID.put(new Integer(4), "Telex numbering plan");
        NUMBER_PLAN_ID.put(new Integer(8), "National standard numbering plan");
        NUMBER_PLAN_ID.put(new Integer(9), "Private numbering plan");
        NUMBER_PLAN_ID.put(new Integer(15), "Reserved for extension");
        PRES_INDICATOR = new String[]{"Presentation allowed", "Presentation restricted", "Number not available due to interworking", "Reserved"};
        SCREEN_INDICATOR = new String[]{"User-provided, not screened", "User-provided, verified and passed", "User-provided, verified and failed", "Network provided"};
    }
}

