/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;

public class LEIEInfoReq
extends LEInfoElement {
    int m_length;
    int[] m_reqInd;
    int[] m_typeOfInfo;

    public LEIEInfoReq(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_reqInd = new int[this.m_length];
        this.m_typeOfInfo = new int[this.m_length];
        int n = 0;
        while (n < this.m_length) {
            this.m_reqInd[n] = (this.m_data[2 + n] & 0x40) >> 6;
            this.m_typeOfInfo[n] = this.m_data[2 + n] & 0x3F;
            ++n;
        }
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tInformation Request Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        int n = 0;
        while (n < this.m_reqInd.length) {
            stringBuffer.append(LEInfoElement.TABS);
            stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2 + n]));
            stringBuffer.append("\n\t\tRequest Indicator:" + LEInfoElement.REQ_IND[this.m_reqInd[n]]);
            stringBuffer.append("\n\t\tType of Info:");
            if (this.m_typeOfInfo[n] < LEInfoElement.TYPE_OF_INFO.length) {
                stringBuffer.append(LEInfoElement.TYPE_OF_INFO[this.m_typeOfInfo[n]]);
            } else {
                stringBuffer.append("???");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

