/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.diag.LEDiagFactory;
import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.LESmartDebugFactory;
import com.lucent.ra.nms.diag.isdn.LEISDNDChannelMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import java.util.Hashtable;

public class LEISDNDebugFactory
extends LEObservable
implements LEDiagFactory {
    protected static Hashtable s_managers = new Hashtable();
    protected static Hashtable s_hostname2pms = new Hashtable();
    private static boolean s_debugenabled;
    static Hashtable s_pms;

    public LEISDNDebugFactory(String string) {
        LESmartDebugFactory lESmartDebugFactory = LESmartDebugFactory.GetFactory();
        lESmartDebugFactory.registerFactory("TYPE_ISDN_D", this, string);
    }

    public static LEISDNDebugFactory addObserver(LEPortMaster lEPortMaster, LEObserver lEObserver) {
        String string = lEPortMaster.getResourceID();
        LEISDNDebugFactory lEISDNDebugFactory = (LEISDNDebugFactory)s_managers.get(string);
        s_pms.put(string, lEPortMaster);
        if (lEISDNDebugFactory == null) {
            lEISDNDebugFactory = new LEISDNDebugFactory(string);
            s_managers.put(string, lEISDNDebugFactory);
            s_hostname2pms.put(string, lEPortMaster);
            lEISDNDebugFactory.addObserver(lEObserver);
        } else {
            lEISDNDebugFactory.addObserver(lEObserver);
        }
        LEISDNDebugFactory.setDebugFlags(lEPortMaster);
        return lEISDNDebugFactory;
    }

    public static String addObserver(String string, LEObserver lEObserver) {
        LEISDNDebugFactory lEISDNDebugFactory = (LEISDNDebugFactory)s_managers.get(string = LEDiagUtil.BuildDescriptiveID(string));
        if (lEISDNDebugFactory == null) {
            lEISDNDebugFactory = new LEISDNDebugFactory(string);
            s_managers.put(string, lEISDNDebugFactory);
            lEISDNDebugFactory.addObserver(lEObserver);
            return "Reading " + string + "\n";
        }
        lEISDNDebugFactory.addObserver(lEObserver);
        return "Reading" + string + "\n";
    }

    public LEDiagFactory getResourceFactory(String string) {
        return (LEDiagFactory)s_managers.get(string);
    }

    public void process(LEDebugMessage lEDebugMessage) {
        LEISDNDChannelMessage lEISDNDChannelMessage = new LEISDNDChannelMessage(lEDebugMessage);
        this.notifyObservers(lEISDNDChannelMessage);
    }

    public static boolean setDebugFlags(LEPortMaster lEPortMaster) {
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade != null) {
            return LEISDNDebugFactory.SendDebugCommand(lEPMConnectionFacade, -1);
        }
        return false;
    }

    static boolean SendDebugCommand(LEPMConnectionFacade lEPMConnectionFacade, int n) {
        LEDebug.getLog().logln(20, "Starting ISDN_Debug");
        return lEPMConnectionFacade.startDebug(131072, 3, n);
    }

    public static void removeObserver(String string, LEObserver lEObserver) {
        if (lEObserver == null || string == null) {
            return;
        }
        LEISDNDebugFactory lEISDNDebugFactory = (LEISDNDebugFactory)s_managers.get(string);
        if (lEISDNDebugFactory != null) {
            lEISDNDebugFactory.deleteObserver(lEObserver);
            if (lEISDNDebugFactory.countObservers() == 0) {
                lEISDNDebugFactory.stopDebugging(string);
            }
        }
    }

    private void stopDebugging(String string) {
        LEPortMaster lEPortMaster = (LEPortMaster)s_pms.get(string);
        if (lEPortMaster != null) {
            LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
            if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
                return;
            }
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            if (lEPMConnectionFacade != null) {
                lEPMConnectionFacade.stopDebug(131072, 3, -1);
            }
        }
    }

    public static boolean ChangeBoards(LEPortMaster lEPortMaster, int n, int n2) {
        String string = lEPortMaster.getResourceID();
        if (!s_pms.containsKey(string)) {
            return false;
        }
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade == null) {
            return false;
        }
        if (n >= 0) {
            lEPMConnectionFacade.execute("set view " + n);
            lEPMConnectionFacade.execute("set debug off");
        }
        return LEISDNDebugFactory.SendDebugCommand(lEPMConnectionFacade, n2);
    }

    static {
        s_pms = new Hashtable();
    }
}

