/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPOptionList;
import com.lucent.ra.nms.util.LEDebug;
import java.util.Hashtable;

public class LEPPPBACPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList m_optionList;
    public static final Hashtable BACP_OPTIONS = new Hashtable();

    public LEPPPBACPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPBACPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPBACPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPBACPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList lEPPPOptionList) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_optionList = lEPPPOptionList;
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_optionList = lEPPPOptionList;
    }

    void setCode(String string) {
        this.m_code = string;
    }

    public String getCode() {
        return this.m_code;
    }

    void setID(String string) {
        this.m_id = string;
    }

    public String getID() {
        return this.m_id;
    }

    void setLength(String string) {
        this.m_length = string;
    }

    public String getLength() {
        return this.m_length;
    }

    public LEPPPOptionList getOptionList() {
        return this.m_optionList;
    }

    void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHexData();
        if (string == null) {
            return;
        }
        try {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
            this.m_code = string2;
            this.m_id = string3;
            this.m_length = string4;
            if (string.length() > 12) {
                LEPPPOptionList lEPPPOptionList = new LEPPPOptionList(string.substring(12));
                this.setOptionList(lEPPPOptionList);
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\t[BACP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        try {
            if (this.m_optionList != null) {
                LEPPPOptionList lEPPPOptionList = this.m_optionList;
                String string = lEPPPOptionList.getOption();
                boolean bl = BACP_OPTIONS.containsKey(string);
                if (bl) {
                    stringBuffer.append("\n\t ");
                    stringBuffer.append((String)BACP_OPTIONS.get(string));
                    stringBuffer.append("[0x");
                    stringBuffer.append(string);
                    stringBuffer.append("], length: (");
                    stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                    stringBuffer.append(" bytes) ");
                    if (string.equals("01")) {
                        stringBuffer.append("Magic Number [0x");
                        stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                        stringBuffer.append("]");
                    } else {
                        stringBuffer.append("[0x");
                        stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                        stringBuffer.append("]");
                    }
                } else {
                    stringBuffer.append("\n\t [0x");
                    stringBuffer.append(string);
                    stringBuffer.append("], length: (");
                    stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                    stringBuffer.append(" bytes)");
                }
            }
            stringBuffer.append("\n");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
        }
        return stringBuffer.toString();
    }

    static {
        BACP_OPTIONS.put("01", "Favored-Peer ");
    }
}

