/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPOptionList;
import com.lucent.ra.nms.util.LEDebug;

public class LEPPPCCPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList m_optionList;
    public static final String[] CCP_OPTIONS = new String[]{"00", "Compression type = Organization Unique Identifier (OUI)", "01", "Compression type = Predictor type 1", "02", "Compression type = Predictor type 2", "03", "Compression type = Puddle Jumper", "04", "Compression type = unassigned", "05", "Compression type = unassigned", "06", "Compression type = unassigned", "07", "Compression type = unassigned", "08", "Compression type = unassigned", "09", "Compression type = unassigned", "0A", "Compression type = unassigned", "0B", "Compression type = unassigned", "0C", "Compression type = unassigned", "0D", "Compression type = unassigned", "0E", "Compression type = unassigned", "10", "Compression type = Hewlett-Packard PPC", "11", "Compression type = Stac Electronics LZS", "12", "Compression type = Microsoft PPC", "13", "Compression type = Gandalf FZA", "14", "Compression type = V.42bis Compression", "15", "Compression type = BSD LZW Compression", "FF", "Compression type = Reserved"};

    public LEPPPCCPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPCCPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPCCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPCCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList lEPPPOptionList) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_optionList = lEPPPOptionList;
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_optionList = lEPPPOptionList;
    }

    void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHexData();
        if (string == null) {
            return;
        }
        try {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
            this.m_code = string2;
            this.m_id = string3;
            this.m_length = string4;
            if (string.length() > 12) {
                LEPPPOptionList lEPPPOptionList = new LEPPPOptionList(string.substring(12));
                this.setOptionList(lEPPPOptionList);
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTranslatedString() {
        if (this.m_code == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\t[CCP]Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        try {
            if (this.m_optionList != null) {
                LEPPPOptionList lEPPPOptionList = this.m_optionList;
                if (this.m_code.equals("0f") || this.m_code.equals("0e")) {
                    stringBuffer.append("\n\tData:");
                    stringBuffer.append("[0x");
                    String string = this.getHexData();
                    String string2 = string.substring(12);
                    stringBuffer.append(LEDiagUtil.outhex(string2));
                    stringBuffer.append("]");
                    stringBuffer.append("\n");
                    return stringBuffer.toString();
                }
                while (lEPPPOptionList != null) {
                    int n = 0;
                    while (n < CCP_OPTIONS.length && !CCP_OPTIONS[n].equals(lEPPPOptionList.getOption())) {
                        n += 2;
                    }
                    if (n + 1 < CCP_OPTIONS.length) {
                        stringBuffer.append("\n\t ");
                        stringBuffer.append(CCP_OPTIONS[n + 1]);
                        stringBuffer.append("[0x");
                        stringBuffer.append(lEPPPOptionList.getOption());
                        stringBuffer.append("], length: (");
                        stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                        stringBuffer.append(" bytes)");
                    }
                    if (!lEPPPOptionList.getData().equals("")) {
                        String string = new String(String.valueOf(lEPPPOptionList.getData().substring(0, 2)) + lEPPPOptionList.getData().substring(3, 5)).toUpperCase();
                        n = 0;
                        while (n < LEPPPDebugMessage.PROTOCOL_LIST.length && !LEPPPDebugMessage.PROTOCOL_LIST[n].equals(string)) {
                            n += 2;
                        }
                        if (n + 1 < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                            stringBuffer.append(LEPPPDebugMessage.PROTOCOL_LIST[n + 1]);
                            stringBuffer.append("[0x");
                            stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                            stringBuffer.append("]");
                        }
                    }
                    lEPPPOptionList = lEPPPOptionList.getNextOptionList();
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

