/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.util.LEDebug;

public class LEPPPCHAPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private String m_value;
    private String m_valuelength;
    private String m_nameormessage;
    public static final String CONF_CHALLENGE = new String("01");
    public static final String CONF_RESPONSE = new String("02");
    public static final String CONF_SUCCESS = new String("03");
    public static final String CONF_FAILURE = new String("04");

    public LEPPPCHAPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPCHAPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPCHAPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public String getCode() {
        return this.m_code;
    }

    void setCode(String string) {
        this.m_code = string;
    }

    void setValueLength(String string) {
        this.m_valuelength = string;
    }

    String getValueLength() {
        return this.m_valuelength;
    }

    void setVal(String string) {
        this.m_value = string;
    }

    String getVal() {
        return this.m_value;
    }

    void setNameOrMessage(String string) {
        this.m_nameormessage = string;
    }

    String getNameOrMisc() {
        return this.m_nameormessage;
    }

    public String getNameOrMessage() {
        return LEDiagUtil.hex2str(this.m_nameormessage, 0);
    }

    public String getLoginID() {
        if (this.m_code.equals("02")) {
            return LEDiagUtil.hex2str(this.m_nameormessage, this.m_nameormessage.length());
        }
        return null;
    }

    void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        block7: {
            String string = lEPPPDebugMessage.getHexData();
            try {
                if (string.length() < 12) break block7;
                String string2 = string.substring(0, 2);
                String string3 = string.substring(3, 5);
                String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
                this.m_code = string2;
                this.m_id = string3;
                this.m_length = string4;
                string = string.substring(12);
                String string5 = string.substring(0, 2);
                this.setValueLength(string5);
                int n = LEDiagUtil.hex2dec(string5) * 3 + 3;
                if (n - 1 > string.length() - 4) {
                    this.setVal(string.substring(3));
                } else {
                    this.setVal(string.substring(3, n - 1));
                }
                if (this.m_code.equals("01") || this.m_code.equals("02")) {
                    if (n < string.length()) {
                        String string6 = string.substring(n);
                        this.setNameOrMessage(string6);
                        return;
                    }
                    break block7;
                }
                if (this.m_code.equals("03") || this.m_code.equals("04")) {
                    this.setNameOrMessage(string);
                }
                return;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            }
        }
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer("\t[CHAP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        if (this.m_code.equals("01") || this.m_code.equals("02")) {
            stringBuffer.append("\n\tValSize[0x");
            stringBuffer.append(this.m_valuelength);
            stringBuffer.append("]: (");
            stringBuffer.append(LEDiagUtil.hex2decStr(this.m_valuelength));
            stringBuffer.append(" bytes), Value: [0x");
            stringBuffer.append(LEDiagUtil.outhex(this.m_value));
            stringBuffer.append("]");
            if (this.m_code.equals("02")) {
                stringBuffer.append("\n\tName: ");
                stringBuffer.append(LEDiagUtil.hex2str(this.m_nameormessage, 0));
                stringBuffer.append(" [");
                stringBuffer.append(LEDiagUtil.outhex(this.m_nameormessage));
                stringBuffer.append("]");
            }
        } else if (this.m_code.equals("03") || this.m_code.equals("04")) {
            stringBuffer.append("\n\t Message:");
            stringBuffer.append(LEDiagUtil.hex2str(this.m_nameormessage, 0));
            stringBuffer.append(" [");
            stringBuffer.append(LEDiagUtil.outhex(this.m_nameormessage));
            stringBuffer.append("]");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

