/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPOptionList;
import com.lucent.ra.nms.util.LEDebug;
import java.util.Hashtable;

public class LEPPPIPCPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList m_optionList;
    public static final String ZERO_SRC_ADDRESS = "00 00 00 00";
    public static final String CONF_REQUEST = new String("01");
    public static final String CONF_ACK = new String("02");
    public static final String CONF_NAK = new String("03");
    public static final String CONF_REJECT = new String("04");
    public static final String TERM_REQ = new String("05");
    public static final String TERM_ACK = new String("06");
    public static final String CODE_REJECT = new String("07");
    public static final Hashtable IPCP_OPTIONS = new Hashtable();

    public LEPPPIPCPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPIPCPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPIPCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
    }

    public LEPPPIPCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList lEPPPOptionList) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_optionList = lEPPPOptionList;
    }

    public String getCode() {
        return this.m_code;
    }

    public String getID() {
        return this.m_id;
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_optionList = lEPPPOptionList;
    }

    public String getIPAddress() {
        String string = null;
        if (this.m_optionList != null) {
            LEPPPOptionList lEPPPOptionList = this.m_optionList;
            while (lEPPPOptionList != null) {
                if (lEPPPOptionList.getOption().equals("03")) {
                    string = LEDiagUtil.hex2ip(lEPPPOptionList.getData().substring(0, 11));
                    break;
                }
                lEPPPOptionList = lEPPPOptionList.getNextOptionList();
            }
        }
        return string;
    }

    public boolean isOptionOneSourceAddressZero() {
        if (this.m_optionList != null) {
            LEPPPOptionList lEPPPOptionList = this.m_optionList;
            while (lEPPPOptionList != null) {
                String string;
                if (lEPPPOptionList.getOption().equals("01") && (string = lEPPPOptionList.getData().substring(0, 11)).equals(ZERO_SRC_ADDRESS)) {
                    return true;
                }
                lEPPPOptionList = lEPPPOptionList.getNextOptionList();
            }
        }
        return false;
    }

    void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHexData();
        if (string == null) {
            return;
        }
        try {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
            this.m_code = string2;
            this.m_id = string3;
            this.m_length = string4;
            if (string.length() > 12) {
                LEPPPOptionList lEPPPOptionList = new LEPPPOptionList(string.substring(12));
                this.setOptionList(lEPPPOptionList);
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\t[IPCP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        if (this.m_optionList != null) {
            LEPPPOptionList lEPPPOptionList = this.m_optionList;
            while (lEPPPOptionList != null) {
                String string;
                String string2 = lEPPPOptionList.getOption();
                boolean bl = IPCP_OPTIONS.containsKey(string2);
                if (bl) {
                    stringBuffer.append("\n\t ");
                    stringBuffer.append((String)IPCP_OPTIONS.get(string2));
                    stringBuffer.append("[0x");
                    stringBuffer.append(string2);
                    stringBuffer.append("], length: (");
                    stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                    stringBuffer.append(" bytes)");
                }
                if (lEPPPOptionList.getOption().equals("03") || lEPPPOptionList.getOption().equals("81") || lEPPPOptionList.getOption().equals("82") || lEPPPOptionList.getOption().equals("83") || lEPPPOptionList.getOption().equals("84")) {
                    string = lEPPPOptionList.getData();
                    stringBuffer.append("[");
                    stringBuffer.append(LEDiagUtil.hex2ip(string));
                    stringBuffer.append("]");
                } else if (string2.equals("01")) {
                    stringBuffer.append("\n\t\tSource-IP-Address: [");
                    stringBuffer.append(LEDiagUtil.hex2ip(lEPPPOptionList.getData().substring(0, 11)));
                    stringBuffer.append("]\n\t\tDestination-IP-Address: [");
                    stringBuffer.append(LEDiagUtil.hex2ip(lEPPPOptionList.getData().substring(12)));
                    stringBuffer.append("]\n\t\tData: [");
                    stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData().substring(0, 23)));
                    stringBuffer.append("]");
                } else {
                    string = new String(String.valueOf(lEPPPOptionList.getData().substring(0, 2)) + lEPPPOptionList.getData().substring(3, 5)).toUpperCase();
                    int n = 0;
                    while (n < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                        if (LEPPPDebugMessage.PROTOCOL_LIST[n].equals(string)) break;
                        n += 2;
                    }
                    if (n + 1 < LEPPPDebugMessage.PROTOCOL_LIST.length) {
                        stringBuffer.append(LEPPPDebugMessage.PROTOCOL_LIST[n + 1]);
                        stringBuffer.append("[0x");
                        stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                        stringBuffer.append("]");
                    }
                }
                lEPPPOptionList = lEPPPOptionList.getNextOptionList();
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static {
        IPCP_OPTIONS.put("01", "IP-Addresses (deprecated)");
        IPCP_OPTIONS.put("02", "IP-Compression-Protocol");
        IPCP_OPTIONS.put("03", "IP-Address");
        IPCP_OPTIONS.put("81", "Primary DNS Server Address");
        IPCP_OPTIONS.put("82", "Primary NBNS Server Address");
        IPCP_OPTIONS.put("83", "Secondary DNS Server Address");
        IPCP_OPTIONS.put("84", "Secondary NBNS Server Address");
    }
}

