/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.userlocator;

import com.lucent.ra.nms.backend.LEMonSessionsMessage;
import com.lucent.ra.nms.backend.LEMonUsersMessage;
import com.lucent.ra.nms.diag.LETerminationDebugFactory;
import com.lucent.ra.nms.diag.LETerminationDebugMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPBoundMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPCalleXStationIDMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPDeactivateMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPDebugFactory;
import com.lucent.ra.nms.diag.mdp.LEMDPDebugMessage;
import com.lucent.ra.nms.diag.mdp.LEMDPReadyMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPCHAPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugFactory;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPPAPMessage;
import com.lucent.ra.nms.diag.userlocator.LEHoundDogDetailMessage;
import com.lucent.ra.nms.diag.userlocator.LEHoundDogMessage;
import com.lucent.ra.nms.diag.userlocator.LEHoundDogUserMonitor;
import com.lucent.ra.nms.diag.userlocator.LEModemPreBoundBuffer;
import com.lucent.ra.nms.diag.userlocator.LEPreUserIDDetectedBuffer;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LEHoundDog
extends LEObservable
implements LEObserver {
    static LEHoundDog s_hd;
    Hashtable m_taggedKeys = new Hashtable();
    Hashtable m_htUserIDsToObs = new Hashtable();
    Hashtable m_htCallerStationIDsToObs = new Hashtable();
    Hashtable m_htCalledStationIDsToObs = new Hashtable();
    LEModemPreBoundBuffer m_preModemBoundBuf = new LEModemPreBoundBuffer();
    LEPreUserIDDetectedBuffer m_preUserIDDetectBuf = new LEPreUserIDDetectedBuffer();
    Hashtable m_htPortToModem = new Hashtable();
    public static final String KEYSEP = "###";
    Hashtable m_htPortToCallerXmsg;
    Hashtable m_htResourceIDtoPMs;
    public static final int NUM_DIGITS_ENDING_CALLERID = 4;
    Vector m_currentISDNCalls = new Vector();

    private LEHoundDog() {
        this.m_htResourceIDtoPMs = new Hashtable();
        this.m_htPortToCallerXmsg = new Hashtable();
    }

    Hashtable getTaggedKeys() {
        return this.m_taggedKeys;
    }

    public static LEHoundDog GetHoundDog() {
        if (s_hd == null) {
            s_hd = new LEHoundDog();
        }
        return s_hd;
    }

    public boolean addPortMasterToMonitor(LEPortMaster lEPortMaster) {
        if (!lEPortMaster.isConnected()) {
            return false;
        }
        LEPPPDebugFactory.addObserver(lEPortMaster, (LEObserver)this);
        LEMDPDebugFactory.addObserver(lEPortMaster, (LEObserver)this);
        LETerminationDebugFactory.addObserver(lEPortMaster, (LEObserver)this);
        this.m_htResourceIDtoPMs.put(lEPortMaster.getResourceID(), lEPortMaster);
        Vector vector = this.getUsersIDsInterestedIn();
        Vector vector2 = new Vector();
        Enumeration enumeration = this.m_htResourceIDtoPMs.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
        if (vector.size() != 0) {
            LEHoundDogUserMonitor lEHoundDogUserMonitor = new LEHoundDogUserMonitor(vector, this, vector2);
            new Thread(lEHoundDogUserMonitor).start();
        }
        return true;
    }

    public boolean addFileNameToMonitor(String string) {
        if (string != null) {
            LEPPPDebugFactory.addObserver(string, (LEObserver)this);
            LEMDPDebugFactory.addObserver(string, (LEObserver)this);
            LETerminationDebugFactory.addObserver(string, (LEObserver)this);
            return true;
        }
        return false;
    }

    public boolean removePortMasterToMonitor(LEPortMaster lEPortMaster) {
        LEPPPDebugFactory.deleteObserver(lEPortMaster.getDescription(), this);
        LEMDPDebugFactory.removeObserver(lEPortMaster.getDescription(), this);
        this.m_htResourceIDtoPMs.remove(lEPortMaster.getResourceID());
        return true;
    }

    public boolean changeBoard(LEPortMaster lEPortMaster, int n, int n2) {
        if (!lEPortMaster.isConnected()) {
            return false;
        }
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade != null && lEPortMaster.getHardwareType().equals("PM-4")) {
            LEPPPDebugFactory.ChangeBoards(lEPortMaster, n, n2);
            LETerminationDebugFactory.ChangeBoards(lEPortMaster, n, n2);
            LEMDPDebugFactory.ChangeBoards(lEPortMaster, n, n2);
        }
        return true;
    }

    public void addUserID(String string, LEObserver lEObserver) {
        Vector<LEObserver> vector;
        if (this.m_htUserIDsToObs.containsKey(string = string.toLowerCase())) {
            vector = (Vector<LEObserver>)this.m_htUserIDsToObs.get(string);
            if (!vector.contains(lEObserver)) {
                vector.addElement(lEObserver);
            }
        } else {
            vector = new Vector<LEObserver>();
            vector.addElement(lEObserver);
            this.m_htUserIDsToObs.put(string, vector);
        }
        vector = new Vector<LEObserver>();
        vector.addElement((LEObserver)((Object)string));
        Vector vector2 = new Vector();
        Enumeration enumeration = this.m_htResourceIDtoPMs.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(enumeration.nextElement());
        }
        LEHoundDogUserMonitor lEHoundDogUserMonitor = new LEHoundDogUserMonitor(vector, this, vector2);
        new Thread(lEHoundDogUserMonitor).start();
    }

    public void removeUserID(String string, LEObserver lEObserver) {
        if (this.m_htUserIDsToObs.containsKey(string = string.toLowerCase())) {
            Vector vector = (Vector)this.m_htUserIDsToObs.get(string);
            vector.removeElement(lEObserver);
            if (vector.isEmpty()) {
                this.m_htUserIDsToObs.remove(string);
            }
        }
    }

    public void addCallerStationID(String string, LEObserver lEObserver) {
        if (this.m_htCallerStationIDsToObs.containsKey(string)) {
            Vector vector = (Vector)this.m_htCallerStationIDsToObs.get(string);
            vector.addElement(lEObserver);
            return;
        }
        Vector<LEObserver> vector = new Vector<LEObserver>();
        vector.addElement(lEObserver);
        this.m_htCallerStationIDsToObs.put(string, vector);
    }

    public void removeCallerStationID(String string, LEObserver lEObserver) {
        if (this.m_htCallerStationIDsToObs.containsKey(string)) {
            Vector vector = (Vector)this.m_htCallerStationIDsToObs.get(string);
            vector.removeElement(lEObserver);
            if (vector.isEmpty()) {
                this.m_htCallerStationIDsToObs.remove(string);
            }
        }
    }

    public void addCalledStationID(String string, LEObserver lEObserver) {
        if (this.m_htCallerStationIDsToObs.containsKey(string)) {
            Vector vector = (Vector)this.m_htCallerStationIDsToObs.get(string);
            vector.addElement(lEObserver);
            return;
        }
        Vector<LEObserver> vector = new Vector<LEObserver>();
        vector.addElement(lEObserver);
        this.m_htCallerStationIDsToObs.put(string, vector);
    }

    public void removeCalledStationID(String string, LEObserver lEObserver) {
        if (this.m_htCalledStationIDsToObs.containsKey(string)) {
            Vector vector = (Vector)this.m_htCalledStationIDsToObs.get(string);
            vector.removeElement(lEObserver);
            if (vector.isEmpty()) {
                this.m_htCalledStationIDsToObs.remove(string);
            }
        }
    }

    public synchronized void update(LEObservable lEObservable, Object object) {
        if (object instanceof LEMDPDebugMessage) {
            LEMDPDebugMessage lEMDPDebugMessage = (LEMDPDebugMessage)object;
            this.processMDPDebugMessage(lEMDPDebugMessage);
            return;
        }
        if (object instanceof LETerminationDebugMessage) {
            LETerminationDebugMessage lETerminationDebugMessage = (LETerminationDebugMessage)object;
            this.processTerminationDebugMessage(lETerminationDebugMessage);
            return;
        }
        if (object instanceof LEPPPDebugMessage) {
            LEPPPDebugMessage lEPPPDebugMessage = (LEPPPDebugMessage)object;
            this.processPPPDebugMessage(lEPPPDebugMessage);
            return;
        }
    }

    void processMDPDebugMessage(LEMDPDebugMessage lEMDPDebugMessage) {
        String string = lEMDPDebugMessage.getSourceMorS();
        if (string == null) {
            return;
        }
        if (string.indexOf("M") != -1) {
            this.processMDPModemMessage(lEMDPDebugMessage);
            return;
        }
        this.processMDPPortMessage(lEMDPDebugMessage);
    }

    void processMDPModemMessage(LEMDPDebugMessage lEMDPDebugMessage) {
        try {
            String string;
            String string2 = LEHoundDog.GenerateModemKey(lEMDPDebugMessage);
            if (this.m_taggedKeys.containsKey(string2)) {
                string = (String)this.m_taggedKeys.get(string2);
                LEVector lEVector = this.getInterestedObservers(string);
                if (lEVector != null) {
                    LEHoundDogMessage lEHoundDogMessage = new LEHoundDogMessage(lEMDPDebugMessage, string2, string);
                    if (lEMDPDebugMessage instanceof LEMDPReadyMessage) {
                        lEHoundDogMessage.setType("term");
                    }
                    this.notifyObservers(lEHoundDogMessage, lEVector);
                }
            } else if (this.m_htPortToModem.contains(string2)) {
                this.m_preUserIDDetectBuf.addDebugMessage(string2, lEMDPDebugMessage);
            } else if (!this.m_htPortToModem.contains(string2)) {
                this.m_preModemBoundBuf.addDebugMessage(string2, lEMDPDebugMessage);
            }
            if (lEMDPDebugMessage instanceof LEMDPReadyMessage) {
                this.cleanupFromModemKey(string2);
                return;
            }
            if (lEMDPDebugMessage instanceof LEMDPDeactivateMessage) {
                LEMDPDeactivateMessage cfr_ignored_0 = (LEMDPDeactivateMessage)lEMDPDebugMessage;
                string = this.getPortKeyFromModemKey(string2);
                if (this.m_htPortToModem.containsKey(string)) {
                    this.m_htPortToModem.remove(string);
                    return;
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, lEMDPDebugMessage.getData());
            LEDebug.getLog().logln(20, exception);
        }
    }

    void processMDPPortMessage(LEMDPDebugMessage lEMDPDebugMessage) {
        Cloneable cloneable;
        Object object;
        String string;
        Object object2;
        String string2 = LEHoundDog.GeneratePortKey(lEMDPDebugMessage);
        String string3 = this.m_htPortToModem.containsKey(string2) ? (String)this.m_htPortToModem.get(string2) : string2;
        String string4 = lEMDPDebugMessage.getHost();
        String string5 = lEMDPDebugMessage.getSlotNum();
        if (string5 != null && string5.equals("")) {
            string5 = null;
        }
        lEMDPDebugMessage.getSourceMorS();
        if (lEMDPDebugMessage instanceof LEMDPBoundMessage) {
            object2 = (LEMDPBoundMessage)lEMDPDebugMessage;
            string = ((LEMDPBoundMessage)object2).getBoundModem();
            object = LEHoundDog.GenerateModemKey(string4, string5, string);
            this.m_htPortToModem.put(string2, object);
            string3 = object;
            cloneable = this.m_preModemBoundBuf.getDebugMessages((String)object);
            if (this.m_htPortToCallerXmsg.containsKey(string2)) {
                LEMDPCalleXStationIDMessage lEMDPCalleXStationIDMessage = (LEMDPCalleXStationIDMessage)this.m_htPortToCallerXmsg.get(string2);
                this.m_preUserIDDetectBuf.addDebugMessage(string3, lEMDPCalleXStationIDMessage);
                String string6 = this.isInterestedinCallerID(lEMDPCalleXStationIDMessage);
                if (string6 != null) {
                    String string7 = string6;
                    this.m_taggedKeys.put(string3, string7);
                    String string8 = string7;
                    LEVector lEVector = this.getInterestedObservers(string8);
                    if (lEVector != null) {
                        Vector vector = this.m_preUserIDDetectBuf.getDebugMessages(string3);
                        LEHoundDogMessage lEHoundDogMessage = new LEHoundDogMessage(vector, string3, string8);
                        this.notifyObservers(lEHoundDogMessage, lEVector);
                    }
                }
                this.m_htPortToCallerXmsg.remove(string2);
            }
            this.m_preUserIDDetectBuf.addDebugMessage(string3, (Vector)cloneable);
        } else if (lEMDPDebugMessage instanceof LEMDPCalleXStationIDMessage) {
            this.cleanupFromPortKey(string2);
            this.m_htPortToCallerXmsg.put(string2, (LEMDPCalleXStationIDMessage)lEMDPDebugMessage);
            this.isInterestedinCallerID((LEMDPCalleXStationIDMessage)lEMDPDebugMessage);
        }
        if (this.m_taggedKeys.containsKey(string2)) {
            object2 = (String)this.m_htPortToModem.get(string2);
            if (object2 != null) {
                string = (String)this.m_taggedKeys.get(object2);
                object = new LEHoundDogMessage(lEMDPDebugMessage, (String)object2, string);
            } else {
                string = (String)this.m_taggedKeys.get(string2);
                object = new LEHoundDogMessage(lEMDPDebugMessage, string2, string);
            }
            cloneable = this.getInterestedObservers(string);
            this.notifyObservers(object, (LEVector)cloneable);
            return;
        }
        this.m_preUserIDDetectBuf.addDebugMessage(string3, lEMDPDebugMessage);
    }

    void processPPPDebugMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        LEHoundDogMessage lEHoundDogMessage;
        Vector vector;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string = LEHoundDog.GeneratePortKey(lEPPPDebugMessage);
        if (this.m_htPortToCallerXmsg.containsKey(string)) {
            object5 = (LEMDPCalleXStationIDMessage)this.m_htPortToCallerXmsg.get(string);
            object4 = this.isInterestedinCallerID((LEMDPCalleXStationIDMessage)object5);
            if (object4 != null) {
                object3 = object4;
                this.m_taggedKeys.put(string, object4);
                object2 = object3;
                object = this.getInterestedObservers((String)object2);
                if (object != null) {
                    vector = this.m_preUserIDDetectBuf.getDebugMessages(string);
                    lEHoundDogMessage = new LEHoundDogMessage(vector, string, (String)object2);
                    this.notifyObservers(lEHoundDogMessage, (LEVector)object);
                }
            }
            this.m_htPortToCallerXmsg.remove(string);
        }
        object5 = (String)this.m_htPortToModem.get(string);
        object4 = null;
        object4 = object5 != null ? object5 : string;
        if (this.m_taggedKeys.containsKey(object4)) {
            object3 = (String)this.m_taggedKeys.get(object4);
            object2 = this.getInterestedObservers((String)object3);
            if (object2 != null) {
                object = new LEHoundDogMessage(lEPPPDebugMessage, (String)object4, (String)object3);
                this.notifyObservers(object, (LEVector)object2);
                return;
            }
        } else {
            this.m_preUserIDDetectBuf.addDebugMessage((String)object4, lEPPPDebugMessage);
        }
        if ((lEPPPDebugMessage instanceof LEPPPPAPMessage || lEPPPDebugMessage instanceof LEPPPCHAPMessage) && lEPPPDebugMessage.getDirection().equals("Received")) {
            object3 = null;
            if (lEPPPDebugMessage instanceof LEPPPPAPMessage) {
                object3 = ((LEPPPPAPMessage)lEPPPDebugMessage).getLoginID();
            } else if (lEPPPDebugMessage instanceof LEPPPCHAPMessage) {
                object3 = ((LEPPPCHAPMessage)lEPPPDebugMessage).getLoginID();
            }
            if (object3 != null) {
                object3 = ((String)object3).toLowerCase();
            }
            if (object3 != null && this.m_htUserIDsToObs.containsKey(object3)) {
                this.m_taggedKeys.put(object4, object3);
                object2 = object3;
                object = this.getInterestedObservers((String)object2);
                if (object != null) {
                    vector = this.m_preUserIDDetectBuf.getDebugMessages((String)object4);
                    lEHoundDogMessage = new LEHoundDogMessage(vector, (String)object4, (String)object2);
                    this.notifyObservers(lEHoundDogMessage, (LEVector)object);
                }
            }
        }
    }

    void processTerminationDebugMessage(LETerminationDebugMessage lETerminationDebugMessage) {
        String string;
        LEVector lEVector;
        String string2;
        String string3;
        String string4 = lETerminationDebugMessage.getHost();
        String string5 = LEHoundDog.GeneratePortKey(string4, string3 = lETerminationDebugMessage.getSlotNum(), string2 = lETerminationDebugMessage.getPortNum());
        if (this.m_htPortToModem.containsKey(string5)) {
            String string6;
            LEVector lEVector2;
            String string7 = (String)this.m_htPortToModem.get(string5);
            if (this.m_taggedKeys.containsKey(string7) && (lEVector2 = this.getInterestedObservers(string6 = (String)this.m_taggedKeys.get(string7))) != null) {
                LEHoundDogMessage lEHoundDogMessage = new LEHoundDogMessage(lETerminationDebugMessage, string7, string6);
                this.notifyObservers(lEHoundDogMessage, lEVector2);
                return;
            }
        } else if (this.m_taggedKeys.containsKey(string5) && (lEVector = this.getInterestedObservers(string = (String)this.m_taggedKeys.get(string5))) != null) {
            LEHoundDogMessage lEHoundDogMessage = new LEHoundDogMessage(lETerminationDebugMessage, string5, string);
            lEHoundDogMessage.setType("term");
            this.notifyObservers(lEHoundDogMessage, lEVector);
            this.cleanupFromPortKey(string5);
        }
    }

    String isInterestedinCallerID(LEMDPCalleXStationIDMessage lEMDPCalleXStationIDMessage) {
        String string = lEMDPCalleXStationIDMessage.getCallerStationID();
        if (string == null) {
            return null;
        }
        Enumeration enumeration = this.m_htCallerStationIDsToObs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = string.indexOf(string2);
            if (n <= -1) continue;
            return string2;
        }
        return null;
    }

    void foundUserThroughMonitor(LEHoundDogDetailMessage lEHoundDogDetailMessage) {
        String string = lEHoundDogDetailMessage.getItemFound();
        String string2 = lEHoundDogDetailMessage.getKey();
        LEVector lEVector = this.getInterestedObservers(string);
        if (lEVector != null && !this.m_taggedKeys.containsKey(string2)) {
            this.notifyObservers(lEHoundDogDetailMessage, lEVector);
            this.m_taggedKeys.put(string2, string);
        }
    }

    void cleanupFromPortKey(String string) {
        this.m_preUserIDDetectBuf.clearBuf(string);
        if (this.m_htPortToModem.containsKey(string)) {
            this.m_htPortToModem.remove(string);
        }
        if (this.m_taggedKeys.containsKey(string)) {
            this.m_taggedKeys.remove(string);
        }
    }

    void cleanupFromModemKey(String string) {
        if (string == null) {
            return;
        }
        this.m_preModemBoundBuf.clearBuf(string);
        this.m_preUserIDDetectBuf.clearBuf(string);
        String string2 = this.getPortKeyFromModemKey(string);
        if (string2 != null) {
            this.cleanupFromPortKey(string2);
            this.m_htPortToModem.remove(string2);
        }
        this.m_taggedKeys.remove(string);
    }

    String getPortKeyFromModemKey(String string) {
        if (this.m_htPortToModem.contains(string)) {
            Enumeration enumeration = this.m_htPortToModem.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this.m_htPortToModem.get(string2);
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    LEVector getInterestedObservers(String string) {
        Vector vector = null;
        if (this.m_htUserIDsToObs.containsKey(string)) {
            vector = (Vector)this.m_htUserIDsToObs.get(string);
        } else if (this.m_htCallerStationIDsToObs.containsKey(string)) {
            vector = (Vector)this.m_htCallerStationIDsToObs.get(string);
        } else if (this.m_htCalledStationIDsToObs.containsKey(string)) {
            vector = (Vector)this.m_htCallerStationIDsToObs.get(string);
        }
        if (vector == null) {
            return null;
        }
        return new LEVector(vector);
    }

    Vector getUsersIDsInterestedIn() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.m_htUserIDsToObs.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        return vector;
    }

    public static String GenerateModemKey(String string, String string2, String string3) {
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(string);
        stringBuffer.append(KEYSEP);
        stringBuffer.append(string2);
        stringBuffer.append(KEYSEP);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static String GenerateModemKey(LEMDPDebugMessage lEMDPDebugMessage) {
        String string = lEMDPDebugMessage.getHost();
        String string2 = lEMDPDebugMessage.getSlotNum();
        String string3 = lEMDPDebugMessage.getSourceMorS();
        return LEHoundDog.GenerateModemKey(string, string2, string3);
    }

    public static String GenerateModemKey(LEMonUsersMessage lEMonUsersMessage) {
        String string = lEMonUsersMessage.getResourceID();
        String string2 = "slot" + lEMonUsersMessage.getBoard();
        String string3 = lEMonUsersMessage.getModem();
        return LEHoundDog.GenerateModemKey(string, string2, string3);
    }

    public static String GenerateModemKey(LEMonSessionsMessage lEMonSessionsMessage) {
        String string = lEMonSessionsMessage.getResourceID();
        String string2 = lEMonSessionsMessage.getBoard();
        String string3 = null;
        if (string2 != null && !string2.equals("")) {
            string3 = "slot" + string2;
        }
        String string4 = lEMonSessionsMessage.getModem();
        return LEHoundDog.GenerateModemKey(string, string3, string4);
    }

    public static String GeneratePortKey(String string, String string2, String string3) {
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(string);
        stringBuffer.append(KEYSEP);
        stringBuffer.append(string2);
        stringBuffer.append(KEYSEP);
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public static String GeneratePortKey(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHost();
        String string2 = lEPPPDebugMessage.getSlotNum();
        String string3 = lEPPPDebugMessage.getPortNum();
        return LEHoundDog.GeneratePortKey(string, string2, string3);
    }

    public static String GeneratePortKey(LEMDPDebugMessage lEMDPDebugMessage) {
        String string = lEMDPDebugMessage.getHost();
        String string2 = lEMDPDebugMessage.getSlotNum();
        String string3 = lEMDPDebugMessage.getSourceMorS();
        return LEHoundDog.GeneratePortKey(string, string2, string3);
    }

    public static String GeneratePortKey(LEMonSessionsMessage lEMonSessionsMessage) {
        String string = lEMonSessionsMessage.getResourceID();
        String string2 = lEMonSessionsMessage.getBoard();
        String string3 = null;
        string3 = string2 != null && !string2.equals("") ? "slot" + string2 : "";
        String string4 = lEMonSessionsMessage.getPortName();
        return LEHoundDog.GeneratePortKey(string, string3, string4);
    }

    public static String GeneratePortKey(LEMonUsersMessage lEMonUsersMessage) {
        String string = lEMonUsersMessage.getResourceID();
        String string2 = "slot" + lEMonUsersMessage.getBoard();
        String string3 = lEMonUsersMessage.getPortName();
        return LEHoundDog.GeneratePortKey(string, string2, string3);
    }

    public static String GetHostNameFromKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        return string2;
    }

    public static String GetBoardNumFromKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEYSEP);
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    public static String GetSourcePortFromKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEYSEP);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }
}

