/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEHelpManager;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEIPXAddressFormLine
extends Panel
implements LEFormLine,
ActionListener,
KeyListener,
MouseListener {
    public static final String SEP = new String(":");
    public static final String VALID = new String("00000000:000000000000 - FFFFFFFF:FFFFFFFFFFFF");
    LETextField m_network;
    LETextField m_mac;
    LEFormLineListener m_listener;

    public LEIPXAddressFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_network = new LETextField(8);
        this.add(this.m_network);
        this.m_network.setHex(true);
        this.m_network.addKeyListener(this);
        this.m_network.addActionListener(this);
        this.add(new Label(":", 1));
        this.m_mac = new LETextField(12);
        this.add(this.m_mac);
        this.m_mac.setHex(true);
        this.m_mac.addActionListener(this);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
    }

    public void setValue(Object object) {
        String string = object.toString();
        int n = string.indexOf(SEP, 0);
        if (n == -1) {
            this.m_network.setText(string);
            return;
        }
        this.m_network.setText(string.substring(0, n));
        this.m_mac.setText(string.substring(n + 1, string.length()));
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public String getValue() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_network.getText();
        int n2 = n = Math.min(string.length(), 8);
        while (n2 < 8) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(SEP);
        string = this.m_mac.getText();
        int n3 = n = Math.min(string.length(), 12);
        while (n3 < 12) {
            stringBuffer.append('0');
            ++n3;
        }
        stringBuffer.append(string.substring(0, n));
        return new String(stringBuffer);
    }

    public String getValidValues() {
        return VALID;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            return string2.equals(string);
        }
        return false;
    }

    public boolean isValueValid() {
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ':') {
            this.m_mac.requestFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyListener();
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

