/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEForm;
import com.lucent.ra.nms.forms.LEModemCanvas;
import com.lucent.ra.nms.forms.LEModemGraphicCanvas;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LECompMatrix;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEStatusDialog;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEModemsForm
extends Panel
implements LEForm,
ActionListener,
LEObserver {
    LEVector m_context;
    String m_platform;
    LEPortMaster[] m_pms;
    Panel m_controls;
    Choice m_source;
    Choice m_type;
    TextField m_values;
    LECompMatrix m_matrix;
    int m_rows;
    int m_mpr;

    public LEModemsForm(int n) {
        this.m_mpr = n;
        this.setLayout(new BorderLayout(5, 5));
        this.m_controls = new Panel();
        this.m_controls.setLayout(new BorderLayout(5, 5));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 5, 0));
        panel.add(new Label("Set"));
        this.m_source = new Choice();
        panel.add(this.m_source);
        this.m_type = new Choice();
        this.m_type.add("All");
        this.m_type.add("Modems{s}");
        panel.add(this.m_type);
        this.m_controls.add("West", panel);
        this.m_values = new TextField();
        this.m_controls.add("Center", this.m_values);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0, 5, 0));
        Button button = new Button("Available");
        button.addActionListener(this);
        panel2.add(button);
        panel2.add(new LEModemGraphicCanvas(1));
        panel2.add(new LEModemGraphicCanvas(0));
        button = new Button("Last Call");
        panel2.add(button);
        button.addActionListener(this);
        panel2.add(new LEModemGraphicCanvas(3));
        panel2.add(new LEModemGraphicCanvas(0));
        button = new Button("Busy");
        panel2.add(button);
        button.addActionListener(this);
        panel2.add(new LEModemGraphicCanvas(2));
        panel2.add(new LEModemGraphicCanvas(0));
        this.m_controls.add("East", panel2);
    }

    public LEModemsForm() {
        this(10);
    }

    public void setContext(String string, LEVector lEVector) {
        this.m_platform = string;
        this.m_context = lEVector;
        if (this.m_context.size() == 1) {
            this.m_type.add("Slot");
        }
    }

    public void setPortMasters(LEPortMaster[] lEPortMasterArray) {
        boolean bl = false;
        if (this.m_pms == null || this.m_pms.length != lEPortMasterArray.length) {
            bl = true;
        } else if (this.m_pms != null) {
            int n = 0;
            while (!bl && n < this.m_pms.length) {
                boolean bl2 = false;
                int n2 = 0;
                while (!bl2 && n2 < lEPortMasterArray.length) {
                    if (this.m_pms[n] == lEPortMasterArray[n2]) {
                        bl2 = true;
                    }
                    ++n2;
                }
                if (!bl2) {
                    bl = true;
                }
                ++n;
            }
        }
        if (bl) {
            this.gone();
            this.m_pms = lEPortMasterArray;
            this.removeAll();
            this.m_source.removeAll();
            String[] stringArray = this.getRowTitles();
            String[] stringArray2 = this.getColumnTitles();
            Component[][] componentArray = this.getFormComponents();
            this.m_matrix = new LECompMatrix(stringArray, stringArray2, componentArray, true);
            LEBorderPanel lEBorderPanel = new LEBorderPanel(1);
            lEBorderPanel.setLayout(new BorderLayout());
            lEBorderPanel.add("Center", new LEScrollPanel(this.m_matrix));
            this.add("Center", lEBorderPanel);
            this.add("South", this.m_controls);
            this.invalidate();
            this.validate();
        }
    }

    public void save(Frame frame) {
        if (this.m_pms == null) {
            return;
        }
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        boolean bl = false;
        int n = 0;
        while (n < this.m_pms.length) {
            LEModems lEModems = this.getModemsFor(this.m_pms[n]);
            if (lEModems != null) {
                int n2 = 0;
                while (n2 < this.m_rows) {
                    LEModemCanvas lEModemCanvas = (LEModemCanvas)this.m_matrix.getComponent(n2, n);
                    int n3 = n2 * this.m_mpr;
                    int n4 = (n2 + 1) * this.m_mpr;
                    int n5 = n3;
                    while (n5 < n4) {
                        String string = "M" + n5;
                        String string2 = (String)lEModems.get(string);
                        if (string2 != null) {
                            int n6 = lEModemCanvas.getModemState(n5);
                            switch (n6) {
                                case 1: {
                                    if (!string2.equals("ADMIN") && !string2.equals("ACT(LC)")) break;
                                    lEModems.set(string, "READY");
                                    break;
                                }
                                case 2: {
                                    if (!string2.equals("ACT(LC)") && !string2.equals("READY")) break;
                                    lEModems.set(string, "ADMIN");
                                    break;
                                }
                                case 3: {
                                    if (!string2.equals("READY")) break;
                                    lEModems.set(string, "ACT(LC)");
                                    break;
                                }
                            }
                        }
                        ++n5;
                    }
                    ++n2;
                }
                LEVector lEVector = lEModems.saveChanges();
                if (lEVector != null) {
                    bl = true;
                    new LECmdErrorDialog(LEUiUtils.getFrame(this), lEModems.getConnectionFacade(), lEVector);
                }
            }
            ++n;
        }
        if (bl) {
            this.refresh();
        }
        lEStatusDialog.hideStatus();
    }

    public void refresh() {
        if (this.m_pms == null) {
            return;
        }
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = 0;
        while (n < this.m_pms.length) {
            LEModems lEModems = this.getModemsFor(this.m_pms[n]);
            if (lEModems != null) {
                lEModems.refresh();
            }
            ++n;
        }
        lEStatusDialog.hideStatus();
    }

    public void gone() {
        if (this.m_pms != null) {
            int n = 0;
            while (n < this.m_pms.length) {
                LEModems lEModems = this.getModemsFor(this.m_pms[n]);
                if (lEModems != null) {
                    lEModems.deleteObserver(this);
                }
                ++n;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.m_source.getSelectedItem();
        int n = -1;
        int n2 = 0;
        while (n2 < 3) {
            if (string.equals(this.m_matrix.getColTitle(n2))) {
                n = n2;
            }
            ++n2;
        }
        LEModems lEModems = null;
        if (n > -1) {
            lEModems = this.getModemsFor(this.m_pms[n]);
        }
        if (lEModems != null) {
            String string2 = actionEvent.getActionCommand();
            int n3 = string2.equals("Available") ? 1 : (string2.equals("Last Call") ? 3 : 2);
            if (this.m_type.getSelectedItem().equals("All")) {
                int n4 = 0;
                while (n4 < this.m_rows) {
                    LEModemCanvas lEModemCanvas = (LEModemCanvas)this.m_matrix.getComponent(n4, n);
                    if (lEModemCanvas != null) {
                        int n5 = 0;
                        while (n5 < this.m_mpr) {
                            int n6 = n4 * this.m_mpr + n5;
                            lEModemCanvas.changeModem(n6, n3);
                            ++n5;
                        }
                    }
                    ++n4;
                }
                return;
            }
            if (this.m_type.getSelectedItem().equals("Slot")) {
                LEVector lEVector = this.parseValues(this.m_values.getText());
                int n7 = lEVector.size();
                int n8 = 0;
                while (n8 < n7) {
                    LEModemCanvas lEModemCanvas;
                    int n9 = (Integer)lEVector.elementAt(n8);
                    if (n9 > -1 && n9 < this.m_rows && (lEModemCanvas = (LEModemCanvas)this.m_matrix.getComponent(n9, n)) != null) {
                        int n10 = 0;
                        while (n10 < this.m_mpr) {
                            int n11 = n9 * this.m_mpr + n10;
                            lEModemCanvas.changeModem(n11, n3);
                            ++n10;
                        }
                    }
                    ++n8;
                }
                return;
            }
            LEVector lEVector = this.parseValues(this.m_values.getText());
            int n12 = lEVector.size();
            int n13 = 0;
            while (n13 < n12) {
                int n14 = (Integer)lEVector.elementAt(n13);
                int n15 = n14 / this.m_mpr;
                LEModemCanvas lEModemCanvas = (LEModemCanvas)this.m_matrix.getComponent(n15, n);
                if (lEModemCanvas != null) {
                    lEModemCanvas.changeModem(n14, n3);
                }
                ++n13;
            }
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        String string = null;
        String string2 = null;
        if (lEObservable instanceof LEConfig) {
            string = ((LEConfig)lEObservable).getConnectionFacade().getDescription();
        }
        if (object instanceof String) {
            string2 = (String)object;
        }
        if (string != null && string2 != null) {
            this.updateModem(string, string2);
        }
    }

    String[] getRowTitles() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.m_pms.length) {
            LEModems lEModems = this.getModemsFor(this.m_pms[n2]);
            if (lEModems != null) {
                LEVector lEVector = lEModems.getKeys();
                int n3 = lEVector.size();
                int n4 = 0;
                while (n4 < n3) {
                    String string = (String)lEVector.elementAt(n4);
                    string = string.substring(1);
                    int n5 = Integer.parseInt(string);
                    n = Math.max(n, n5);
                    ++n4;
                }
            }
            ++n2;
        }
        this.m_rows = (n - 1) / this.m_mpr + 1;
        if (this.m_rows < 0) {
            this.m_rows = 0;
        }
        String[] stringArray = new String[this.m_rows];
        int n6 = 0;
        while (n6 < this.m_rows) {
            stringArray[n6] = "M" + n6 * this.m_mpr + " - M" + ((n6 + 1) * this.m_mpr - 1);
            ++n6;
        }
        return stringArray;
    }

    String[] getColumnTitles() {
        String[] stringArray = new String[this.m_pms.length];
        int n = 0;
        while (n < this.m_pms.length) {
            stringArray[n] = this.m_pms[n].getDescription();
            this.m_source.add(this.m_pms[n].getDescription());
            ++n;
        }
        return stringArray;
    }

    Component[][] getFormComponents() {
        Component[][] componentArray = new Component[this.m_rows][this.m_pms.length];
        int n = 0;
        while (n < this.m_pms.length) {
            LEModems lEModems = this.getModemsFor(this.m_pms[n]);
            if (lEModems != null) {
                lEModems.addObserver(this);
                int n2 = 0;
                while (n2 < this.m_rows) {
                    int n3 = n2 * this.m_mpr;
                    int n4 = n3 + this.m_mpr;
                    LEModemCanvas lEModemCanvas = new LEModemCanvas(n3, this.m_mpr);
                    componentArray[n2][n] = lEModemCanvas;
                    int n5 = n3;
                    while (n5 < n4) {
                        String string = "M" + n5;
                        String string2 = (String)lEModems.get(string);
                        lEModemCanvas.setModem(n5, this.getModemState(string2));
                        ++n5;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return componentArray;
    }

    LEModems getModemsFor(LEConfig lEConfig) {
        int n = this.m_context.size();
        int n2 = 0;
        while (lEConfig != null && n2 < n) {
            Object object = lEConfig.get((String)this.m_context.elementAt(n2));
            if (object instanceof LEConfig) {
                lEConfig = (LEConfig)object;
            }
            ++n2;
        }
        if (lEConfig instanceof LEModems) {
            return (LEModems)lEConfig;
        }
        return null;
    }

    LEVector parseValues(String string) {
        LEVector lEVector = new LEVector();
        int n = string.length();
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n2 > -1) {
                        n2 = n2 * 10 + Character.digit(c, 10);
                        break;
                    }
                    n2 = Character.digit(c, 10);
                    break;
                }
                case '-': {
                    bl = true;
                    n3 = n2;
                    n2 = -1;
                    break;
                }
                case ',': {
                    this.process(lEVector, n2, n3, bl);
                    n2 = -1;
                    n3 = -1;
                    bl = false;
                    break;
                }
                default: {
                    n2 = -1;
                    n3 = -1;
                    bl = false;
                }
                case 'M': 
                case 'm': 
            }
            ++n4;
        }
        this.process(lEVector, n2, n3, bl);
        return lEVector;
    }

    void process(LEVector lEVector, int n, int n2, boolean bl) {
        if (bl) {
            if (n2 > -1 && n > n2) {
                int n3 = n2;
                while (n3 <= n) {
                    lEVector.addElement(new Integer(n3));
                    ++n3;
                }
                return;
            }
        } else if (n > -1) {
            lEVector.addElement(new Integer(n));
        }
    }

    void updateModem(String string, String string2) {
        int n = -1;
        int n2 = 0;
        while (n == -1 && n2 < this.m_pms.length) {
            if (string.equals(this.m_matrix.getColTitle(n2))) {
                n = n2;
            }
            ++n2;
        }
        LEConfig lEConfig = null;
        if (n > -1) {
            lEConfig = this.getModemsFor(this.m_pms[n]);
        }
        if (lEConfig != null) {
            String string3 = (String)lEConfig.get(string2);
            int n3 = Integer.parseInt(string2.substring(1));
            int n4 = this.getModemState(string3);
            int n5 = n3 / this.m_mpr;
            LEModemCanvas lEModemCanvas = (LEModemCanvas)this.m_matrix.getComponent(n5, n);
            if (lEModemCanvas != null) {
                lEModemCanvas.setModem(n3, n4);
            }
        }
    }

    int getModemState(String string) {
        int n = 1;
        if (string == null || string.equals("DOWN")) {
            n = 0;
        } else if (string.equals("ADMIN")) {
            n = 2;
        } else if (string.equals("ACT(LC)")) {
            n = 3;
        }
        return n;
    }
}

