/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LENetmaskPanel;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LENetmask;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LENetmaskFormLine
extends LENetmaskPanel
implements LEFormLine,
MouseListener {
    LEFormLineListener m_listener;
    String m_valid;

    public LENetmaskFormLine() {
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        int n = 32;
        int n2 = 24;
        if (lEDataSpec != null) {
            String string = (String)lEDataSpec.getAttribute(LEAttributes.MAXIMUM);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                }
            }
            if ((string = (String)lEDataSpec.getAttribute(LEAttributes.MINIMUM)) != null) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                }
            }
            this.setCIDRRange(n2, n);
        }
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public void setValue(Object object) {
        String string = object.toString();
        if (string.length() > 0) {
            this.setNetmask(string);
        }
    }

    public String getValue() {
        return this.getCIDR();
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getMinCIDR();
            int n2 = this.getMaxCIDR();
            stringBuffer.append(LENetmask.GetQuadFromCIDR(n));
            stringBuffer.append(" - ");
            stringBuffer.append(LENetmask.GetQuadFromCIDR(n2));
            stringBuffer.append(" or /");
            stringBuffer.append(n);
            stringBuffer.append("- /");
            stringBuffer.append(n2);
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        if (object instanceof String) {
            String string = this.getValue();
            return string.equals((String)object);
        }
        return false;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean isValueValid() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

