## THIS FILE WAS GENERATED BY MIB2SCHEMA
## For attributes containing printable ASCII
## characters, you may add a format string
## specification in the attribute characteristics
## line
## As described in RFC 1157, some agents cannot
## accept messages whose length exceeds 484 octets
## For those groups whose var-bind list has many
## entries, you may split them up into different
## var-bind lists
proxy SHIVA-MIB
description "SHIVA-MIB agent"
serial 2
rpcid 100122
(

## Enumerated Type Definitions

	enum	mLogNewMessageTrapEnableE (
	   1	"disabled"
	   2	"emerg"
	   3	"alert"
	   4	"crit"
	   5	"err"
	   6	"warning"
	   7	"notice"
	   8	"info"
	   9	"debug"
	)

	enum	mLogPriorityE (
	   1	"not-possible"
	   2	"emerg"
	   3	"alert"
	   4	"crit"
	   5	"err"
	   6	"warning"
	   7	"notice"
	   8	"info"
	   9	"debug"
	)

	enum	samGlobalDeviceModeE (
	   1	"ramDownloader"
	   2	"romDownloader"
	   3	"downloadedImage"
	)

	enum	defaultSecurityTypeE (
	   1	"local"
	   2	"bindery"
	   3	"xtacacs"
	   4	"otacacs"
	   5	"kerberos"
	   6	"nis"
	   7	"nds"
	)

	enum	defaultServerOnlyE (
	   1	"false"
	   2	"true"
	)

	enum	clearLocalUsersE (
	   1	"notClear"
	   2	"clear"
	)

	enum	logTrapPriorityE (
	   1	"disabled"
	   2	"emerg"
	   3	"alert"
	   4	"crit"
	   5	"err"
	   6	"warning"
	   7	"notice"
	   8	"info"
	   9	"debug"
	)

	enum	logBufferPriorityE (
	   1	"not-possible"
	   2	"emerg"
	   3	"alert"
	   4	"crit"
	   5	"err"
	   6	"warning"
	   7	"notice"
	   8	"info"
	   9	"debug"
	)

	enum	logBufferFacilityE (
	   1	"default"
	   8	"init"
	   9	"inet"
	   10	"atalk"
	   11	"dnet"
	   12	"nw"
	   13	"audit"
	   16	"system"
	   17	"config"
	   18	"serial"
	   19	"dialout"
	   20	"ltl"
	)

	enum	logSavePriorityE (
	   1	"none"
	   2	"emerg"
	   3	"alert"
	   4	"crit"
	   5	"err"
	   6	"warning"
	   7	"notice"
	   8	"info"
	   9	"debug"
	)

	enum	logClearE (
	   1	"notClear"
	   2	"clear"
	)

	enum	vHardwareE (
	   1	"fp123"
	   2	"fp4"
	   3	"fp5"
	   4	"nme1"
	   5	"lre1"
	   6	"lrt1"
	   7	"ibm8235-002"
	   8	"ibm8235-001"
	   9	"lreplus"
	   10	"lrtplus"
	   11	"ibm8235-012"
	   12	"ibm8235-011"
	   13	"ibm8235-022"
	   14	"ibm8235-021"
	   15	"hp-j2624a"
	   16	"hp-j2623a"
	   17	"ibm8235e-Module"
	   18	"ibm8235t-Module"
	   19	"racal-ERAS"
	   20	"rapporteplus"
	   21	"rapporttplus"
	)

	enum	confRemoteBootE (
	   1	"disabled"
	   2	"enabled"
	)

	enum	confClearE (
	   1	"notClear"
	   2	"clear"
	)

	enum	serialPortStatusE (
	   1	"disabled"
	   2	"initializing"
	   3	"idle"
	   4	"packet"
	   5	"character"
	)

	enum	serialPortInitFlowE (
	   1	"none"
	   2	"hardware"
	   3	"software"
	)

	enum	serialPortModemTypeE (
	   1	"absent"
	   2	"internal"
	   3	"external"
	)

	enum	sessionActivityE (
	   1	"none"
	   2	"dialin"
	   3	"shell"
	   4	"dialout"
	   5	"file"
	   6	"lantolan"
	   7	"busyout"
	)

	enum	sessionLineModeE (
	   1	"unknown"
	   2	"async"
	   3	"sync"
	)

	enum	sessionPPPCompDecompE (
	   1	"none"
	   2	"stacLZS"
	)

	enum	sessionPPPCompCompE (
	   1	"none"
	   2	"stacLZS"
	)

	enum	sessionPPPCompStacSendCheckE (
	   1	"none"
	   4	"sequenceNumber"
	   5	"microsoft"
	)

	enum	sessionPPPCompStacRecvCheckE (
	   1	"none"
	   4	"sequenceNumber"
	   5	"microsoft"
	)

	enum	sessionIPAddrSrcE (
	   1	"none"
	   2	"peer"
	   3	"usercfg"
	   5	"dhcp"
	   6	"pool"
	)

	enum	sessStatusE (
	   1	"connect"
	   2	"disconnect"
	   3	"suspend"
	   4	"resume"
	)

	enum	sessVirtualE (
	   1	"normal"
	   2	"virtual"
	)

	enum	sessSuspendedE (
	   1	"connected"
	   2	"suspended"
	)

	enum	sessActivityE (
	   1	"none"
	   2	"dialin"
	   3	"shell"
	   4	"dialout"
	   5	"file"
	   6	"lantolan"
	   7	"busyout"
	)

	enum	sessIPAddrSrcE (
	   1	"none"
	   2	"peer"
	   3	"usercfg"
	   5	"dhcp"
	   6	"pool"
	)

	enum	sessPPPCompDecompE (
	   1	"none"
	   2	"stacLZS"
	)

	enum	sessPPPCompCompE (
	   1	"none"
	   2	"stacLZS"
	)

	enum	sessPPPCompStacSendCheckE (
	   1	"none"
	   4	"sequenceNumber"
	   5	"microsoft"
	)

	enum	sessPPPCompStacRecvCheckE (
	   1	"none"
	   4	"sequenceNumber"
	   5	"microsoft"
	)

	enum	sessLineLineModeE (
	   1	"unknown"
	   2	"async"
	   3	"sync"
	)

	enum	sessLineTypeE (
	   1	"empty"
	   2	"unknown"
	   3	"uart"
	   4	"modem"
	   5	"switched56"
	   6	"bri-st"
	   7	"usart"
	   8	"bri-u"
	)

	enum	featureProtocolE (
	   1	"general"
	   2	"ip"
	   3	"netware"
	   4	"netbeui"
	   5	"bridging"
	   6	"appletalk"
	)

	enum	featureDialInE (
	   1	"notPresent"
	   2	"disabled"
	   3	"bridged"
	   4	"routed"
	)

	enum	featureDialOutE (
	   1	"notPresent"
	   2	"disabled"
	   3	"enabled"
	)

	enum	featureShellE (
	   1	"notPresent"
	   2	"disabled"
	   3	"enabled"
	)

	enum	featureLanToLanOrigE (
	   1	"notPresent"
	   2	"disabled"
	   3	"bridged"
	   4	"routed"
	)

	enum	featureLanToLanAnsE (
	   1	"notPresent"
	   2	"disabled"
	   3	"bridged"
	   4	"routed"
	)

	enum	internalModemClassE (
	   1	"unknown"
	   2	"uart"
	   3	"modem"
	   4	"switched56"
	   5	"bri"
	   6	"usart"
	)

	enum	internalModemConnSpeedE (
	   1	"unknown"
	   2	"bps300"
	   3	"bps600"
	   4	"bps1200"
	   5	"bps2400"
	   6	"bps4800"
	   7	"bps7200"
	   8	"bps9600"
	   9	"bps12000"
	   10	"bps14400"
	   11	"bps16800"
	   12	"bps19200"
	   13	"bps21600"
	   14	"bps24000"
	   15	"bps26400"
	   16	"bps28800"
	)

	enum	internalModemErrorCorrE (
	   1	"unknown"
	   2	"none"
	   3	"lapm"
	   4	"mnp4"
	   5	"mnp10"
	)

	enum	internalModemDataComprE (
	   1	"unknown"
	   2	"none"
	   3	"mnp5"
	   4	"v42bis"
	)

	enum	serialLineStatusE (
	   1	"disabled"
	   2	"initializing"
	   3	"idle"
	   4	"packet"
	   5	"character"
	)

	enum	serialLineInitFlowE (
	   1	"none"
	   2	"hardware"
	   3	"software"
	)

	enum	serialLineModeE (
	   1	"unknown"
	   2	"async"
	   3	"sync"
	)

	enum	serialLineSwitchE (
	   1	"unknown"
	   2	"dms100"
	   3	"dms250"
	   4	"ess4"
	   5	"ess5"
	   6	"vn2"
	   7	"vn3"
	   8	"vn6"
	   9	"cr22"
	   10	"nat1"
	   11	"nat2"
	   12	"euro"
	   13	"itr6"
	   14	"ins64"
	   15	"austel"
	   16	"fetex150"
	   17	"btnr191"
	)

	enum	serialLineRadapE (
	   1	"none"
	   2	"v110"
	   3	"v120"
	   4	"v110-v42"
	)

	enum	serialLineTransCapE (
	   1	"unknown"
	   2	"speech"
	   3	"audio31"
	   4	"audio7"
	   5	"video"
	   6	"restdig"
	   7	"unrestdig"
	)

	enum	serialLineErrorCorrE (
	   1	"unknown"
	   2	"none"
	   3	"lapm"
	   4	"mnp4"
	   5	"mnp10"
	)

	enum	serialLineDataComprE (
	   1	"unknown"
	   2	"none"
	   3	"mnp5"
	   4	"v42bis"
	)

	enum	serialLineStatTabE (
	   1	"unknown"
	   2	"rs232table"
	)

	enum	serialLineTypeE (
	   1	"empty"
	   2	"unknown"
	   3	"uart"
	   4	"modem"
	   5	"switched56"
	   6	"bri-st"
	   7	"usart"
	   8	"bri-u"
	)

	enum	internalSlotTypeE (
	   1	"empty"
	   2	"unknown"
	   3	"uart"
	   4	"modem"
	   5	"switched56"
	   6	"bri-st"
	   7	"usart"
	   8	"bri-u"
	)

	enum	internalSlotStatusE (
	   1	"unknown"
	   2	"initializing"
	   3	"alive"
	   4	"dead"
	   5	"needscode"
	   6	"downloader"
	)

	enum	internalSlotSwitchE (
	   1	"unknown"
	   2	"dms100"
	   3	"dms250"
	   4	"ess4"
	   5	"ess5"
	   6	"vn2"
	   7	"vn3"
	   8	"vn6"
	   9	"cr22"
	   10	"nat1"
	   11	"nat2"
	   12	"euro"
	   13	"itr6"
	   14	"ins64"
	   15	"austel"
	   16	"fetex150"
	   17	"btnr191"
	)

	enum	internalSlotDchanStatE (
	   1	"unknown"
	   2	"dead"
	   3	"layer1-active"
	   4	"layer2-active"
	   5	"tei-assigned"
	   6	"userid-assigned"
	   7	"q931-active"
	   8	"invalidprofile"
	)

	enum	ltlSessionInitiationE (
	   1	"remote"
	   2	"user"
	   3	"timed"
	   4	"startup"
	)

	enum	ltlSessionStateE (
	   1	"idle"
	   2	"asking"
	   3	"trying"
	   4	"manual"
	   5	"disconnecting"
	   6	"up"
	)

	enum	ltlSessionPersistentE (
	   1	"on"
	   2	"off"
	)

	enum	ltlSessionLinkTypeE (
	   1	"unknown"
	   2	"ppp"
	   3	"aalap"
	)

	enum	bufferTypeTypeE (
	   1	"other"
	   2	"free"
	   3	"localtalk"
	   4	"ethernet"
	   5	"arp"
	   6	"data"
	   7	"erbf"
	   8	"etbf"
	   9	"malloc"
	   10	"serial"
	   11	"tokenring"
	)

	enum	confCheckSumE (
	   1	"valid"
	   2	"invalid"
	)

	enum	codeCheckSumE (
	   1	"valid"
	   2	"invalid"
	)

	enum	confWhyRebootE (
	   1	"other"
	   2	"hardware"
	   3	"firmware"
	   4	"software"
	   5	"config"
	)

	enum	confHowRebootE (
	   1	"cold"
	   2	"warm"
	   3	"ramdl"
	   4	"reset"
	   5	"romdl"
	   6	"dl"
	)

	enum	ipxelapFrameTypeE (
	   0	"typeEther802-3"
	   1	"typeEthernet2"
	   2	"typeEtherSNAP"
	   3	"typeAutosense"
	)

	enum	ipxRouteNetBIOSE (
	   0	"unidirectional"
	   1	"bidirectional"
	)

	enum	mportIdleStatusE (
	   0	"disabled"
	   1	"enabled"
	)

	enum	mportStatusE (
	   0	"idle"
	   1	"dialout"
	   2	"routing"
	   3	"dialin"
	   4	"arap"
	   5	"off"
	)

	enum	mportFlowControlE (
	   1	"none"
	   2	"xonxoff"
	   3	"rtscts"
	)

	enum	mportDialinIdleStatusE (
	   0	"disabled"
	   1	"enabled"
	)

	enum	modemModulationTypeE (
	   1	"bell103"
	   2	"bell212A"
	   3	"v22"
	   4	"v22bis"
	   5	"v32"
	   6	"v32bis"
	   7	"vFast"
	)

	enum	modemErrorCorrectionE (
	   1	"none"
	   2	"lapM"
	   3	"mnp"
	)

	enum	modemDataCompressionE (
	   1	"none"
	   2	"btlz"
	   3	"mnp5"
	)

	enum	tRTMPZeroCountersE (
	   1	"zero"
	)

	enum	tZIPZeroCountersE (
	   1	"zero"
	)

	enum	tAARPClearCacheE (
	   1	"clear"
	)

	enum	tKIPRoutesValidE (
	   1	"valid"
	   2	"invalid"
	)

	enum	tATRoutingModeE (
	   1	"conformingRouter"
	   2	"seedRouter"
	   3	"endNode"
	   4	"other"
	)

	enum	tATDialinPacketDeliveryModeE (
	   1	"routing"
	   2	"endNodeForwarding"
	   3	"other"
	)

	enum	tARPClearCacheE (
	   1	"clear"
	)

	enum	tIPClearRedirectsE (
	   1	"clear"
	)

	enum	tUDPChecksumsE (
	   1	"enabled"
	   2	"disabled"
	)

	enum	tIPBroadCastFillE (
	   1	"ones"
	   2	"zeroes"
	)

	enum	tAcceptAnyClientAddrE (
	   1	"enabled"
	   2	"disabled"
	)

	enum	tUseConfiguredUserAddrE (
	   1	"enabled"
	   2	"disabled"
	)

	enum	tUseConfiguredPortAddrE (
	   2	"disabled"
	)

	enum	tUseDHCPAddrE (
	   1	"enabled"
	   2	"disabled"
	)

	enum	tUsePoolAddrE (
	   1	"enabled"
	   2	"disabled"
	)

	enum	tCommunityTrapHostTypeE (
	   1	"unconfigured"
	   2	"ip"
	   3	"ipx"
	   4	"netbios"
	)

	enum	tCommunitySetHostTypeE (
	   1	"unconfigured"
	   2	"ip"
	   3	"ipx"
	   4	"netbios"
	   6	"ddprange"
	)

	enum	tCommunityAccessE (
	   1	"no-access"
	   2	"read-only-access"
	   3	"clear-statistics"
	   4	"configure"
	)

	enum	ipxRouteTypeE (
	   1	"other"
	   2	"invalid"
	   3	"direct"
	   4	"indirect"
	)

	enum	ipxRouteProtoE (
	   1	"other"
	   2	"rip"
	)

	enum	sapTypeE (
	   4	"novellFileServer"
	   35	"novellNacs"
	   71	"novellAdvPrintServer"
	   263	"novellRemCons"
	   459	"shivaNetModem"
	   460	"shivaLanRoverE"
	   461	"shivaLanRoverT"
	)

	enum	nwifTypeE (
	   1	"other"
	   2	"ieee8023"
	   3	"ethernet2"
	   4	"snap"
	   5	"ieee8022"
	   6	"dialin"
	   7	"ppp"
	   8	"rfc1234"
	   9	"lantolan"
	)

	enum	nwifStatusE (
	   1	"disabled"
	   2	"unlocked"
	   3	"locked"
	   4	"unconfigured"
	   5	"learned"
	   6	"guessed"
	)

	enum	nwifHomeE (
	   1	"home"
	   2	"notHome"
	)

	enum	nwifNBForwardE (
	   1	"enabled"
	   2	"disabled"
	)

	enum	nwmgmtTypeE (
	   459	"shivaNetModem"
	   460	"shivaLanRoverE"
	   461	"shivaLanRoverT"
	   1388	"shivaLanRoverEPLUS"
	   1389	"shivaLanRoverTPLUS"
	)

	enum	tNBPFilterConfigE (
	   1	"unconfigured"
	   2	"configured"
	   3	"reinitialize"
	)

	enum	tZoneFilterConfigE (
	   1	"unconfigured"
	   2	"configured"
	   3	"reinitialize"
	)

	enum	tpppPortStatusE (
	   1	"disabled"
	   2	"enabled"
	)


## Group and Table Declarations

	group	messageLog
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	mLogEntryCount
		description 	"The number of entries currently in the message log buffer."
		characteristics "-N mLogEntryCount -O 1.3.6.1.4.1.166.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readwrite enum mLogNewMessageTrapEnableE	mLogNewMessageTrapEnable
		description 	"Enables or disables the generation of mLogNewMessage Traps
		 of a priority numerically equal or lower than the value of
		 this variable."
		characteristics "-N mLogNewMessageTrapEnable -O 1.3.6.1.4.1.166.1.1.2 -T INTEGER -A RW -X equal -F 0"

	)

	table	mLogBuffer
	description "A list of message log entries."
	characteristics "-K ONE"
	(
		readonly timeticks	mLogTimeStamp
		description 	"The time the message was generated, measured in number of
		ticks since the device started."
		characteristics "-N mLogTimeStamp -O 1.3.6.1.4.1.166.1.1.3.1.1 -T TIMETICKS -A RO -X equal -F 0"

		readonly enum mLogPriorityE	mLogPriority
		description 	"The priority of the log message.
		This field is for future use. All messages are
		currently logged at priority 'notice'"
		characteristics "-N mLogPriority -O 1.3.6.1.4.1.166.1.1.3.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	mLogMessageText
		description 	"The text of the log message."
		characteristics "-N mLogMessageText -O 1.3.6.1.4.1.166.1.1.3.1.3 -T STRING -A RO -X equal -F 0"

		readonly int	mLogTimeOfDay
		description 	"The time of day at which the message is logged.  This is
		expressed in seconds."
		characteristics "-N mLogTimeOfDay -O 1.3.6.1.4.1.166.1.1.3.1.4 -T INTEGER -A RO -X equal -F 0"

	)

	table	sccTable
	description "Each row of this table describes a (Zilog) 8530
		Serial Communications Controller used for LocalTalk."
	characteristics "-K ONE"
	(
		readonly counter	sccInterrupts
		description 	"Number of receive interrupts generated by the SCC."
		characteristics "-N sccInterrupts -O 1.3.6.1.4.1.166.1.2.1.1.1 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sccAborts
		description 	"The number of abort interrupts generated by the SCC."
		characteristics "-N sccAborts -O 1.3.6.1.4.1.166.1.2.1.1.2 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sccSpuriousInts
		description 	"The number of spurious interrupts generated by the SCC."
		characteristics "-N sccSpuriousInts -O 1.3.6.1.4.1.166.1.2.1.1.3 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sccDeferTimeouts
		description 	"Total number of defer timeouts.  A defer timeout is the
		condition in which the line did not become idle for one
		and a half packet times, while the SCC was waiting to
		transmit, forcing a reset of the receiver.  This event
		could indicate a misbehaving localtalk device."
		characteristics "-N sccDeferTimeouts -O 1.3.6.1.4.1.166.1.2.1.1.4 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sccOverruns
		description 	"Total receive overruns."
		characteristics "-N sccOverruns -O 1.3.6.1.4.1.166.1.2.1.1.5 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sccUnderruns
		description 	"Total receive underruns."
		characteristics "-N sccUnderruns -O 1.3.6.1.4.1.166.1.2.1.1.6 -T COUNTER -A RO -X equal -F 0"

	)

	group	sam
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	samProtocols
		description 	"This device's supported protocol stacks.  The integer
		is constructed by setting the bits as follows, where
		bit 0 is least significant:

			0	- AppleTalk
			1	- IP
			2	- IPX
			3	- NetBEUI
			4	- reserved
			5	- reserved
			6	- reserved
			7	- reserved
			8	- reserved
			9	- reserved
			10	- reserved
			11	- reserved
			12	- reserved
			13	- reserved
			14	- reserved
			15	- reserved"
		characteristics "-N samProtocols -O 1.3.6.1.4.1.166.1.3.5 -T INTEGER -A RO -X equal -F 0"

		readonly int	samFunctions
		description 	"This device's capabilities.  The integer is
		constructed by setting the bits as follows, where bit
		0 is least significant:
			0	- Dial-in Network Access Server
			1	- Serial Sharing Server
			2	- Half-router
			3	- reserved
			4	- reserved
			5	- reserved
			6	- reserved
			7	- reserved
			8	- reserved
			9	- reserved
			10	- reserved
			11	- reserved
			12	- reserved
			13	- reserved
			14	- reserved
			15	- reserved"
		characteristics "-N samFunctions -O 1.3.6.1.4.1.166.1.3.6 -T INTEGER -A RO -X equal -F 0"

		readonly int	samUpTime
		description 	"The number of TimeTicks since this device last restarted."
		characteristics "-N samUpTime -O 1.3.6.1.4.1.166.1.3.7 -T INTEGER -A RO -X equal -F 0"

	)

	group	samControl
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum samGlobalDeviceModeE	samGlobalDeviceMode
		description 	"The global state of device.  This allows for
		determination of and setting of which mode the device
		is in.  romDownloader mode means the device is running
		in its ROM kernel, and is awaiting download,
		ramDownloader mode means the device is running a
		similar kernel from RAM and downloadedImage mode means
		the device is running its normal software.  Writing
		this object causes the device to reboot in the
		specified state.  Because downloader software doesn't
		contain SNMP, this variable should never read as
		anything other than downloadedImage.  All values are
		valid for write."
		characteristics "-N samGlobalDeviceMode -O 1.3.6.1.4.1.166.1.3.1.1 -T INTEGER -A RW -X equal -F 0"

	)

	group	samVersion
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	imageVersion
		description 	"The version of the downloaded image."
		characteristics "-N imageVersion -O 1.3.6.1.4.1.166.1.3.2.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	downloadVersion
		description 	"The version of the downloader."
		characteristics "-N downloadVersion -O 1.3.6.1.4.1.166.1.3.2.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	hardwareVersion
		description 	"Sequential ID of hardware version."
		characteristics "-N hardwareVersion -O 1.3.6.1.4.1.166.1.3.2.3 -T INTEGER -A RO -X equal -F 0"

	)

	group	samMemory
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	ramSize
		description 	"The amount of onboard RAM the device has."
		characteristics "-N ramSize -O 1.3.6.1.4.1.166.1.3.3.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	freeRAM
		description 	"The amount of RAM the device has free at this moment."
		characteristics "-N freeRAM -O 1.3.6.1.4.1.166.1.3.3.2 -T INTEGER -A RO -X equal -F 0"

	)

	group	samTime
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite int	samSeconds
		description 	"This device's notion of the time, represented as the number
		 of seconds elapsed since Midnight on January 1st, 1970 GMT."
		characteristics "-N samSeconds -O 1.3.6.1.4.1.166.1.3.4.1 -T INTEGER -A RW -X equal -F 0"

		readwrite int	samTimezone
		description 	"The timezone in which the device is located,
		represented as an offset from GMT in seconds."
		characteristics "-N samTimezone -O 1.3.6.1.4.1.166.1.3.4.2 -T INTEGER -A RW -X equal -F 0"

	)

	group	users
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite int	userAdminPermissions
		description 	"Master permissions bit mask
			Bit 0 - Enable dial-in access for the device
			Bit 1 - Enable dial-out access for device
			Bit 2 - Enable remote routing for the device."
		characteristics "-N userAdminPermissions -O 1.3.6.1.4.1.166.1.5.2 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	masterPassword
		description 	"Encrypted device master password."
		characteristics "-N masterPassword -O 1.3.6.1.4.1.166.1.5.3 -T STRING -A RW -X equal -F 0"

		readwrite int	binderyEnable
		description 	"Enables use of bindery server for security."
		characteristics "-N binderyEnable -O 1.3.6.1.4.1.166.1.5.4 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	binderyServer
		description 	"Name of Bindery server (default server in LanRover 2.0)"
		characteristics "-N binderyServer -O 1.3.6.1.4.1.166.1.5.5 -T STRING -A RW -X equal -F 0"

		readwrite enum defaultSecurityTypeE	defaultSecurityType
		description 	"Default authentication server type."
		characteristics "-N defaultSecurityType -O 1.3.6.1.4.1.166.1.5.6 -T INTEGER -A RW -X equal -F 0"

		readwrite enum defaultServerOnlyE	defaultServerOnly
		description 	"If true prohibit users from specifying which
		server to use for authentication."
		characteristics "-N defaultServerOnly -O 1.3.6.1.4.1.166.1.5.7 -T INTEGER -A RW -X equal -F 0"

		readwrite enum clearLocalUsersE	clearLocalUsers
		description 	"Setting this variable to clear removes all users
		from the local user list."
		characteristics "-N clearLocalUsers -O 1.3.6.1.4.1.166.1.5.8 -T INTEGER -A RW -X equal -F 0"

		readonly int	userCount
		description 	"Total number of users in the local user list."
		characteristics "-N userCount -O 1.3.6.1.4.1.166.1.5.9 -T INTEGER -A RO -X equal -F 0"

		readwrite int	userListModificationTime
		description 	"The date and time the local user list was last
		modified, represented as the number of seconds
		elapsed since Midnight on January 1st, 1970 GMT."
		characteristics "-N userListModificationTime -O 1.3.6.1.4.1.166.1.5.10 -T INTEGER -A RW -X equal -F 0"

	)

	table	userTable
	description "Table of users."
	characteristics "-K ???"
	(
		readwrite octet[128]	username
		description 	"User name."
		characteristics "-N username -O 1.3.6.1.4.1.166.1.5.1.1.1 -T STRING -A RW -X equal -F 0"

		readwrite octet[128]	password
		description 	"Encrypted user password."
		characteristics "-N password -O 1.3.6.1.4.1.166.1.5.1.1.2 -T STRING -A RW -X equal -F 0"

		readwrite int	permissions
		description 	"Permissions bit mask:
			Bit 0 - Enable dial-in access for this user
			Bit 1 - Enable dial-out access for this user
			Bit 2 - Enable user to initiate remote routing
			Bit 4 - Allow user to dial-in without dialback."
		characteristics "-N permissions -O 1.3.6.1.4.1.166.1.5.1.1.3 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	dialback
		description 	"A phone number for chargeback."
		characteristics "-N dialback -O 1.3.6.1.4.1.166.1.5.1.1.4 -T STRING -A RW -X equal -F 0"

	)

	group	log
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	logCount
		description 	"The number of entries currently in the message log buffer."
		characteristics "-N logCount -O 1.3.6.1.4.1.166.1.6.1 -T INTEGER -A RO -X equal -F 0"

		readwrite enum logTrapPriorityE	logTrapPriority
		description 	"Enables or disables the generation of logNewMessage Traps
		 of a priority numerically equal or lower than the value of
		 this variable."
		characteristics "-N logTrapPriority -O 1.3.6.1.4.1.166.1.6.2 -T INTEGER -A RW -X equal -F 0"

		readwrite enum logSavePriorityE	logSavePriority
		description 	"This variable indicates the lowest (numerically
		highest) priority message (as indicated by
		logBufferPriority) which will be save in the
		logBufferTable."
		characteristics "-N logSavePriority -O 1.3.6.1.4.1.166.1.6.4 -T INTEGER -A RW -X equal -F 0"

		readwrite enum logClearE	logClear
		description 	"Indicates whether the log buffer is non-empty.
		Clears the log buffer when written with clear(2)."
		characteristics "-N logClear -O 1.3.6.1.4.1.166.1.6.5 -T INTEGER -A RW -X equal -F 0"

	)

	table	logBufferTable
	description "A list of message log entries."
	characteristics "-K ONE"
	(
		readonly int	logBufferSequence
		description 	"Ordinal position in the Log Buffer."
		characteristics "-N logBufferSequence -O 1.3.6.1.4.1.166.1.6.3.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly enum logBufferPriorityE	logBufferPriority
		description 	"The priority of the log message."
		characteristics "-N logBufferPriority -O 1.3.6.1.4.1.166.1.6.3.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly enum logBufferFacilityE	logBufferFacility
		description 	"The Facility which generated the log message."
		characteristics "-N logBufferFacility -O 1.3.6.1.4.1.166.1.6.3.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	logBufferTimeOfDay
		description 	"The time of day at which the message is logged.  This is
		expressed in seconds."
		characteristics "-N logBufferTimeOfDay -O 1.3.6.1.4.1.166.1.6.3.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly timeticks	logBufferTimeStamp
		description 	"The time the message was generated, measured in number of
		ticks since the device started."
		characteristics "-N logBufferTimeStamp -O 1.3.6.1.4.1.166.1.6.3.1.5 -T TIMETICKS -A RO -X equal -F 0"

		readonly string[128]	logBufferText
		description 	"The text of the log message."
		characteristics "-N logBufferText -O 1.3.6.1.4.1.166.1.6.3.1.6 -T STRING -A RO -X equal -F 0"

		readonly string[128]	logBufferPort
		description 	"The Serial Port associated the log message.
		Only valid when logBufferFacility is audit(13)."
		characteristics "-N logBufferPort -O 1.3.6.1.4.1.166.1.6.3.1.7 -T STRING -A RO -X equal -F 0"

		readonly string[128]	logBufferUser
		description 	"The User associated the log message.
		Only valid when logBufferFacility is audit(13)."
		characteristics "-N logBufferUser -O 1.3.6.1.4.1.166.1.6.3.1.8 -T STRING -A RO -X equal -F 0"

	)

	group	version
	description "(null)"
	characteristics "-K NONE"
	(
		readonly octet[128]	vImage
		description 	"The version number of the image represented
		as seperate octets. For example version 2.0.1
		would be 02 00 01. XXX talk about 4th and 5th octets!!"
		characteristics "-N vImage -O 1.3.6.1.4.1.166.1.7.1 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	vPROM
		description 	"The version number of the PROM or VROM."
		characteristics "-N vPROM -O 1.3.6.1.4.1.166.1.7.2 -T STRING -A RO -X equal -F 0"

		readonly enum vHardwareE	vHardware
		description 	"The h/w platform ID"
		characteristics "-N vHardware -O 1.3.6.1.4.1.166.1.7.3 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	vSoftwareArch
		description 	"The name of the software architecture provided
		by the PROM or VROM"
		characteristics "-N vSoftwareArch -O 1.3.6.1.4.1.166.1.7.4 -T STRING -A RO -X equal -F 0"

		readonly int	vHardwareRev
		description 	"The h/w platform revision register"
		characteristics "-N vHardwareRev -O 1.3.6.1.4.1.166.1.7.5 -T INTEGER -A RO -X equal -F 0"

	)

	group	memory
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	memoryTotal
		description 	"Total number of bytes of RAM installed."
		characteristics "-N memoryTotal -O 1.3.6.1.4.1.166.1.8.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryFree
		description 	"Total number of bytes of memory on the 'malloc'
		free list."
		characteristics "-N memoryFree -O 1.3.6.1.4.1.166.1.8.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryMalloc
		description 	"Total number of bytes of memory in use
		by malloc."
		characteristics "-N memoryMalloc -O 1.3.6.1.4.1.166.1.8.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryUnused
		description 	"Total number of bytes of memory not in use
		(available for either malloc or config)."
		characteristics "-N memoryUnused -O 1.3.6.1.4.1.166.1.8.4 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryConf
		description 	"Total number of bytes of memory currently
		allocated for use by configuration."
		characteristics "-N memoryConf -O 1.3.6.1.4.1.166.1.8.5 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryConfFree
		description 	"Total number of bytes of memory allocated for
		configuration, but not in use."
		characteristics "-N memoryConfFree -O 1.3.6.1.4.1.166.1.8.6 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryImageCode
		description 	"Total number of bytes of code in the system image."
		characteristics "-N memoryImageCode -O 1.3.6.1.4.1.166.1.8.7 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryImageInitialized
		description 	"Total number of bytes of initialized data in the
		system image."
		characteristics "-N memoryImageInitialized -O 1.3.6.1.4.1.166.1.8.8 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryImageUninitialized
		description 	"Total number of bytes of uninitialized data in the
		system image."
		characteristics "-N memoryImageUninitialized -O 1.3.6.1.4.1.166.1.8.9 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryVromCode
		description 	"Total number of bytes of code in the VROM."
		characteristics "-N memoryVromCode -O 1.3.6.1.4.1.166.1.8.10 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryVromProtected
		description 	"Total number of bytes of non-volatile data in the
		VROM."
		characteristics "-N memoryVromProtected -O 1.3.6.1.4.1.166.1.8.11 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryVromInitialized
		description 	"Total number of bytes of initialized data in the
		VROM."
		characteristics "-N memoryVromInitialized -O 1.3.6.1.4.1.166.1.8.12 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryVromUninitialized
		description 	"Total number of bytes of uninitialized data in the
		VROM."
		characteristics "-N memoryVromUninitialized -O 1.3.6.1.4.1.166.1.8.13 -T INTEGER -A RO -X equal -F 0"

		readonly int	memoryUsers
		description 	"Total number of bytes of memory currently
		allocated for use by user list."
		characteristics "-N memoryUsers -O 1.3.6.1.4.1.166.1.8.14 -T INTEGER -A RO -X equal -F 0"

	)

	group	time
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite int	timeRTC
		description 	"The date and time, as kept by the device's Real
		Time Clock hardware, represented as the number of
		seconds elapsed since Midnight on January 1st, 1970
		GMT.  This value may be zero if the device has no
		RTC, or the RTC is halted."
		characteristics "-N timeRTC -O 1.3.6.1.4.1.166.1.9.1 -T INTEGER -A RW -X equal -F 0"

		readwrite int	timeZone
		description 	"The timezone in which the device is located,
		represented as an offset from GMT in seconds."
		characteristics "-N timeZone -O 1.3.6.1.4.1.166.1.9.2 -T INTEGER -A RW -X equal -F 0"

		readwrite int	timeOfDay
		description 	"This device's notion of the date and time,
		represented as the number of seconds elapsed since
		Midnight on January 1st, 1970 GMT.  This may differ
		from timeRTC if the device is using an external time
		server."
		characteristics "-N timeOfDay -O 1.3.6.1.4.1.166.1.9.3 -T INTEGER -A RW -X equal -F 0"

	)

	group	features
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	featureMgmtImage
		description 	"This integer is a bit mask which represent various
		network management/configuration protocols supported
		by the system image;
			0x00000001 - SNMP over UDP
			0x00000002 - BOOTP/TFTP
			0x00000004 - RARP/TFTP
			0x00000008 - SFTP over TCP
			0x00000010 - FTP over TCP
			0x00000020 - KLAP3 over UDP
			0x00000040 - SNMP over IPX
			0x00000080 - SFTP over SPX
			0x00000100 - BAP over IPX."
		characteristics "-N featureMgmtImage -O 1.3.6.1.4.1.166.1.10.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	featureWanImage
		description 	"This integer is a bit mask which represent various
		wide area network options supported by the system image;
			0x00000001 - PPP over Async HDLC
			0x00000002 - SLIP
			0x00000004 - PPP IPCP
			0x00000008 - PPP IPXCP
			0x00000010 - PPP Shiva IPXCP
			0x00000020 - PPP over Async Frame Relay
			0x00000040 - PPP Shiva NBCP
			0x00000080 - PPP Bridging CP
			0x00000100 - PPP ATCP
			0x00000200 - AALAP."
		characteristics "-N featureWanImage -O 1.3.6.1.4.1.166.1.10.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	featureMgmtVrom
		description 	"Network management/configuration protocols supported
		by the VROM downloader. (see featureMgmtImage for bits)."
		characteristics "-N featureMgmtVrom -O 1.3.6.1.4.1.166.1.10.4 -T INTEGER -A RO -X equal -F 0"

		readonly int	featureWanVrom
		description 	"This integer is a bit mask which represent various
		wide area network options supported by the VROM downloader.
		(see featureWanImage for bits)."
		characteristics "-N featureWanVrom -O 1.3.6.1.4.1.166.1.10.5 -T INTEGER -A RO -X equal -F 0"

	)

	table	featureTable
	description "Table of software features present and enabled."
	characteristics "-K ONE"
	(
		readonly enum featureProtocolE	featureProtocol
		description 	"The layer or protocol for which features are represented."
		characteristics "-N featureProtocol -O 1.3.6.1.4.1.166.1.10.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readwrite enum featureDialInE	featureDialIn
		description 	"Indicates what dial-in functions (if any) are present
		and enabled for the indicated layer or protocol family."
		characteristics "-N featureDialIn -O 1.3.6.1.4.1.166.1.10.1.1.2 -T INTEGER -A RW -X equal -F 0"

		readwrite enum featureDialOutE	featureDialOut
		description 	"Indicates what dial-out functions (if any) are present
		and enabled for the indicated layer or protocol family."
		characteristics "-N featureDialOut -O 1.3.6.1.4.1.166.1.10.1.1.3 -T INTEGER -A RW -X equal -F 0"

		readwrite enum featureShellE	featureShell
		description 	"Indicates if the Shell is present and enabled for us
		from the indicated layer or protocol family."
		characteristics "-N featureShell -O 1.3.6.1.4.1.166.1.10.1.1.4 -T INTEGER -A RW -X equal -F 0"

		readwrite enum featureLanToLanOrigE	featureLanToLanOrig
		description 	"Indicates what LAN-to-LAN origination functions (if any)
		are present and enabled for the indicated layer or protocol
		family."
		characteristics "-N featureLanToLanOrig -O 1.3.6.1.4.1.166.1.10.1.1.5 -T INTEGER -A RW -X equal -F 0"

		readwrite enum featureLanToLanAnsE	featureLanToLanAns
		description 	"Indicates what LAN-to-LAN answer functions (if any)
		are present and enabled for the indicated layer or protocol
		family."
		characteristics "-N featureLanToLanAns -O 1.3.6.1.4.1.166.1.10.1.1.6 -T INTEGER -A RW -X equal -F 0"

	)

	group	config
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite octet[128]	confName
		description 	"The system name currently in use.  Used to generate
		protocol specific service advertisements (ie; SAP and
		NBP) on startup."
		characteristics "-N confName -O 1.3.6.1.4.1.166.1.11.11 -T STRING -A RW -X equal -F 0"

		readwrite enum confRemoteBootE	confRemoteBoot
		description 	"If enabled, the system will fetch a new configuration
		and download on power-up or other cold restart."
		characteristics "-N confRemoteBoot -O 1.3.6.1.4.1.166.1.11.12 -T INTEGER -A RW -X equal -F 0"

		readwrite int	confDialInTimeout
		description 	"Default dial-in idle limit currently in use."
		characteristics "-N confDialInTimeout -O 1.3.6.1.4.1.166.1.11.13 -T INTEGER -A RW -X equal -F 0"

		readwrite int	confDialOutTimeout
		description 	"Dial-out idle limit currently in use."
		characteristics "-N confDialOutTimeout -O 1.3.6.1.4.1.166.1.11.14 -T INTEGER -A RW -X equal -F 0"

		readwrite int	confShellTimeout
		description 	"Shell idle limit currently in use."
		characteristics "-N confShellTimeout -O 1.3.6.1.4.1.166.1.11.15 -T INTEGER -A RW -X equal -F 0"

		readwrite enum confClearE	confClear
		description 	"When set to clear, discards the current config file."
		characteristics "-N confClear -O 1.3.6.1.4.1.166.1.11.16 -T INTEGER -A RW -X equal -F 0"

		readwrite int	confLanToLanTimeout
		description 	"Default LAN-to-LAN idle limit currently in use."
		characteristics "-N confLanToLanTimeout -O 1.3.6.1.4.1.166.1.11.17 -T INTEGER -A RW -X equal -F 0"

		readwrite int	confModificationTime
		description 	"The date and time the configuration was last
		modified, represented as the number of seconds
		elapsed since Midnight on January 1st, 1970 GMT."
		characteristics "-N confModificationTime -O 1.3.6.1.4.1.166.1.11.18 -T INTEGER -A RW -X equal -F 0"

	)

	group	serial
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	numSerialSlots
		description 	"Number of serial slots."
		characteristics "-N numSerialSlots -O 1.3.6.1.4.1.166.1.12.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	numSerialCards
		description 	"Number of serial cards."
		characteristics "-N numSerialCards -O 1.3.6.1.4.1.166.1.12.4 -T INTEGER -A RO -X equal -F 0"

	)

	table	serialPortTable
	description "Table of serial port initialization parameters and status."
	characteristics "-K ONE"
	(
		readonly int	serialPortIndex
		description 	"Serial port number which corresponds to an
		instance of rs232PortIndex."
		characteristics "-N serialPortIndex -O 1.3.6.1.4.1.166.1.12.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	serialPortName
		description 	"The name of this port, as used to retrieve configuration."
		characteristics "-N serialPortName -O 1.3.6.1.4.1.166.1.12.1.1.2 -T STRING -A RO -X equal -F 0"

		readwrite enum serialPortStatusE	serialPortStatus
		description 	"Serial port status.  Setting serialPortStatus
		to initializing(2) forces the port to be reinitialized."
		characteristics "-N serialPortStatus -O 1.3.6.1.4.1.166.1.12.1.1.3 -T INTEGER -A RW -X equal -F 0"

		readwrite string[128]	serialPortModemName
		description 	"The name of the type of modem connected to this port."
		characteristics "-N serialPortModemName -O 1.3.6.1.4.1.166.1.12.1.1.4 -T STRING -A RW -X equal -F 0"

		readwrite string[128]	serialPortAnswerInit
		description 	"The initialization string to put the modem in auto-answer
		mode."
		characteristics "-N serialPortAnswerInit -O 1.3.6.1.4.1.166.1.12.1.1.5 -T STRING -A RW -X equal -F 0"

		readwrite int	serialPortInitRate
		description 	"The rate in bits per second at which to initialize
		the port."
		characteristics "-N serialPortInitRate -O 1.3.6.1.4.1.166.1.12.1.1.6 -T INTEGER -A RW -X equal -F 0"

		readwrite enum serialPortInitFlowE	serialPortInitFlow
		description 	"The flow control setting to initialize the port with."
		characteristics "-N serialPortInitFlow -O 1.3.6.1.4.1.166.1.12.1.1.7 -T INTEGER -A RW -X equal -F 0"

		readonly int	serialPortSignals
		description 	"The current status of control signals on this port,
		as the sum of the following bits;
			0	Ready To Send
			1	Clear To Send
			2	Data Set Ready
			3	Data Terminal Ready
			4	Ring Indicate
			5	Data Carrier (Rcvd Line Signal) Detect
			6	Signal Quality Detect
			7	Signaling Rate Selector
			8	Secondary RTS
			9	Secondary CTS
			10	Secondary DCD."
		characteristics "-N serialPortSignals -O 1.3.6.1.4.1.166.1.12.1.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialPortModemTypeE	serialPortModemType
		description 	"Serial port modem type."
		characteristics "-N serialPortModemType -O 1.3.6.1.4.1.166.1.12.1.1.9 -T INTEGER -A RO -X equal -F 0"

		readwrite string[128]	serialPortInitString
		description 	"The initialization string to put the modem in dial
		mode."
		characteristics "-N serialPortInitString -O 1.3.6.1.4.1.166.1.12.1.1.10 -T STRING -A RW -X equal -F 0"

	)

	table	groupTable
	description "A table of serial port group names."
	characteristics "-K ONE"
	(
		readonly string[128]	groupName
		description 	"A serial port group name."
		characteristics "-N groupName -O 1.3.6.1.4.1.166.1.12.2.1.1 -T STRING -A RO -X equal -F 0"

	)

	table	sessionTable
	description "A table of current users of the box."
	characteristics "-K ONE"
	(
		readonly int	sessionLine
		description 	"The unique number identifying this session.  Formerly
		a line number, but not anymore."
		characteristics "-N sessionLine -O 1.3.6.1.4.1.166.1.14.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	sessionUser
		description 	"The name of the user associated with the session.
		This may be empty if the user has not yet authenticated."
		characteristics "-N sessionUser -O 1.3.6.1.4.1.166.1.14.1.1.2 -T STRING -A RO -X equal -F 0"

		readonly int	sessionConnect
		description 	"Session connect time in minutes."
		characteristics "-N sessionConnect -O 1.3.6.1.4.1.166.1.14.1.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessionIdle
		description 	"Session idle time in minutes."
		characteristics "-N sessionIdle -O 1.3.6.1.4.1.166.1.14.1.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	sessionLocation
		description 	"A description of the location of the session source."
		characteristics "-N sessionLocation -O 1.3.6.1.4.1.166.1.14.1.1.5 -T STRING -A RO -X equal -F 0"

		readwrite enum sessionActivityE	sessionActivity
		description 	"An indication of the current activity type."
		characteristics "-N sessionActivity -O 1.3.6.1.4.1.166.1.14.1.1.6 -T INTEGER -A RW -X equal -F 0"

		readonly string[128]	sessionDescription
		description 	"A description of the current activity."
		characteristics "-N sessionDescription -O 1.3.6.1.4.1.166.1.14.1.1.7 -T STRING -A RO -X equal -F 0"

		readonly int	sessionMaxConnect
		description 	"Session connect time limit in minutes.
		If zero, there is no limit."
		characteristics "-N sessionMaxConnect -O 1.3.6.1.4.1.166.1.14.1.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessionMaxIdle
		description 	"Session idle time limit in minutes.
		If zero, there is no limit."
		characteristics "-N sessionMaxIdle -O 1.3.6.1.4.1.166.1.14.1.1.9 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	sessionDialBackNumber
		description 	"The dialback phone number used by the connection."
		characteristics "-N sessionDialBackNumber -O 1.3.6.1.4.1.166.1.14.1.1.10 -T STRING -A RO -X equal -F 0"

		readonly netaddress	sessionIpaddr
		description 	"The IP address used by the client of the connection."
		characteristics "-N sessionIpaddr -O 1.3.6.1.4.1.166.1.14.1.1.11 -T IPADDRESS -A RO -X equal -F 0"

		readonly octet[128]	sessionIpxNet
		description 	"The IPX network number used for the connection."
		characteristics "-N sessionIpxNet -O 1.3.6.1.4.1.166.1.14.1.1.12 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	sessionIpxNode
		description 	"The IPX node number used by the client of the connection."
		characteristics "-N sessionIpxNode -O 1.3.6.1.4.1.166.1.14.1.1.13 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	sessionNetbeuiAddr
		description 	"The NetBEUI address used for bridging by the client of the
		connection."
		characteristics "-N sessionNetbeuiAddr -O 1.3.6.1.4.1.166.1.14.1.1.14 -T STRING -A RO -X equal -F 0"

		readonly string[128]	sessionConnectStr
		description 	"The modem connect string returned on the connection."
		characteristics "-N sessionConnectStr -O 1.3.6.1.4.1.166.1.14.1.1.15 -T STRING -A RO -X equal -F 0"

		readonly int	sessionProtocols
		description 	"The protocols used on the connection, represented as a
		bitmask;
			0x00000001 - PPP
			0x00000002 - IP
			0x00000004 - IPX
			0x00000008 - AppleTalk
			0x00000010 - SLIP
			0x00000020 - NetBEUI
			0x00000040 - LLC
			0x00000080 - AALAP
			0x00000100 - ARA 1.0
			0x00000200 - ARA 2.0
			0x00000400 - MacIP."
		characteristics "-N sessionProtocols -O 1.3.6.1.4.1.166.1.14.1.1.16 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessionPacketSize
		description 	"The maximum packet sized allowed on this connection."
		characteristics "-N sessionPacketSize -O 1.3.6.1.4.1.166.1.14.1.1.17 -T INTEGER -A RO -X equal -F 0"

		readonly counter	sessionOverruns
		description 	"The number of overruns seen on this connection.
		Always 0.  See sessLineAsyncOverruns."
		characteristics "-N sessionOverruns -O 1.3.6.1.4.1.166.1.14.1.1.18 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionParityErrs
		description 	"The number of parity errors seen on this connection.
		Always 0.  See sessLineAsyncParityErrs."
		characteristics "-N sessionParityErrs -O 1.3.6.1.4.1.166.1.14.1.1.19 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionFrameErrs
		description 	"The number of framing errors seen on this connection.
		Always 0.  See sessLineAsyncFrameErrs."
		characteristics "-N sessionFrameErrs -O 1.3.6.1.4.1.166.1.14.1.1.20 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionBreakErrs
		description 	"The number of break errors seen on this connection.
		Always 0.  See sessLineAsyncBreakErrs."
		characteristics "-N sessionBreakErrs -O 1.3.6.1.4.1.166.1.14.1.1.21 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionFcsErrs
		description 	"The number of checksum errors seen on this connection.
		Always 0.  See sessLineAsyncFcsErrs."
		characteristics "-N sessionFcsErrs -O 1.3.6.1.4.1.166.1.14.1.1.22 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionTooBig
		description 	"The number of too large packets seen on this connection.
		Always 0.  See sessLineAsyncTooBig."
		characteristics "-N sessionTooBig -O 1.3.6.1.4.1.166.1.14.1.1.23 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionPktAbort
		description 	"The number of packet abort indications seen on this
		connection.  Always 0.  See sessLineAsyncPktAbort."
		characteristics "-N sessionPktAbort -O 1.3.6.1.4.1.166.1.14.1.1.24 -T COUNTER -A RO -X equal -F 0"

		readonly octet[128]	sessionDdpAddress
		description 	"The DDP address used by the client of the connection."
		characteristics "-N sessionDdpAddress -O 1.3.6.1.4.1.166.1.14.1.1.25 -T STRING -A RO -X equal -F 0"

		readonly enum sessionLineModeE	sessionLineMode
		description 	"The line type on this connection."
		characteristics "-N sessionLineMode -O 1.3.6.1.4.1.166.1.14.1.1.26 -T INTEGER -A RO -X equal -F 0"

		readonly counter	sessionSynFcsErrs
		description 	"The number of FCS errors in sync mode on this connection.
		Always 0.  See sessLineSyncFcsErrs."
		characteristics "-N sessionSynFcsErrs -O 1.3.6.1.4.1.166.1.14.1.1.27 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionSynOverruns
		description 	"The number of sync receive overruns on this connection.
		Always 0.  See sessLineSyncOverruns."
		characteristics "-N sessionSynOverruns -O 1.3.6.1.4.1.166.1.14.1.1.28 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionSynUnderruns
		description 	"The number of sync transmit underruns on this connection.
		Always 0.  See sessLineSyncUnderruns."
		characteristics "-N sessionSynUnderruns -O 1.3.6.1.4.1.166.1.14.1.1.29 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionSynFrAborts
		description 	"The number of sync frame aborts on this connection.
		Always 0.  See sessLineSyncFrAborts."
		characteristics "-N sessionSynFrAborts -O 1.3.6.1.4.1.166.1.14.1.1.30 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionSynIntframes
		description 	"The number of sync interrupted frames on this connection.
		Always 0.  See sessLineSyncIntFrames."
		characteristics "-N sessionSynIntframes -O 1.3.6.1.4.1.166.1.14.1.1.31 -T COUNTER -A RO -X equal -F 0"

		readonly enum sessionPPPCompDecompE	sessionPPPCompDecomp
		description 	"The decompression protocol in use on this session."
		characteristics "-N sessionPPPCompDecomp -O 1.3.6.1.4.1.166.1.14.1.1.32 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessionPPPCompCompE	sessionPPPCompComp
		description 	"The compression protocol in use on this session."
		characteristics "-N sessionPPPCompComp -O 1.3.6.1.4.1.166.1.14.1.1.33 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessionPPPCompDecompRatio
		description 	"The average decompression ratio, multiplied by 100.
		A value of 200 indicates a 1:2 decompression ratio."
		characteristics "-N sessionPPPCompDecompRatio -O 1.3.6.1.4.1.166.1.14.1.1.34 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessionPPPCompCompRatio
		description 	"The average compression ratio, multiplied by 100.  A
		value of 200 indicates a 2:1 compression ratio."
		characteristics "-N sessionPPPCompCompRatio -O 1.3.6.1.4.1.166.1.14.1.1.35 -T INTEGER -A RO -X equal -F 0"

		readonly counter	sessionPPPCompExpandedPackets
		description 	"The number of packets that were sent in compressed
		form that were larger than they would have been
		had they not been compressed."
		characteristics "-N sessionPPPCompExpandedPackets -O 1.3.6.1.4.1.166.1.14.1.1.36 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionPPPCompExpandedOctets
		description 	"The total number of extra octets that were sent
		when packets were sent in compressed form that were
		larger than they would have been had they not been
		compressed."
		characteristics "-N sessionPPPCompExpandedOctets -O 1.3.6.1.4.1.166.1.14.1.1.37 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessionPPPCompExpandedTooBig
		description 	"The number of packets that were of a compressible
		type, but were not sent in compressed form because
		the compressed version was so large that it
		exceeded local or remote (MTU) constraints."
		characteristics "-N sessionPPPCompExpandedTooBig -O 1.3.6.1.4.1.166.1.14.1.1.38 -T COUNTER -A RO -X equal -F 0"

		readonly enum sessionPPPCompStacSendCheckE	sessionPPPCompStacSendCheck
		description 	"The type of coherency check in use for Stac LZS
		compression on transmitted packets.  If compression
		is not Stac LZS, will have value none(1)."
		characteristics "-N sessionPPPCompStacSendCheck -O 1.3.6.1.4.1.166.1.14.1.1.39 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessionPPPCompStacRecvCheckE	sessionPPPCompStacRecvCheck
		description 	"The type of coherency check in use for Stac LZS
		decompression on received packets.  If decompression
		is not Stac LZS, will have value none(1)."
		characteristics "-N sessionPPPCompStacRecvCheck -O 1.3.6.1.4.1.166.1.14.1.1.40 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessionIPAddrSrcE	sessionIPAddrSrc
		description 	"The source of the IP address for this session.
		The source is a function of configured IP address
		assignment policy.  Policy is hierarchical.  The
		source for the session is the highest source in
		the hierarchy which is enabled and provides a
		valid address."
		characteristics "-N sessionIPAddrSrc -O 1.3.6.1.4.1.166.1.14.1.1.41 -T INTEGER -A RO -X equal -F 0"

	)

	table	sessTable
	description "A table of current users of the box."
	characteristics "-K ONE"
	(
		readonly int	sessIdentifier
		description 	"The unique serial number identifying this session."
		characteristics "-N sessIdentifier -O 1.3.6.1.4.1.166.1.14.2.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessLines
		description 	"The number of physical lines in use by this session.
		This can be as low as 0, as when the session is suspended."
		characteristics "-N sessLines -O 1.3.6.1.4.1.166.1.14.2.1.2 -T INTEGER -A RO -X equal -F 0"

		readwrite enum sessStatusE	sessStatus
		description 	"Setting this to a value puts the connection in that state."
		characteristics "-N sessStatus -O 1.3.6.1.4.1.166.1.14.2.1.3 -T INTEGER -A RW -X equal -F 0"

		readonly string[128]	sessUser
		description 	"The name of the user associated with the session.
		This may be empty if the user has not yet authenticated."
		characteristics "-N sessUser -O 1.3.6.1.4.1.166.1.14.2.1.4 -T STRING -A RO -X equal -F 0"

		readonly int	sessConnect
		description 	"Session connect time in minutes."
		characteristics "-N sessConnect -O 1.3.6.1.4.1.166.1.14.2.1.5 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessIdle
		description 	"Session idle time in minutes for purposes of deciding
		whether to terminate session."
		characteristics "-N sessIdle -O 1.3.6.1.4.1.166.1.14.2.1.6 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessVirtualE	sessVirtual
		description 	"If virtual, the session is subject to suspension,
		if normal, it will never suspend."
		characteristics "-N sessVirtual -O 1.3.6.1.4.1.166.1.14.2.1.7 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessVirtualIdle
		description 	"Session idle time in seconds for purposes of deciding
		whether to suspend session."
		characteristics "-N sessVirtualIdle -O 1.3.6.1.4.1.166.1.14.2.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessMaxVirtualIdle
		description 	"Session maximum idle time limit in seconds before session
		 will be suspended.  If zero, session will never be suspended."
		characteristics "-N sessMaxVirtualIdle -O 1.3.6.1.4.1.166.1.14.2.1.9 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessSuspendedE	sessSuspended
		description 	"Indicates whether session is connected to line,
		or is suspended.  Can only be suspeneded if
		sessVirtual is virtual."
		characteristics "-N sessSuspended -O 1.3.6.1.4.1.166.1.14.2.1.10 -T INTEGER -A RO -X equal -F 0"

		readonly timeticks	sessVirtualLastChange
		description 	"The value of sysUpTime at the time the session
		last changed from connected to suspeneded, or
		vice-versa."
		characteristics "-N sessVirtualLastChange -O 1.3.6.1.4.1.166.1.14.2.1.11 -T TIMETICKS -A RO -X equal -F 0"

		readonly string[128]	sessLocation
		description 	"A description of the location of the session source."
		characteristics "-N sessLocation -O 1.3.6.1.4.1.166.1.14.2.1.12 -T STRING -A RO -X equal -F 0"

		readonly enum sessActivityE	sessActivity
		description 	"An indication of the current activity type."
		characteristics "-N sessActivity -O 1.3.6.1.4.1.166.1.14.2.1.13 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	sessDescription
		description 	"A description of the current activity."
		characteristics "-N sessDescription -O 1.3.6.1.4.1.166.1.14.2.1.14 -T STRING -A RO -X equal -F 0"

		readonly int	sessMaxConnect
		description 	"Session connect time limit in minutes.
		If zero, there is no limit."
		characteristics "-N sessMaxConnect -O 1.3.6.1.4.1.166.1.14.2.1.15 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessMaxIdle
		description 	"Session idle time limit in minutes.
		If zero, there is no limit."
		characteristics "-N sessMaxIdle -O 1.3.6.1.4.1.166.1.14.2.1.16 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessPacketSize
		description 	"The maximum packet sized allowed on this connection."
		characteristics "-N sessPacketSize -O 1.3.6.1.4.1.166.1.14.2.1.17 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessProtocols
		description 	"The protocols used on the connection, represented as a
		bitmask;
			0x00000001 - PPP
			0x00000002 - IP
			0x00000004 - IPX
			0x00000008 - AppleTalk
			0x00000010 - SLIP
			0x00000020 - NetBEUI
			0x00000040 - LLC
			0x00000080 - AALAP
			0x00000100 - ARA 1.0
			0x00000200 - ARA 2.0
			0x00000400 - MacIP."
		characteristics "-N sessProtocols -O 1.3.6.1.4.1.166.1.14.2.1.18 -T INTEGER -A RO -X equal -F 0"

		readonly netaddress	sessIpaddr
		description 	"The IP address used by the client of the connection."
		characteristics "-N sessIpaddr -O 1.3.6.1.4.1.166.1.14.2.1.19 -T IPADDRESS -A RO -X equal -F 0"

		readonly enum sessIPAddrSrcE	sessIPAddrSrc
		description 	"The source of the IP address for this session.
		The source is a function of configured IP address
		assignment policy.  Policy is hierarchical.  The
		source for the session is the highest source in
		the hierarchy which is enabled and provides a
		valid address.

		The former portcfg(4) value has been deprecated,
		addresses are not configured on a port basis as of 4.0."
		characteristics "-N sessIPAddrSrc -O 1.3.6.1.4.1.166.1.14.2.1.20 -T INTEGER -A RO -X equal -F 0"

		readonly octet[128]	sessIpxNet
		description 	"The IPX network number used for the connection."
		characteristics "-N sessIpxNet -O 1.3.6.1.4.1.166.1.14.2.1.21 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	sessIpxNode
		description 	"The IPX node number used by the client of the connection."
		characteristics "-N sessIpxNode -O 1.3.6.1.4.1.166.1.14.2.1.22 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	sessDdpAddress
		description 	"The DDP address used by the client of the connection."
		characteristics "-N sessDdpAddress -O 1.3.6.1.4.1.166.1.14.2.1.23 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	sessNetbeuiAddr
		description 	"The NetBEUI address used for bridging by the client of the
		connection."
		characteristics "-N sessNetbeuiAddr -O 1.3.6.1.4.1.166.1.14.2.1.24 -T STRING -A RO -X equal -F 0"

		readonly enum sessPPPCompDecompE	sessPPPCompDecomp
		description 	"The decompression protocol in use on this session."
		characteristics "-N sessPPPCompDecomp -O 1.3.6.1.4.1.166.1.14.2.1.25 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessPPPCompCompE	sessPPPCompComp
		description 	"The compression protocol in use on this session."
		characteristics "-N sessPPPCompComp -O 1.3.6.1.4.1.166.1.14.2.1.26 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessPPPCompDecompRatio
		description 	"The average decompression ratio, multiplied by 100.
		A value of 200 indicates a 1:2 decompression ratio."
		characteristics "-N sessPPPCompDecompRatio -O 1.3.6.1.4.1.166.1.14.2.1.27 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessPPPCompCompRatio
		description 	"The average compression ratio, multiplied by 100.  A
		value of 200 indicates a 2:1 compression ratio."
		characteristics "-N sessPPPCompCompRatio -O 1.3.6.1.4.1.166.1.14.2.1.28 -T INTEGER -A RO -X equal -F 0"

		readonly counter	sessPPPCompExpandedPackets
		description 	"The number of packets that were sent in compressed
		form that were larger than they would have been
		had they not been compressed.  Always 0, since this
		is never done."
		characteristics "-N sessPPPCompExpandedPackets -O 1.3.6.1.4.1.166.1.14.2.1.29 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessPPPCompExpandedOctets
		description 	"The total number of extra octets that were sent
		when packets were sent in compressed form that were
		larger than they would have been had they not been
		compressed.  Always 0, since this is never done."
		characteristics "-N sessPPPCompExpandedOctets -O 1.3.6.1.4.1.166.1.14.2.1.30 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessPPPCompExpandedTooBig
		description 	"The number of packets that were of a compressible
		type, but were not sent in compressed form because
		the compressed version was so large that it
		exceeded local or remote (MTU) constraints.
		Happens when the overhead of the compression
		header is too much more."
		characteristics "-N sessPPPCompExpandedTooBig -O 1.3.6.1.4.1.166.1.14.2.1.31 -T COUNTER -A RO -X equal -F 0"

		readonly enum sessPPPCompStacSendCheckE	sessPPPCompStacSendCheck
		description 	"The type of coherency check in use for Stac LZS
		compression on transmitted packets.  If compression
		is not Stac LZS, will have value none(1)."
		characteristics "-N sessPPPCompStacSendCheck -O 1.3.6.1.4.1.166.1.14.2.1.32 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessPPPCompStacRecvCheckE	sessPPPCompStacRecvCheck
		description 	"The type of coherency check in use for Stac LZS
		decompression on received packets.  If decompression
		is not Stac LZS, will have value none(1)."
		characteristics "-N sessPPPCompStacRecvCheck -O 1.3.6.1.4.1.166.1.14.2.1.33 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessTotalConnect
		description 	"Session total connect time in minutes.  Time is not
		counted when a Virtual Connection is suspended."
		characteristics "-N sessTotalConnect -O 1.3.6.1.4.1.166.1.14.2.1.34 -T INTEGER -A RO -X equal -F 0"

		readonly counter	sessPPPCompSentUncompressed
		description 	"The number of packets that were sent in uncompressed
		so as not to cause the data to expand on the wire."
		characteristics "-N sessPPPCompSentUncompressed -O 1.3.6.1.4.1.166.1.14.2.1.35 -T COUNTER -A RO -X equal -F 0"

	)

	table	sessLineTable
	description "A table of current active lines of the box."
	characteristics "-K ONE"
	(
		readonly int	sessLineLine
		description 	"Line number on which a session exists.  May not be
		only line in session."
		characteristics "-N sessLineLine -O 1.3.6.1.4.1.166.1.14.3.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessLineSession
		description 	"The value of sessIdentifier for the session using this
		line."
		characteristics "-N sessLineSession -O 1.3.6.1.4.1.166.1.14.3.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	sessLineDialBackNumber
		description 	"The dialback phone number used by the connection."
		characteristics "-N sessLineDialBackNumber -O 1.3.6.1.4.1.166.1.14.3.1.3 -T STRING -A RO -X equal -F 0"

		readonly int	sessLinePacketSize
		description 	"The maximum packet sized allowed on this line."
		characteristics "-N sessLinePacketSize -O 1.3.6.1.4.1.166.1.14.3.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessLineLineModeE	sessLineLineMode
		description 	"The line type on this connection."
		characteristics "-N sessLineLineMode -O 1.3.6.1.4.1.166.1.14.3.1.5 -T INTEGER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncOverruns
		description 	"The number of overruns seen on this connection."
		characteristics "-N sessLineAsyncOverruns -O 1.3.6.1.4.1.166.1.14.3.1.6 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncParityErrs
		description 	"The number of async parity errors seen on this connection."
		characteristics "-N sessLineAsyncParityErrs -O 1.3.6.1.4.1.166.1.14.3.1.7 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncFrameErrs
		description 	"The number of async framing errors seen on this connection."
		characteristics "-N sessLineAsyncFrameErrs -O 1.3.6.1.4.1.166.1.14.3.1.8 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncBreakErrs
		description 	"The number of async break errors seen on this connection."
		characteristics "-N sessLineAsyncBreakErrs -O 1.3.6.1.4.1.166.1.14.3.1.9 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncFcsErrs
		description 	"The number of async checksum errors seen on this connection."
		characteristics "-N sessLineAsyncFcsErrs -O 1.3.6.1.4.1.166.1.14.3.1.10 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncTooBig
		description 	"The number of async too large packets seen on this
		connection."
		characteristics "-N sessLineAsyncTooBig -O 1.3.6.1.4.1.166.1.14.3.1.11 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineAsyncPktAbort
		description 	"The number of async packet abort indications seen on this
		connection."
		characteristics "-N sessLineAsyncPktAbort -O 1.3.6.1.4.1.166.1.14.3.1.12 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineSyncFcsErrs
		description 	"The number of sync FCS errors in sync mode on this
		connection."
		characteristics "-N sessLineSyncFcsErrs -O 1.3.6.1.4.1.166.1.14.3.1.13 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineSyncOverruns
		description 	"The number of sync receive overruns on this connection."
		characteristics "-N sessLineSyncOverruns -O 1.3.6.1.4.1.166.1.14.3.1.14 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineSyncUnderruns
		description 	"The number of sync transmit underruns on this connection."
		characteristics "-N sessLineSyncUnderruns -O 1.3.6.1.4.1.166.1.14.3.1.15 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineSyncFrAborts
		description 	"The number of sync frame aborts on this connection."
		characteristics "-N sessLineSyncFrAborts -O 1.3.6.1.4.1.166.1.14.3.1.16 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLineSyncIntframes
		description 	"The number of sync interrupted frames on this connection."
		characteristics "-N sessLineSyncIntframes -O 1.3.6.1.4.1.166.1.14.3.1.17 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLinePktsIn
		description 	"The number of link-level packets received on this connection."
		characteristics "-N sessLinePktsIn -O 1.3.6.1.4.1.166.1.14.3.1.18 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sessLinePktsOut
		description 	"The number of link-level packets sent on this connection."
		characteristics "-N sessLinePktsOut -O 1.3.6.1.4.1.166.1.14.3.1.19 -T COUNTER -A RO -X equal -F 0"

		readonly int	sessLineSlot
		description 	"Physical slot number, starting with 1.  Skips empty slots."
		characteristics "-N sessLineSlot -O 1.3.6.1.4.1.166.1.14.3.1.20 -T INTEGER -A RO -X equal -F 0"

		readonly int	sessLineChan
		description 	"Logical channel number on physical slot.  BRI cards have
                two channels, all others have one."
		characteristics "-N sessLineChan -O 1.3.6.1.4.1.166.1.14.3.1.21 -T INTEGER -A RO -X equal -F 0"

		readonly enum sessLineTypeE	sessLineType
		description 	"Type of line for this session."
		characteristics "-N sessLineType -O 1.3.6.1.4.1.166.1.14.3.1.22 -T INTEGER -A RO -X equal -F 0"

	)

	table	ltlSessionTable
	description "A table of current LAN-to-LAN connections in the box."
	characteristics "-K ONE"
	(
		readonly enum ltlSessionInitiationE	ltlSessionInitiation
		description 	"A description of how the connection was initiated:
			remote  - Another box initiated the connection.
			user    - A user on the local box initiated the
				   connection via a command to the local
				   box.
			timed   - A timed connection on the local box
				   initiated the connection.
			startup - The local box initiated the connection
				   during box initialization."
		characteristics "-N ltlSessionInitiation -O 1.3.6.1.4.1.166.1.15.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly enum ltlSessionStateE	ltlSessionState
		description 	"A description of the state of the connection:
			idle	- The connection has just been torn down.
			asking  - A user is attempting to bring up a
				   connection but has entered an incorrect
				   username or password.  The box is waiting
				   for the user to enter a new password.
			trying  - The local box is attempting to establish
				   a connection with a remote box.
			manual  - A physical connection, but not a link layer
				   connection, has been established with a
				   remote box.  The user may now enter
				   commands that will be sent directly to
				   the modem on the local box.  (Not yet
				   implemented.)
			disconnecting  - The local box is in the process
					  of tearing down the connection to
					  the remote box.
			up	- The connection is active."
		characteristics "-N ltlSessionState -O 1.3.6.1.4.1.166.1.15.1.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly enum ltlSessionPersistentE	ltlSessionPersistent
		description 	"A description of persistency of the connection."
		characteristics "-N ltlSessionPersistent -O 1.3.6.1.4.1.166.1.15.1.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly enum ltlSessionLinkTypeE	ltlSessionLinkType
		description 	"A description of the link level protocol used by the connection."
		characteristics "-N ltlSessionLinkType -O 1.3.6.1.4.1.166.1.15.1.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	ltlSessionPhoneNumber
		description 	"The outgoing phone number used by the connection."
		characteristics "-N ltlSessionPhoneNumber -O 1.3.6.1.4.1.166.1.15.1.1.5 -T STRING -A RO -X equal -F 0"

	)

	table	internalModemTable
	description "A table of internal modems."
	characteristics "-K ONE"
	(
		readonly int	internalModemIndex
		description 	"Internal modem index."
		characteristics "-N internalModemIndex -O 1.3.6.1.4.1.166.1.16.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly enum internalModemClassE	internalModemClass
		description 	"Internal modem class."
		characteristics "-N internalModemClass -O 1.3.6.1.4.1.166.1.16.1.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	internalModemName
		description 	"Internal modem name."
		characteristics "-N internalModemName -O 1.3.6.1.4.1.166.1.16.1.1.3 -T STRING -A RO -X equal -F 0"

		readonly string[128]	internalModemFirmRev
		description 	"Internal modem firmware revision."
		characteristics "-N internalModemFirmRev -O 1.3.6.1.4.1.166.1.16.1.1.4 -T STRING -A RO -X equal -F 0"

		readonly string[128]	internalModemDPRev
		description 	"Internal modem datapump revision."
		characteristics "-N internalModemDPRev -O 1.3.6.1.4.1.166.1.16.1.1.5 -T STRING -A RO -X equal -F 0"

		readonly string[128]	internalModemAnswerInit
		description 	"Default answer init string for the internal modem."
		characteristics "-N internalModemAnswerInit -O 1.3.6.1.4.1.166.1.16.1.1.6 -T STRING -A RO -X equal -F 0"

		readonly enum internalModemConnSpeedE	internalModemConnSpeed
		description 	"Internal modem line connection speed."
		characteristics "-N internalModemConnSpeed -O 1.3.6.1.4.1.166.1.16.1.1.7 -T INTEGER -A RO -X equal -F 0"

		readonly enum internalModemErrorCorrE	internalModemErrorCorr
		description 	"Internal modem error correction protocol."
		characteristics "-N internalModemErrorCorr -O 1.3.6.1.4.1.166.1.16.1.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly enum internalModemDataComprE	internalModemDataCompr
		description 	"Internal modem line data compression type."
		characteristics "-N internalModemDataCompr -O 1.3.6.1.4.1.166.1.16.1.1.9 -T INTEGER -A RO -X equal -F 0"

		readonly int	internalModemEQM
		description 	"Internal modem line signal quality."
		characteristics "-N internalModemEQM -O 1.3.6.1.4.1.166.1.16.1.1.10 -T INTEGER -A RO -X equal -F 0"

		readonly int	internalModemAGC
		description 	"Internal modem line signal strength."
		characteristics "-N internalModemAGC -O 1.3.6.1.4.1.166.1.16.1.1.11 -T INTEGER -A RO -X equal -F 0"

	)

	table	serialLineTable
	description "Table of serial line initialization parameters and status."
	characteristics "-K ONE"
	(
		readonly int	serialLineIndex
		description 	"Serial line number, densely numbered starting with 1."
		characteristics "-N serialLineIndex -O 1.3.6.1.4.1.166.1.17.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	serialLineSlot
		description 	"Physical slot number, starting with 1.  Skips empty slots."
		characteristics "-N serialLineSlot -O 1.3.6.1.4.1.166.1.17.1.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	serialLineChan
		description 	"Logical channel number on physical slot.  BRI cards have
		two channels, all others have one."
		characteristics "-N serialLineChan -O 1.3.6.1.4.1.166.1.17.1.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	serialLineLogIndex
		description 	"Logical line number, the number used in the device
		name (ifDesc) SerialN.  Skips over empty slots."
		characteristics "-N serialLineLogIndex -O 1.3.6.1.4.1.166.1.17.1.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	serialLinePools
		description 	"The names of the pools that this line is in, comma-seperated."
		characteristics "-N serialLinePools -O 1.3.6.1.4.1.166.1.17.1.1.5 -T STRING -A RO -X equal -F 0"

		readwrite enum serialLineStatusE	serialLineStatus
		description 	"Serial line status.  Setting serialLineStatus
		to initializing(2) forces the line to be reinitialized."
		characteristics "-N serialLineStatus -O 1.3.6.1.4.1.166.1.17.1.1.6 -T INTEGER -A RW -X equal -F 0"

		readwrite string[128]	serialLineModemName
		description 	"The name of the type of modem connected to this line."
		characteristics "-N serialLineModemName -O 1.3.6.1.4.1.166.1.17.1.1.7 -T STRING -A RW -X equal -F 0"

		readwrite string[128]	serialLineAnswerInit
		description 	"The initialization string to put the modem in auto-answer
		mode."
		characteristics "-N serialLineAnswerInit -O 1.3.6.1.4.1.166.1.17.1.1.8 -T STRING -A RW -X equal -F 0"

		readwrite int	serialLineInitRate
		description 	"The rate in bits per second at which to initialize
		the line."
		characteristics "-N serialLineInitRate -O 1.3.6.1.4.1.166.1.17.1.1.9 -T INTEGER -A RW -X equal -F 0"

		readwrite enum serialLineInitFlowE	serialLineInitFlow
		description 	"The flow control setting to initialize the line with."
		characteristics "-N serialLineInitFlow -O 1.3.6.1.4.1.166.1.17.1.1.10 -T INTEGER -A RW -X equal -F 0"

		readonly int	serialLineSignals
		description 	"The current status of control signals on this line,
		as the sum of the following bits;
			0	Ready To Send
			1	Clear To Send
			2	Data Set Ready
			3	Data Terminal Ready
			4	Ring Indicate
			5	Data Carrier (Rcvd Line Signal) Detect
			6	Signal Quality Detect
			7	Signaling Rate Selector
			8	Secondary RTS
			9	Secondary CTS
			10	Secondary DCD."
		characteristics "-N serialLineSignals -O 1.3.6.1.4.1.166.1.17.1.1.11 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineModeE	serialLineMode
		description 	"The tranmission mode currently in use on this line."
		characteristics "-N serialLineMode -O 1.3.6.1.4.1.166.1.17.1.1.12 -T INTEGER -A RO -X equal -F 0"

		readwrite string[128]	serialLineInitString
		description 	"The initialization string to put the modem in dial
		mode."
		characteristics "-N serialLineInitString -O 1.3.6.1.4.1.166.1.17.1.1.13 -T STRING -A RW -X equal -F 0"

		readonly int	serialLineConnSpeed
		description 	"Line connection speed."
		characteristics "-N serialLineConnSpeed -O 1.3.6.1.4.1.166.1.17.1.1.14 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineSwitchE	serialLineSwitch
		description 	"ISDN switch type configured on this line."
		characteristics "-N serialLineSwitch -O 1.3.6.1.4.1.166.1.17.1.1.15 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineRadapE	serialLineRadap
		description 	"ISDN rate adaption type."
		characteristics "-N serialLineRadap -O 1.3.6.1.4.1.166.1.17.1.1.16 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineTransCapE	serialLineTransCap
		description 	"Type of ISDN service on this line"
		characteristics "-N serialLineTransCap -O 1.3.6.1.4.1.166.1.17.1.1.17 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	serialLineSpid
		description 	"ISDN Service Profile ID."
		characteristics "-N serialLineSpid -O 1.3.6.1.4.1.166.1.17.1.1.18 -T STRING -A RO -X equal -F 0"

		readonly enum serialLineErrorCorrE	serialLineErrorCorr
		description 	"error correction protocol on this line."
		characteristics "-N serialLineErrorCorr -O 1.3.6.1.4.1.166.1.17.1.1.19 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineDataComprE	serialLineDataCompr
		description 	"line data compression type."
		characteristics "-N serialLineDataCompr -O 1.3.6.1.4.1.166.1.17.1.1.20 -T INTEGER -A RO -X equal -F 0"

		readonly int	serialLineEQM
		description 	"line signal quality."
		characteristics "-N serialLineEQM -O 1.3.6.1.4.1.166.1.17.1.1.21 -T INTEGER -A RO -X equal -F 0"

		readonly int	serialLineAGC
		description 	"line signal strength."
		characteristics "-N serialLineAGC -O 1.3.6.1.4.1.166.1.17.1.1.22 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineStatTabE	serialLineStatTab
		description 	"Statistics table that pertains to this line."
		characteristics "-N serialLineStatTab -O 1.3.6.1.4.1.166.1.17.1.1.23 -T INTEGER -A RO -X equal -F 0"

		readonly int	serialLineStatIndex
		description 	"Index into statistics table."
		characteristics "-N serialLineStatIndex -O 1.3.6.1.4.1.166.1.17.1.1.24 -T INTEGER -A RO -X equal -F 0"

		readonly enum serialLineTypeE	serialLineType
		description 	"Type of line."
		characteristics "-N serialLineType -O 1.3.6.1.4.1.166.1.17.1.1.25 -T INTEGER -A RO -X equal -F 0"

	)

	table	linegroupTable
	description "A table of serial line groups."
	characteristics "-K ONE"
	(
		readonly string[128]	linegroupName
		description 	"A serial line group name."
		characteristics "-N linegroupName -O 1.3.6.1.4.1.166.1.17.2.1.1 -T STRING -A RO -X equal -F 0"

		readonly int	linegroupDialoutProts
		description 	"Bitmask of dialout protocols enabled for group:
			0x00000001 - IP
			0x00000002 - IPX
			0x00000004 - AppleTalk."
		characteristics "-N linegroupDialoutProts -O 1.3.6.1.4.1.166.1.17.2.1.2 -T INTEGER -A RO -X equal -F 0"

	)

	table	internalSlotTable
	description "A table of internal slots."
	characteristics "-K ONE"
	(
		readonly int	internalSlotIndex
		description 	"Internal slot index."
		characteristics "-N internalSlotIndex -O 1.3.6.1.4.1.166.1.18.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly enum internalSlotTypeE	internalSlotType
		description 	"Internal slot class."
		characteristics "-N internalSlotType -O 1.3.6.1.4.1.166.1.18.1.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	internalSlotName
		description 	"Internal slot name."
		characteristics "-N internalSlotName -O 1.3.6.1.4.1.166.1.18.1.1.3 -T STRING -A RO -X equal -F 0"

		readonly string[128]	internalSlotFirmRev
		description 	"Internal slot firmware revision."
		characteristics "-N internalSlotFirmRev -O 1.3.6.1.4.1.166.1.18.1.1.4 -T STRING -A RO -X equal -F 0"

		readonly string[128]	internalSlotHWRev
		description 	"Internal slot hardware/datapump revision."
		characteristics "-N internalSlotHWRev -O 1.3.6.1.4.1.166.1.18.1.1.5 -T STRING -A RO -X equal -F 0"

		readwrite enum internalSlotStatusE	internalSlotStatus
		description 	"Internal slot status."
		characteristics "-N internalSlotStatus -O 1.3.6.1.4.1.166.1.18.1.1.6 -T INTEGER -A RW -X equal -F 0"

		readonly int	internalSlotNumLines
		description 	"Number of lines supported on this internal slot."
		characteristics "-N internalSlotNumLines -O 1.3.6.1.4.1.166.1.18.1.1.7 -T INTEGER -A RO -X equal -F 0"

		readonly enum internalSlotSwitchE	internalSlotSwitch
		description 	"ISDN switch type on this slot."
		characteristics "-N internalSlotSwitch -O 1.3.6.1.4.1.166.1.18.1.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly enum internalSlotDchanStatE	internalSlotDchanStat
		description 	"ISDN D channel status."
		characteristics "-N internalSlotDchanStat -O 1.3.6.1.4.1.166.1.18.1.1.9 -T INTEGER -A RO -X equal -F 0"

	)

	group	fpBuffer
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	bufferSize
		description 	"The size of the buffers in the buffer pool.
		All buffers are the same size."
		characteristics "-N bufferSize -O 1.3.6.1.4.1.166.2.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	bufferAvail
		description 	"The total number of buffers initialized.  This does
	    	not indicate the number of currently free buffers.
	    	Rather it is the total number of buffers which were
	    	created and made free at boot time."
		characteristics "-N bufferAvail -O 1.3.6.1.4.1.166.2.1.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly counter	bufferDrops
		description 	"The total number of times that a buffer was requested
	    	when none was available."
		characteristics "-N bufferDrops -O 1.3.6.1.4.1.166.2.1.1.3 -T COUNTER -A RO -X equal -F 0"

	)

	table	bufferTypeTable
	description "Each row of this table describes statistics on buffers
		allocated for a specific purpose. The sum of bufferTypeCount
		for all rows should always equal the bufferAvail count."
	characteristics "-K ONE"
	(
		readonly int	bufferTypeIndex
		description 	"The enumeration of each buffer type row."
		characteristics "-N bufferTypeIndex -O 1.3.6.1.4.1.166.2.1.1.4.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly enum bufferTypeTypeE	bufferTypeType
		description 	"enumerated type of buffer type."
		characteristics "-N bufferTypeType -O 1.3.6.1.4.1.166.2.1.1.4.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	bufferTypeDescr
		description 	"Text description of buffer type."
		characteristics "-N bufferTypeDescr -O 1.3.6.1.4.1.166.2.1.1.4.1.3 -T STRING -A RO -X equal -F 0"

		readonly int	bufferTypeCount
		description 	"The number of buffers of the type which is described by
		the value of bufferTypeType for this row."
		characteristics "-N bufferTypeCount -O 1.3.6.1.4.1.166.2.1.1.4.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly int	bufferTypeDrops
		description 	"The number of requests for buffers this type which were
		not fulfilled because no free buffers were available."
		characteristics "-N bufferTypeDrops -O 1.3.6.1.4.1.166.2.1.1.4.1.5 -T INTEGER -A RO -X equal -F 0"

		readonly int	bufferTypeRequests
		description 	"The number of times buffers of this type were requested."
		characteristics "-N bufferTypeRequests -O 1.3.6.1.4.1.166.2.1.1.4.1.6 -T INTEGER -A RO -X equal -F 0"

		readonly int	bufferTypeMaximum
		description 	"A high water mark for buffers of this type.
		This number represents the greatest number of buffers
		of this type ever allocated concurrently."
		characteristics "-N bufferTypeMaximum -O 1.3.6.1.4.1.166.2.1.1.4.1.7 -T INTEGER -A RO -X equal -F 0"

	)

	group	fpConf
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite timeticks	confReboot
		description 	"The amount of time, in hundredths of a second, until the
		device reboots itself."
		characteristics "-N confReboot -O 1.3.6.1.4.1.166.2.1.2.1 -T TIMETICKS -A RW -X equal -F 0"

		readwrite enum confCheckSumE	confCheckSum
		description 	"Indicates the validity of the FastPath's configuration.  If
		written to, allows the management station to flush the
		configuration (by setting invalid), or to protect it (by
		setting valid)."
		characteristics "-N confCheckSum -O 1.3.6.1.4.1.166.2.1.2.2 -T INTEGER -A RW -X equal -F 0"

		readwrite enum codeCheckSumE	codeCheckSum
		description 	"Indicates the validity of the FastPath's downloaded image.
		If written to, allows the management station to flush the
		downloaded image (by setting invalid), or to protect the
		it (by setting valid)."
		characteristics "-N codeCheckSum -O 1.3.6.1.4.1.166.2.1.2.3 -T INTEGER -A RW -X equal -F 0"

		readonly int	promVersion
		description 	"The version number of the PROM multiplied by 100, for
		instance, PROM version 4.1 would return 410."
		characteristics "-N promVersion -O 1.3.6.1.4.1.166.2.1.2.4 -T INTEGER -A RO -X equal -F 0"

		readonly int	hwStatus
		description 	"This integer is a bit mask which holds the following flags:
		(not all bits are valid for all products)
			0x00000001 - LocalTalk failed tests
			0x00000002 - LAN controller failed tests
			0x00000004 - The battery is low
			0x00000008 - Expansion RAM is present
			0x00000010 - Ethernet 12V Fuse blown
			0x00000020 - Expansion RAM failed tests
			0x00000040 - Disable Enet CRS jumper installed
			0x00000080 - Disable Enet SQE jumper installed
			0x00000100 - Software Jumper 1 installed
			0x00000200 - Software Jumper 2 installed
			0x00000400 - Software Jumper 3 installed
			0x00000800 - Software Jumper 4 installed
			0x00007000 - EtherModule type field
			0x00008000 - EtherModule type field is valid
			0x00010000 - RAM Bank 3 is present
			0x00020000 - RAM Bank 3 failed tests
			0x00040000 - RAM Bank 4 is present
			0x00080000 - RAM Bank 4 failed tests
			0x00100000 - Downloader mode
			0x00200000 - Software Jumper 5 installed
			0x00400000 - Hardware has LocalTalk IOP
			0x00800000 - VROM on top of 'sam' PROM
			0x01000000 - Auxiliary memory board present
			0x02000000 - Auxiliary memory board failed tests."
		characteristics "-N hwStatus -O 1.3.6.1.4.1.166.2.1.2.5 -T INTEGER -A RO -X equal -F 0"

		readwrite enum confWhyRebootE	confWhyReboot
		description 	"Reason code for reboot scheduled by confReboot"
		characteristics "-N confWhyReboot -O 1.3.6.1.4.1.166.2.1.2.6 -T INTEGER -A RW -X equal -F 0"

		readwrite string[128]	confWhoReboot
		description 	"Person responsible for reboot scheduled by confReboot"
		characteristics "-N confWhoReboot -O 1.3.6.1.4.1.166.2.1.2.7 -T STRING -A RW -X equal -F 0"

		readwrite string[128]	confRebootComment
		description 	"Comment string for reboot scheduled by confReboot"
		characteristics "-N confRebootComment -O 1.3.6.1.4.1.166.2.1.2.8 -T STRING -A RW -X equal -F 0"

		readwrite enum confHowRebootE	confHowReboot
		description 	"Action taken when reboot scheduled by confReboot occurs"
		characteristics "-N confHowReboot -O 1.3.6.1.4.1.166.2.1.2.9 -T INTEGER -A RW -X equal -F 0"

		readwrite int	confSerialNum
		description 	"FastPath Serial Number"
		characteristics "-N confSerialNum -O 1.3.6.1.4.1.166.2.1.2.10 -T INTEGER -A RW -X equal -F 0"

	)

	group	mport
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite int	mportDeviceName
		description 	"The server name advertised by a LanRover/E"
		characteristics "-N mportDeviceName -O 1.3.6.1.4.1.166.2.2.1.2 -T INTEGER -A RW -X equal -F 0"

		readwrite timeticks	mportDialinIdleTime
		description 	"The time (in 0.01 second units) to allow a PPP
		dial-in connection to stay idle before disconnecting
		the user."
		characteristics "-N mportDialinIdleTime -O 1.3.6.1.4.1.166.2.2.1.3 -T TIMETICKS -A RW -X equal -F 0"

		readwrite enum mportDialinIdleStatusE	mportDialinIdleStatus
		description 	"Indicates whether or not a PPP dial-in idle detection
		is active."
		characteristics "-N mportDialinIdleStatus -O 1.3.6.1.4.1.166.2.2.1.4 -T INTEGER -A RW -X equal -F 0"

	)

	table	mportTable
	description "(null)"
	characteristics "-K ONE"
	(
		readwrite octet[128]	mportPortName
		description 	"The specific name of the port.  This is used as the
		SAP name of a NetModem/E."
		characteristics "-N mportPortName -O 1.3.6.1.4.1.166.2.2.1.1.1.1 -T STRING -A RW -X equal -F 0"

		readwrite timeticks	mportIdleTime
		description 	"The time (in 0.01 second units) to allow a dialout
		connection to stay idle before disconnecting the
		user."
		characteristics "-N mportIdleTime -O 1.3.6.1.4.1.166.2.2.1.1.1.2 -T TIMETICKS -A RW -X equal -F 0"

		readwrite enum mportIdleStatusE	mportIdleStatus
		description 	"Indicates whether or not dial-out idle detection is active."
		characteristics "-N mportIdleStatus -O 1.3.6.1.4.1.166.2.2.1.1.1.3 -T INTEGER -A RW -X equal -F 0"

		readwrite enum mportStatusE	mportStatus
		description 	"The current status of this port."
		characteristics "-N mportStatus -O 1.3.6.1.4.1.166.2.2.1.1.1.4 -T INTEGER -A RW -X equal -F 0"

		readonly octet[128]	mportUsername
		description 	"The name of the user currently attached to this port."
		characteristics "-N mportUsername -O 1.3.6.1.4.1.166.2.2.1.1.1.5 -T STRING -A RO -X equal -F 0"

		readwrite int	mportPermissions
		description 	"The specific permissions enabled for this port."
		characteristics "-N mportPermissions -O 1.3.6.1.4.1.166.2.2.1.1.1.6 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	mportCCLName
		description 	"The title of the CCL script assigned to this port."
		characteristics "-N mportCCLName -O 1.3.6.1.4.1.166.2.2.1.1.1.7 -T STRING -A RW -X equal -F 0"

		readwrite octet[128]	mportCCLData
		description 	"As-yet undefined CCL script code."
		characteristics "-N mportCCLData -O 1.3.6.1.4.1.166.2.2.1.1.1.8 -T STRING -A RW -X equal -F 0"

		readwrite int	mportBaudRate
		description 	"The default start-up baud rate of this port."
		characteristics "-N mportBaudRate -O 1.3.6.1.4.1.166.2.2.1.1.1.9 -T INTEGER -A RW -X equal -F 0"

		readwrite enum mportFlowControlE	mportFlowControl
		description 	"The flow control setting for this port.  This is
		ignored in systems with internal modems."
		characteristics "-N mportFlowControl -O 1.3.6.1.4.1.166.2.2.1.1.1.10 -T INTEGER -A RW -X equal -F 0"

		readonly timeticks	mportCurrentIdleTime
		description 	"The amount of time the current connection has been idle."
		characteristics "-N mportCurrentIdleTime -O 1.3.6.1.4.1.166.2.2.1.1.1.11 -T TIMETICKS -A RO -X equal -F 0"

		readonly timeticks	mportCurrentConnectTime
		description 	"The amount of time since the current connection was
		established."
		characteristics "-N mportCurrentConnectTime -O 1.3.6.1.4.1.166.2.2.1.1.1.12 -T TIMETICKS -A RO -X equal -F 0"

		readonly int	mportDTESignals
		description 	"The current DTE signals on this port stored as a
	    	a bit mask which holds the following flags:
			0x80 DCD
			0x40 DSR
			0x20 DTR
			0x10 RTS
			0x08 CTS"
		characteristics "-N mportDTESignals -O 1.3.6.1.4.1.166.2.2.1.1.1.13 -T INTEGER -A RO -X equal -F 0"

	)

	table	ipxcpTable
	description "Table of IPX control protocol settings, which
		probably don't really need to be in a table."
	characteristics "-K ONE"
	(
		readwrite int	ipxcpDialinNet
		description 	"The IPX network number which will be assigned to a
		dial-in client on this port.  Since this isn't really
		going to get instanced on a per-port basis, we should
		lose the table stuff."
		characteristics "-N ipxcpDialinNet -O 1.3.6.1.4.1.166.2.2.2.1.1.1 -T INTEGER -A RW -X equal -F 0"

	)

	group	ipxelap
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum ipxelapFrameTypeE	ipxelapFrameType
		description 	"The framing type used by the ethernet interface.
		typeAutosense not supported in rev 1.0.X firmware"
		characteristics "-N ipxelapFrameType -O 1.3.6.1.4.1.166.2.2.3.1 -T INTEGER -A RW -X equal -F 0"

	)

	group	rip
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite int	ripDefaultNet
		description 	"The default IPX network number for the ethernet interface"
		characteristics "-N ripDefaultNet -O 1.3.6.1.4.1.166.2.2.4.1 -T INTEGER -A RW -X equal -F 0"

	)

	group	ipx
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum ipxRouteNetBIOSE	ipxRouteNetBIOS
		description 	"If this variable is 'bidirectional' the NetModem/E
		will do full routing of Novell NetBIOS.  Otherwise it
		will only forward NetBIOS broadcasts which originate
		from a single-user dialin access node."
		characteristics "-N ipxRouteNetBIOS -O 1.3.6.1.4.1.166.2.2.5.1 -T INTEGER -A RW -X equal -F 0"

	)

	group	nmv32emodem
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	modemCount
		description 	"How many modems are in this product."
		characteristics "-N modemCount -O 1.3.6.1.4.1.166.1.16.1 -T INTEGER -A RO -X equal -F 0"

	)

	table	modemTable
	description "The table which describes the state of all of the
		modems in the product."
	characteristics "-K ONE"
	(
		readonly int	modemIndex
		description 	"The ordinal number of this modem, from 1..modemCount"
		characteristics "-N modemIndex -O 1.3.6.1.4.1.166.1.16.2.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	modemState
		description 	"The state of the modem, expressed as a bitmap of
		boolean values;
			Bit		Meaning
			0		Off-Hook
			1		Carrier Detect
			2		Command Mode"
		characteristics "-N modemState -O 1.3.6.1.4.1.166.1.16.2.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly enum modemModulationTypeE	modemModulationType
		description 	"The modulation type of the modem.  Valid only if the
		Carrier Detect bit is set in the modemState."
		characteristics "-N modemModulationType -O 1.3.6.1.4.1.166.1.16.2.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	modemModulationRate
		description 	"The modulation speed in bits per second."
		characteristics "-N modemModulationRate -O 1.3.6.1.4.1.166.1.16.2.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly enum modemErrorCorrectionE	modemErrorCorrection
		description 	"The type of error correction protocol in use."
		characteristics "-N modemErrorCorrection -O 1.3.6.1.4.1.166.1.16.2.1.5 -T INTEGER -A RO -X equal -F 0"

		readonly enum modemDataCompressionE	modemDataCompression
		description 	"The type of data compression protocol in use."
		characteristics "-N modemDataCompression -O 1.3.6.1.4.1.166.1.16.2.1.6 -T INTEGER -A RO -X equal -F 0"

		readonly int	modemMeanSquareError
		description 	"The current mean-square error rate of the modem connection."
		characteristics "-N modemMeanSquareError -O 1.3.6.1.4.1.166.1.16.2.1.7 -T INTEGER -A RO -X equal -F 0"

		readonly int	modemRetrainCount
		description 	"The number of times the modems have had to retrain during
		this connection"
		characteristics "-N modemRetrainCount -O 1.3.6.1.4.1.166.1.16.2.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly timeticks	modemRetrainTime
		description 	"The time elapsed since the last train (or retrain) completed."
		characteristics "-N modemRetrainTime -O 1.3.6.1.4.1.166.1.16.2.1.9 -T TIMETICKS -A RO -X equal -F 0"

	)

	group	tATalk
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	tRTMPEntryTimeouts
		description 	"The number of entries which were removed from
		routing table because the aging algorithm
		indicated that they were invalid."
		characteristics "-N tRTMPEntryTimeouts -O 1.3.6.1.4.1.166.4.2.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	tRTMPEntryDeletes
		description 	"The number of entries which were removed from the
		routing table for any reason other than aging, for
		instance, due to a command from a Network
		Management station."
		characteristics "-N tRTMPEntryDeletes -O 1.3.6.1.4.1.166.4.2.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	tRTMPEntryEqualReplaces
		description 	"The number of entries whose route was replaced by
		another route with the same hop count."
		characteristics "-N tRTMPEntryEqualReplaces -O 1.3.6.1.4.1.166.4.2.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	tRTMPEntryBetterReplaces
		description 	"The number of entries whose route was replaced by
		another route with a lower hop count."
		characteristics "-N tRTMPEntryBetterReplaces -O 1.3.6.1.4.1.166.4.2.4 -T INTEGER -A RO -X equal -F 0"

		readonly int	tRTMPEntryAdds
		description 	"The number of new entries which have been added to
		the table."
		characteristics "-N tRTMPEntryAdds -O 1.3.6.1.4.1.166.4.2.5 -T INTEGER -A RO -X equal -F 0"

		readwrite enum tRTMPZeroCountersE	tRTMPZeroCounters
		description 	"Writing this variable causes all the RTMP variables
		in this group to be set to zero."
		characteristics "-N tRTMPZeroCounters -O 1.3.6.1.4.1.166.4.2.6 -T INTEGER -A RW -X equal -F 0"

		readonly int	tZIPDeletes
		description 	"The number of Zones which have been deleted from the
		Zone Table."
		characteristics "-N tZIPDeletes -O 1.3.6.1.4.1.166.4.2.7 -T INTEGER -A RO -X equal -F 0"

		readonly int	tZIPAdds
		description 	"The number of Zones which have been added to the
		Zone Table."
		characteristics "-N tZIPAdds -O 1.3.6.1.4.1.166.4.2.8 -T INTEGER -A RO -X equal -F 0"

		readwrite enum tZIPZeroCountersE	tZIPZeroCounters
		description 	"Writing this variable causes all the ZIP variables
		in this group to be set to zero."
		characteristics "-N tZIPZeroCounters -O 1.3.6.1.4.1.166.4.2.9 -T INTEGER -A RW -X equal -F 0"

		readwrite enum tAARPClearCacheE	tAARPClearCache
		description 	"Writing this variable clears the AARP Cache."
		characteristics "-N tAARPClearCache -O 1.3.6.1.4.1.166.4.2.10 -T INTEGER -A RW -X equal -F 0"

		readwrite enum tKIPRoutesValidE	tKIPRoutesValid
		description 	"This variable can be used to force KIP to reacquire its
		configuration information."
		characteristics "-N tKIPRoutesValid -O 1.3.6.1.4.1.166.4.2.11 -T INTEGER -A RW -X equal -F 0"

		readonly octet[128]	tNBPDeviceObject
		description 	"The NBP name used to advertise this device's primary
		 NVE on the LAN interface."
		characteristics "-N tNBPDeviceObject -O 1.3.6.1.4.1.166.4.2.12 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	tNBPDeviceType
		description 	"The NBP type used to advertise this device's primary
		 NVE on the LAN interface."
		characteristics "-N tNBPDeviceType -O 1.3.6.1.4.1.166.4.2.13 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	tNBPDeviceZone
		description 	"The zone in which this device registers its primary
		 NVE on the LAN interface."
		characteristics "-N tNBPDeviceZone -O 1.3.6.1.4.1.166.4.2.14 -T STRING -A RO -X equal -F 0"

		readonly int	tNBPDeviceSocket
		description 	"The DDP socket number used by the device in NBP
		 Responses for its primary NVE registered on the LAN
		 interface."
		characteristics "-N tNBPDeviceSocket -O 1.3.6.1.4.1.166.4.2.15 -T INTEGER -A RO -X equal -F 0"

		readonly octet[128]	tATDialinNetwork
		description 	"The AppleTalk network number in which AppleTalk
		 dialin users appear.  When
		 tATDialInPacketDeliveryMode is routing(1) this value
		 corresponds to the configured dialin network number.
		 When tATDialInPacketDeliveryMode is
		 endNodeForwarding(2) this value corresponds to the
		 network number of the LAN interface.  Note that when
		 endNodeForwarding(2) it is possible that not all
		 dialin clients have addresses on this network because
		 there may not have been enough available node ids to
		 obtain addresses for all of the clients.  In this
		 case another network in the extended range of the LAN
		 interface may be used for the remaining clients'
		 addresses.  Ideally this should be a table of clients
		 with their dialin addresses."
		characteristics "-N tATDialinNetwork -O 1.3.6.1.4.1.166.4.2.16 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	tATDialinZone
		description 	"The zone with which tATDialinNetwork is associated."
		characteristics "-N tATDialinZone -O 1.3.6.1.4.1.166.4.2.17 -T STRING -A RO -X equal -F 0"

		readonly enum tATRoutingModeE	tATRoutingMode
		description 	"The routing behavior of this device for AppleTalk.

		 If the device is configured as conformingRouter(1) or
		 seedRouter(2) then it will behave as an AppleTalk
		 router on the LAN interface, and will route packets to
		 all interfaces.  If it is a conformingRouter(1) then
		 it will learn its configuration for the LAN interface
		 from other routers on that interface's
		 directly-connected network.  If it is a seedRouter(2)
		 then it will use the configured LAN interface
		 parameters.

		 If the device is configured as endNode(3) it will
		 behave as an AppleTalk endnode on the LAN interface.

		 other(4) is provided in the event a value is returned
		 which does not match any of the other enumerated
		 values.  It is not expected that this will happen."
		characteristics "-N tATRoutingMode -O 1.3.6.1.4.1.166.4.2.18 -T INTEGER -A RO -X equal -F 0"

		readonly enum tATDialinPacketDeliveryModeE	tATDialinPacketDeliveryMode
		description 	"The method used to deliver packets to and from
		 Appletalk dialin clients.

		 If the device is configured as routing(1) it will use
		 routing tables to deliver packets to and from dialin
		 clients, which will be homed on an internal virtual
		 interface (port).  Technically, the value routing(1)
		 is only valid if the device is acting as a router
		 (the value of tATRoutingMode is conformingRouter(1)
		 or seedRouter(2)).

	 	 If the device is configured to use
		 endNodeForwarding(2) then it will obtain addresses
		 for dialin users in the LAN network range, and will
		 defend those addresses.  Packets to and from dialin
		 clients will be forwarded.  Technically the device
		 may be configured as endNodeForwarding(2) when
		 tATRoutingMode is any of: conformingRouter(1),
		 seedRouter(2), or endNode(3).

	  	 other(3) is provided in the event a value is returned
		 which does not match any of the other enumerated
		 values.  It is not expected that this will happen."
		characteristics "-N tATDialinPacketDeliveryMode -O 1.3.6.1.4.1.166.4.2.19 -T INTEGER -A RO -X equal -F 0"

		readonly int	tRTMPEntryTotal
		description 	"The number of network (range) entries in the
		 device's RTMP Table.  This value is not cleared by
                 the tRTMPZeroCounters switch."
		characteristics "-N tRTMPEntryTotal -O 1.3.6.1.4.1.166.4.2.20 -T INTEGER -A RO -X equal -F 0"

		readonly int	tZoneTotal
		description 	"The number of AppleTalk zones for which the device
		 has learned one or more associated nets or net
		 ranges.  This value is not cleared by
                 the tZIPZeroCounters switch."
		characteristics "-N tZoneTotal -O 1.3.6.1.4.1.166.4.2.21 -T INTEGER -A RO -X equal -F 0"

	)

	group	tIP
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum tARPClearCacheE	tARPClearCache
		description 	"Writing this variable clears the ARP Cache."
		characteristics "-N tARPClearCache -O 1.3.6.1.4.1.166.4.3.1 -T INTEGER -A RW -X equal -F 0"

		readwrite enum tIPClearRedirectsE	tIPClearRedirects
		description 	"Writing this variable removes all ICMP from the
		IP routing table."
		characteristics "-N tIPClearRedirects -O 1.3.6.1.4.1.166.4.3.2 -T INTEGER -A RW -X equal -F 0"

		readwrite enum tUDPChecksumsE	tUDPChecksums
		description 	"Indicates whether checksums will be calculated
		and verified for locally generated and received UDP
		packets."
		characteristics "-N tUDPChecksums -O 1.3.6.1.4.1.166.4.3.3 -T INTEGER -A RW -X equal -F 0"

		readwrite enum tIPBroadCastFillE	tIPBroadCastFill
		description 	"Indicates whether locally calculated broadcast address
		will be one-fill or zero-fill."
		characteristics "-N tIPBroadCastFill -O 1.3.6.1.4.1.166.4.3.4 -T INTEGER -A RW -X equal -F 0"

		readonly netaddress	tBootServerAddress
		description 	"The Address of the server from which the system last
		retrieved an image and configuration."
		characteristics "-N tBootServerAddress -O 1.3.6.1.4.1.166.4.3.7 -T IPADDRESS -A RO -X equal -F 0"

		readwrite enum tAcceptAnyClientAddrE	tAcceptAnyClientAddr
		description 	"Indicates whether IP addresses proposed by the client
		will be accepted without checking against configured
		(per-port, per-user, etc) addresses."
		characteristics "-N tAcceptAnyClientAddr -O 1.3.6.1.4.1.166.4.3.9 -T INTEGER -A RW -X equal -F 0"

		readonly int	tNumIpRoutes
		description 	"Number of routes in the entity's IP routing table."
		characteristics "-N tNumIpRoutes -O 1.3.6.1.4.1.166.4.3.10 -T INTEGER -A RO -X equal -F 0"

		readonly enum tUseConfiguredUserAddrE	tUseConfiguredUserAddr
		description 	"Indicates whether IP addresses configured for users
		will be a determinant in IP address assignment policy
 		for dialin clients.  The four possible sources
		of IP addresses are as follows: 1) client-proposed
		address, 2) user record address, 3) address pool, and
		4) address from Dynamic Host Configuration Protocol
		(DHCP) server.  These sources are checked in order, but
		a source is only checked if it is enabled as a
		determinant."
		characteristics "-N tUseConfiguredUserAddr -O 1.3.6.1.4.1.166.4.3.11 -T INTEGER -A RO -X equal -F 0"

		readonly enum tUseConfiguredPortAddrE	tUseConfiguredPortAddr
		description 	"Indicates whether IP addresses configured for ports
		will be a determinant in IP address assignment policy
		for dialin clients.  The four possible sources
		of IP addresses are as follows: 1) client-proposed
		address, 2) user record address, 3) address pool, and
		4) address from Dynamic Host Configuration Protocol
		(DHCP) server.  These sources are checked in order, but
		a source is only checked if it is enabled as a
		determinant.

		Deprecated, always returns disabled(2)"
		characteristics "-N tUseConfiguredPortAddr -O 1.3.6.1.4.1.166.4.3.12 -T INTEGER -A RO -X equal -F 0"

		readonly enum tUseDHCPAddrE	tUseDHCPAddr
		description 	"Indicates whether IP addresses will be obtained for
		dialin clients via the 	Dynamic Host Configuration
		Protocol.  The four possible sources of IP addresses
		are as follows: 1) client-proposed address, 2) user
		record address, 3) address pool, and 4) address from
		Dynamic Host Configuration Protocol (DHCP) server.
		These sources are checked in order, but a source is
		only checked if it is enabled as a determinant."
		characteristics "-N tUseDHCPAddr -O 1.3.6.1.4.1.166.4.3.13 -T INTEGER -A RO -X equal -F 0"

		readonly netaddress	tHomeIPAddr
		description 	"The IP Address of the home (main) IP interface.  It
		is implict that there is one main IP address which the
		device prefers to use as its source address for
		internally generated IP traffic which is not in
		response to received IP packets.  Technically this
		address is already available via the ipAddrTable, but
		since this table is indexed by IP address a GetNext
		is needed in order to access the table to determine
		an IP address, and this is not always practical."
		characteristics "-N tHomeIPAddr -O 1.3.6.1.4.1.166.4.3.14 -T IPADDRESS -A RO -X equal -F 0"

		readonly enum tUsePoolAddrE	tUsePoolAddr
		description 	"Indicates whether IP addresses from the IP address pool
		will be a determinant in IP address assignment policy
		for dialin clients.  The four possible sources
		of IP addresses are as follows: 1) client-proposed
		address, 2) user record address, 3) address pool, and
		4) address from Dynamic Host Configuration Protocol
		(DHCP) server.  These sources are checked in order, but
		a source is only checked if it is enabled as a
		determinant."
		characteristics "-N tUsePoolAddr -O 1.3.6.1.4.1.166.4.3.15 -T INTEGER -A RO -X equal -F 0"

	)

	table	tTimeServerTable
	description "Table of RFC858 UDP Time servers."
	characteristics "-K ONE"
	(
		readwrite netaddress	tTimeServerAddress
		description 	"The Address of the time server."
		characteristics "-N tTimeServerAddress -O 1.3.6.1.4.1.166.4.3.5.1.1 -T IPADDRESS -A RW -X equal -F 0"

	)

	table	tNameServerTable
	description "Table of Domain Name Servers."
	characteristics "-K ONE"
	(
		readwrite netaddress	tNameServerAddress
		description 	"The Address of the name server."
		characteristics "-N tNameServerAddress -O 1.3.6.1.4.1.166.4.3.6.1.1 -T IPADDRESS -A RW -X equal -F 0"

	)

	table	tSerialIpAddressTable
	description "Table of Serial IP addresses and default addresses
		indexed by serial line number."
	characteristics "-K ONE"
	(
		readonly int	tSerialIpAddressIndex
		description 	"A serial line number."
		characteristics "-N tSerialIpAddressIndex -O 1.3.6.1.4.1.166.4.3.8.1.1 -T INTEGER -A RO -X equal -F 0"

		readwrite netaddress	tSerialIpAddressLocalDefaultAddress
		description 	"The default local IP address for this serial line."
		characteristics "-N tSerialIpAddressLocalDefaultAddress -O 1.3.6.1.4.1.166.4.3.8.1.2 -T IPADDRESS -A RW -X equal -F 0"

		readwrite netaddress	tSerialIpAddressRemoteDefaultAddress
		description 	"The default remote IP address for this serial line.

		Deprecated, always 0."
		characteristics "-N tSerialIpAddressRemoteDefaultAddress -O 1.3.6.1.4.1.166.4.3.8.1.3 -T IPADDRESS -A RW -X equal -F 0"

		readwrite netaddress	tSerialIpAddressLocalAddress
		description 	"The local IP address in use on this serial line.

		Deprecated, always 0."
		characteristics "-N tSerialIpAddressLocalAddress -O 1.3.6.1.4.1.166.4.3.8.1.4 -T IPADDRESS -A RW -X equal -F 0"

		readwrite netaddress	tSerialIpAddressRemoteAddress
		description 	"The remote IP address in use on this serial line."
		characteristics "-N tSerialIpAddressRemoteAddress -O 1.3.6.1.4.1.166.4.3.8.1.5 -T IPADDRESS -A RW -X equal -F 0"

	)

	group	tCommunity
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum tCommunityTrapHostTypeE	tCommunityTrapHostType
		description 	"This is the address type of the trap host.  The Trap Host
		is the host to which the device sends all traps."
		characteristics "-N tCommunityTrapHostType -O 1.3.6.1.4.1.166.4.4.1 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	tCommunityTrapHostAddress
		description 	"This is the Network Address of the host.  It is interpreted
		according to the value of tCommunityTrapHostType."
		characteristics "-N tCommunityTrapHostAddress -O 1.3.6.1.4.1.166.4.4.2 -T STRING -A RW -X equal -F 0"

		readwrite enum tCommunitySetHostTypeE	tCommunitySetHostType
		description 	"This is the address family of the set host.  The Set Host is
		a host which is privileged to change any MIB variable."
		characteristics "-N tCommunitySetHostType -O 1.3.6.1.4.1.166.4.4.3 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	tCommunitySetHostAddress
		description 	"This is the Network Address of the Set Host.  It is
		interpreted  according to the value of
		tCommunityTrapHostType."
		characteristics "-N tCommunitySetHostAddress -O 1.3.6.1.4.1.166.4.4.4 -T STRING -A RW -X equal -F 0"

	)

	table	tCommunityTable
	description "The Communities Table describes the various communities
		known to the the device."
	characteristics "-K ONE"
	(
		readwrite string[128]	tCommunityName
		description 	"The name of this community."
		characteristics "-N tCommunityName -O 1.3.6.1.4.1.166.4.4.5.1.1 -T STRING -A RW -X equal -F 0"

		readwrite enum tCommunityAccessE	tCommunityAccess
		description 	"This defines the privilege of the community.  A 'read-only'
		community can examine any readable variable.  A
		'clear-statistics' community can reset non-critical counters.
		A 'configure' community has complete privileges.  By setting
		the community access to 'no-access', a management station
		can deny all access by that community."
		characteristics "-N tCommunityAccess -O 1.3.6.1.4.1.166.4.4.5.1.2 -T INTEGER -A RW -X equal -F 0"

	)

	table	tEtherTable
	description "Table of statistics for the ethernet interfaces of a device."
	characteristics "-K ONE"
	(
		readonly counter	etherCRCErrors
		description 	"The total number of CRC errors
		on this ethernet interface"
		characteristics "-N etherCRCErrors -O 1.3.6.1.4.1.166.4.5.1.1.1 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherAlignErrors
		description 	"The total number of alignment errors
		on this ethernet interface."
		characteristics "-N etherAlignErrors -O 1.3.6.1.4.1.166.4.5.1.1.2 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherResourceErrors
		description 	"The total number of errors due to lack of resources
		on this ethernet interface."
		characteristics "-N etherResourceErrors -O 1.3.6.1.4.1.166.4.5.1.1.3 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherOverrunErrors
		description 	"The total number of overrun errors
		on this ethernet interface."
		characteristics "-N etherOverrunErrors -O 1.3.6.1.4.1.166.4.5.1.1.4 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherInPackets
		description 	"The total number of input packets on this ethernet interface."
		characteristics "-N etherInPackets -O 1.3.6.1.4.1.166.4.5.1.1.5 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherOutPackets
		description 	"The total number of output packets
		on this ethernet interface."
		characteristics "-N etherOutPackets -O 1.3.6.1.4.1.166.4.5.1.1.6 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherBadTransmits
		description 	"The total number of transmission errors
		on this ethernet interface."
		characteristics "-N etherBadTransmits -O 1.3.6.1.4.1.166.4.5.1.1.7 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherOversizeFrames
		description 	"The total number of oversize frame errors
		on this ethernet interface."
		characteristics "-N etherOversizeFrames -O 1.3.6.1.4.1.166.4.5.1.1.8 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherSpurRUReadys
		description 	"The total number of spurious RU Ready interrupts
		on this ethernet interface."
		characteristics "-N etherSpurRUReadys -O 1.3.6.1.4.1.166.4.5.1.1.9 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherSpurCUActives
		description 	"The total number of spurious CU Active interrupts
		on this ethernet interface."
		characteristics "-N etherSpurCUActives -O 1.3.6.1.4.1.166.4.5.1.1.10 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherSpurUnknowns
		description 	"The total number of unknown spurious interrupts
		on this ethernet interface."
		characteristics "-N etherSpurUnknowns -O 1.3.6.1.4.1.166.4.5.1.1.11 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherBcastDrops
		description 	"The total number of broadcast packets dropped
		to free resources on this ethernet interface."
		characteristics "-N etherBcastDrops -O 1.3.6.1.4.1.166.4.5.1.1.12 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherReceiverRestarts
		description 	"The total number of receiver restarts
		on this ethernet interface."
		characteristics "-N etherReceiverRestarts -O 1.3.6.1.4.1.166.4.5.1.1.13 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherReinterrupts
		description 	"The total number of reinterrupts on this ethernet interface."
		characteristics "-N etherReinterrupts -O 1.3.6.1.4.1.166.4.5.1.1.14 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherBufferReroutes
		description 	"The total number of buffers taken off of queues
		to service incoming packets on this ethernet interface."
		characteristics "-N etherBufferReroutes -O 1.3.6.1.4.1.166.4.5.1.1.15 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherBufferDrops
		description 	"The total number of buffers dropped
		on this ethernet interface."
		characteristics "-N etherBufferDrops -O 1.3.6.1.4.1.166.4.5.1.1.16 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherCollisions
		description 	"The total number of collisions encountered
		on this ethernet interface."
		characteristics "-N etherCollisions -O 1.3.6.1.4.1.166.4.5.1.1.17 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherDefers
		description 	"The total number of deferrals encountered
		on this ethernet interface."
		characteristics "-N etherDefers -O 1.3.6.1.4.1.166.4.5.1.1.18 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherDMAUnderruns
		description 	"The total number of DMA Underruns
		on this ethernet interface."
		characteristics "-N etherDMAUnderruns -O 1.3.6.1.4.1.166.4.5.1.1.19 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherMaxCollisions
		description 	"The total number of packets dropped
		on this ethernet interface because
		they encountered more than 16 collisions."
		characteristics "-N etherMaxCollisions -O 1.3.6.1.4.1.166.4.5.1.1.20 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherNoCarriers
		description 	"The total number of no carrier errors
		experienced on this ethernet interface."
		characteristics "-N etherNoCarriers -O 1.3.6.1.4.1.166.4.5.1.1.21 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherNoCTSs
		description 	"The total number of no CTS errors
		experienced on this ethernet interface."
		characteristics "-N etherNoCTSs -O 1.3.6.1.4.1.166.4.5.1.1.22 -T COUNTER -A RO -X equal -F 0"

		readonly counter	etherNoSQEs
		description 	"The total number of no SQE errors
		experienced on this ethernet interface."
		characteristics "-N etherNoSQEs -O 1.3.6.1.4.1.166.4.5.1.1.23 -T COUNTER -A RO -X equal -F 0"

	)

	group	nwIpx
	description "(null)"
	characteristics "-K NONE"
	(
		readonly counter	ipxInReceives
		description 	"The number of IPX datagrams received on all
		interfaces"
		characteristics "-N ipxInReceives -O 1.3.6.1.4.1.166.4.6.1.1 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxForwDatagrams
		description 	"The number of received IPX datagrams which were not
		addressed directly to the router."
		characteristics "-N ipxForwDatagrams -O 1.3.6.1.4.1.166.4.6.1.2 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxInHdrErrors
		description 	"The number of received IPX datagrams which were
		dropped because of some error in the header, such as a
		protocol length which was inconsistent with the
		data-link length."
		characteristics "-N ipxInHdrErrors -O 1.3.6.1.4.1.166.4.6.1.3 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxInDiscards
		description 	"The number of received IPX datagrams which
		were dropped because of a resource error."
		characteristics "-N ipxInDiscards -O 1.3.6.1.4.1.166.4.6.1.4 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxInDelivers
		description 	"The number of received IPX datagrams delivered to
		protocol agents within the router."
		characteristics "-N ipxInDelivers -O 1.3.6.1.4.1.166.4.6.1.5 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxInUnknownProtos
		description 	"The number of packets which were addressed to the
		node, but for which no protocol handler could be
		found."
		characteristics "-N ipxInUnknownProtos -O 1.3.6.1.4.1.166.4.6.1.6 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxOutRequests
		description 	"The number of IPX datagrams sent on behalf of agents
		in the router."
		characteristics "-N ipxOutRequests -O 1.3.6.1.4.1.166.4.6.1.7 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxOutDiscards
		description 	"The number of packets, whether originating locally or
		remotely, which were not transmitted because of a
		resource error."
		characteristics "-N ipxOutDiscards -O 1.3.6.1.4.1.166.4.6.1.8 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxOutNoRoutes
		description 	"The number of packets, whether originating locally or
		remotely, which were not transmitted because there was
		no known route to the destination network."
		characteristics "-N ipxOutNoRoutes -O 1.3.6.1.4.1.166.4.6.1.9 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxNBForwards
		description 	"The number of NetBIOS wide-area broadcast packets
		forwarded by the router."
		characteristics "-N ipxNBForwards -O 1.3.6.1.4.1.166.4.6.1.10 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ipxTooManyHops
		description 	"The number of packets which were dropped because the
		hop count was greater than or equal to 16."
		characteristics "-N ipxTooManyHops -O 1.3.6.1.4.1.166.4.6.1.11 -T COUNTER -A RO -X equal -F 0"

		readonly int	ipxNumRoutes
		description 	"The number or routes in this entity's IPX Routing table."
		characteristics "-N ipxNumRoutes -O 1.3.6.1.4.1.166.4.6.1.13 -T INTEGER -A RO -X equal -F 0"

	)

	table	ipxRouteTable
	description "This entity's IPX Routing table."
	characteristics "-K ???"
	(
		readonly octet[128]	ipxRouteDest
		description 	"The destination IPX network number of this route."
		characteristics "-N ipxRouteDest -O 1.3.6.1.4.1.166.4.6.1.12.1.1 -T STRING -A RO -X equal -F 0"

		readonly int	ipxRouteNwIfIndex
		description 	"Index of the next hop NetWare interface."
		characteristics "-N ipxRouteNwIfIndex -O 1.3.6.1.4.1.166.4.6.1.12.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	ipxRouteHops
		description 	"The number of intervening routers between the agent
		and the destination network. Directly attached routes
		have a hop count of zero."
		characteristics "-N ipxRouteHops -O 1.3.6.1.4.1.166.4.6.1.12.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly timeticks	ipxRouteTime
		description 	"The approximate round-trip transit time, in
		hundredths of a second, of a 576-byte IPX packet
		destined for this network."
		characteristics "-N ipxRouteTime -O 1.3.6.1.4.1.166.4.6.1.12.1.4 -T TIMETICKS -A RO -X equal -F 0"

		readonly octet[128]	ipxRouteNextHop
		description 	"The IPX node address of the next hop of this
		route.  If the next hop is a directly
		connected net, the value is the agent's node
		address on that net."
		characteristics "-N ipxRouteNextHop -O 1.3.6.1.4.1.166.4.6.1.12.1.5 -T STRING -A RO -X equal -F 0"

		readonly enum ipxRouteTypeE	ipxRouteType
		description 	"The type of the route. Indicates whether the route is
		on a directly attached interface or reached through
		another router."
		characteristics "-N ipxRouteType -O 1.3.6.1.4.1.166.4.6.1.12.1.6 -T INTEGER -A RO -X equal -F 0"

		readonly enum ipxRouteProtoE	ipxRouteProto
		description 	"The routing mechanism by which the route was
		learned."
		characteristics "-N ipxRouteProto -O 1.3.6.1.4.1.166.4.6.1.12.1.7 -T INTEGER -A RO -X equal -F 0"

		readonly int	ipxRouteAge
		description 	"The age of the route in seconds.  Set to zero if the
		route is a direct route."
		characteristics "-N ipxRouteAge -O 1.3.6.1.4.1.166.4.6.1.12.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly counter	ipxRouteUses
		description 	"The number of packets that the entity has sent to
		this network, whether generated internally or
		forwarded on behalf of another node."
		characteristics "-N ipxRouteUses -O 1.3.6.1.4.1.166.4.6.1.12.1.9 -T COUNTER -A RO -X equal -F 0"

	)

	group	nwRip
	description "(null)"
	characteristics "-K NONE"
	(
		readonly counter	ripInMsgs
		description 	"The number of RIP packets received."
		characteristics "-N ripInMsgs -O 1.3.6.1.4.1.166.4.6.2.1 -T COUNTER -A RO -X equal -F 0"

		readonly counter	ripOutMsgs
		description 	"The number of RIP packets transmitted."
		characteristics "-N ripOutMsgs -O 1.3.6.1.4.1.166.4.6.2.2 -T COUNTER -A RO -X equal -F 0"

	)

	group	nwSap
	description "(null)"
	characteristics "-K NONE"
	(
		readonly counter	sapInMsgs
		description 	"The number of SAP packets received."
		characteristics "-N sapInMsgs -O 1.3.6.1.4.1.166.4.6.3.1 -T COUNTER -A RO -X equal -F 0"

		readonly counter	sapOutMsgs
		description 	"The number of SAP packets transmitted."
		characteristics "-N sapOutMsgs -O 1.3.6.1.4.1.166.4.6.3.2 -T COUNTER -A RO -X equal -F 0"

		readonly int	sapNumEntries
		description 	"The number of entries in this entity's SAP table."
		characteristics "-N sapNumEntries -O 1.3.6.1.4.1.166.4.6.3.4 -T INTEGER -A RO -X equal -F 0"

	)

	table	sapTable
	description "This entity's Service Advertising Protocol table."
	characteristics "-K ONE"
	(
		readonly int	sapIndex
		description 	"A unique number indicating this entry's ordinal
		position in the SAP table."
		characteristics "-N sapIndex -O 1.3.6.1.4.1.166.4.6.3.3.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly enum sapTypeE	sapType
		description 	"The device type of the server represented by
		this entry.  This can be any 16-bit integer
		from 1 to 65534."
		characteristics "-N sapType -O 1.3.6.1.4.1.166.4.6.3.3.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly octet[128]	sapNet
		description 	"The IPX network number of the server."
		characteristics "-N sapNet -O 1.3.6.1.4.1.166.4.6.3.3.1.3 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	sapNode
		description 	"The IPX node number of the server."
		characteristics "-N sapNode -O 1.3.6.1.4.1.166.4.6.3.3.1.4 -T STRING -A RO -X equal -F 0"

		readonly int	sapSocket
		description 	"The IPX socket number of the server."
		characteristics "-N sapSocket -O 1.3.6.1.4.1.166.4.6.3.3.1.5 -T INTEGER -A RO -X equal -F 0"

		readonly octet[128]	sapName
		description 	"The name of the server."
		characteristics "-N sapName -O 1.3.6.1.4.1.166.4.6.3.3.1.6 -T STRING -A RO -X equal -F 0"

		readonly int	sapAge
		description 	"The age of this entry in seconds."
		characteristics "-N sapAge -O 1.3.6.1.4.1.166.4.6.3.3.1.7 -T INTEGER -A RO -X equal -F 0"

		readonly int	sapHops
		description 	"The number of networks between this one and
		the server."
		characteristics "-N sapHops -O 1.3.6.1.4.1.166.4.6.3.3.1.8 -T INTEGER -A RO -X equal -F 0"

		readonly int	sapNwIfIndex
		description 	"The NetWare interface on which information
		about this server arrived."
		characteristics "-N sapNwIfIndex -O 1.3.6.1.4.1.166.4.6.3.3.1.9 -T INTEGER -A RO -X equal -F 0"

	)

	group	nwIf
	description "(null)"
	characteristics "-K NONE"
	(
		readonly int	nwifNumber
		description 	"The highest nwifIndex in use."
		characteristics "-N nwifNumber -O 1.3.6.1.4.1.166.4.6.5.1 -T INTEGER -A RO -X equal -F 0"

	)

	table	nwifTable
	description "A list of NetWare interfaces for this entity."
	characteristics "-K ONE"
	(
		readonly int	nwifIndex
		description 	"A unique value for each NetWare Interface.  Its value
		is between 1 and the total number of NetWare
		Interfaces. The value for each interface must remain
		constant at least from the re-initialization of the
		entity's network management system to the next
		re-initialization."
		characteristics "-N nwifIndex -O 1.3.6.1.4.1.166.4.6.5.2.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly string[128]	nwifDescr
		description 	"A text string containing information about the
		interface.  This string is intended for presentation
		to a human; it must not contain anything but printable
		ASCII characters."
		characteristics "-N nwifDescr -O 1.3.6.1.4.1.166.4.6.5.2.1.2 -T STRING -A RO -X equal -F 0"

		readwrite enum nwifTypeE	nwifType
		description 	"The type of interface and encapsulation."
		characteristics "-N nwifType -O 1.3.6.1.4.1.166.4.6.5.2.1.3 -T INTEGER -A RW -X equal -F 0"

		readwrite octet[128]	nwifNetwork
		description 	"IPX network number associated with this interface."
		characteristics "-N nwifNetwork -O 1.3.6.1.4.1.166.4.6.5.2.1.4 -T STRING -A RW -X equal -F 0"

		readwrite octet[128]	nwifNode
		description 	"IPX node number associated with this interface."
		characteristics "-N nwifNode -O 1.3.6.1.4.1.166.4.6.5.2.1.5 -T STRING -A RW -X equal -F 0"

		readwrite enum nwifStatusE	nwifStatus
		description 	"Status of this interface."
		characteristics "-N nwifStatus -O 1.3.6.1.4.1.166.4.6.5.2.1.6 -T INTEGER -A RW -X equal -F 0"

		readwrite int	nwifIfIndex
		description 	"The physical interface associated with this NetWare
		interface.  The interface identified by a particular
		value of this index is the same interface as
		identified by the same value of ifIndex."
		characteristics "-N nwifIfIndex -O 1.3.6.1.4.1.166.4.6.5.2.1.7 -T INTEGER -A RW -X equal -F 0"

		readwrite enum nwifHomeE	nwifHome
		description 	"An indication of whether or not the entity is homed
		on this interface, that is to say, an interface on
		which the entity could perform registrations for
		services that it chooses to advertise."
		characteristics "-N nwifHome -O 1.3.6.1.4.1.166.4.6.5.2.1.8 -T INTEGER -A RW -X equal -F 0"

		readwrite enum nwifNBForwardE	nwifNBForward
		description 	"Indicates whether Novell NetBIOS Wide Area Broadcast
		packets are forwarded out this interface."
		characteristics "-N nwifNBForward -O 1.3.6.1.4.1.166.4.6.5.2.1.9 -T INTEGER -A RW -X equal -F 0"

	)

	group	nwMgmt
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum nwmgmtTypeE	nwmgmtType
		description 	"The device type of the primary network
		management service advertisement."
		characteristics "-N nwmgmtType -O 1.3.6.1.4.1.166.4.6.6.1 -T INTEGER -A RW -X equal -F 0"

		readonly octet[128]	nwmgmtNet
		description 	"The IPX network number of the primary network
		management service advertisement."
		characteristics "-N nwmgmtNet -O 1.3.6.1.4.1.166.4.6.6.2 -T STRING -A RO -X equal -F 0"

		readonly octet[128]	nwmgmtNode
		description 	"The IPX node number of the primary network
		management service advertisement."
		characteristics "-N nwmgmtNode -O 1.3.6.1.4.1.166.4.6.6.3 -T STRING -A RO -X equal -F 0"

		readonly int	nwmgmtSocket
		description 	"The IPX socket number of the primary network
		management service advertisement."
		characteristics "-N nwmgmtSocket -O 1.3.6.1.4.1.166.4.6.6.5 -T INTEGER -A RO -X equal -F 0"

		readonly octet[128]	nwmgmtName
		description 	"The name of the the primary network
		management service advertisement."
		characteristics "-N nwmgmtName -O 1.3.6.1.4.1.166.4.6.6.6 -T STRING -A RO -X equal -F 0"

	)

	group	tNBPFilters
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum tNBPFilterConfigE	tNBPFilterConfig
		description 	"This integer indicates the state of NBP filtering in
		this device, which is either configured or unconfigured.
		Setting this object to 'reinitialize' (3) causes the
		device to reinitialize NBP filtering."
		characteristics "-N tNBPFilterConfig -O 1.3.6.1.4.1.166.4.9.1.1.1 -T INTEGER -A RW -X equal -F 0"

	)

	group	tZoneFilters
	description "(null)"
	characteristics "-K NONE"
	(
		readwrite enum tZoneFilterConfigE	tZoneFilterConfig
		description 	"This integer indicates the state of zone filtering in
		this device, which is either configured or unconfigured.
		Setting this object to 'reinitialize' (3) causes the
		device to reinitialize zone filtering."
		characteristics "-N tZoneFilterConfig -O 1.3.6.1.4.1.166.4.9.1.2.1 -T INTEGER -A RW -X equal -F 0"

	)

	table	tpppPortTable
	description "Table of PPP port initialization parameters and status."
	characteristics "-K ONE"
	(
		readonly int	tpppPortIndex
		description 	"Serial port number which corresponds to an
		instance of rs232PortIndex."
		characteristics "-N tpppPortIndex -O 1.3.6.1.4.1.166.4.10.1.1.1 -T INTEGER -A RO -X equal -F 0"

		readonly int	tpppPortRestartTimer
		description 	"The PPP Restart Timer for this port."
		characteristics "-N tpppPortRestartTimer -O 1.3.6.1.4.1.166.4.10.1.1.2 -T INTEGER -A RO -X equal -F 0"

		readonly int	tpppCompTypes
		description 	"The PPP compression protocols that are available to
		be negotiated for this port, represented as a
		bitmask;
			0x00000001 - Stac LZS
			0x00000002 - Microsoft PPC."
		characteristics "-N tpppCompTypes -O 1.3.6.1.4.1.166.4.10.1.1.3 -T INTEGER -A RO -X equal -F 0"

		readonly int	tpppCompStacPerf
		description 	"The compression effectiveness ratio configured for
		the Stac LZW compression engine for this port.
		Applies to Stac LZS and Microsoft/Stac compression only."
		characteristics "-N tpppCompStacPerf -O 1.3.6.1.4.1.166.4.10.1.1.4 -T INTEGER -A RO -X equal -F 0"

		readonly enum tpppPortStatusE	tpppPortStatus
		description 	"PPP port status."
		characteristics "-N tpppPortStatus -O 1.3.6.1.4.1.166.4.10.1.1.5 -T INTEGER -A RO -X equal -F 0"

	)

agenterrors (
	1	"cannot dispatch request"
	2	"select(2) failed"
	3	"sendto(2) failed"
	4	"recvfrom(2) failed"
	5	"no response from system"
	6	"response too big"
	7	"missing attribute"
	8	"bad attribute type"
	9	"cannot get sysUpTime"
	10	"sysUpTime type bad"
	11	"unknown SNMP error"
	12	"bad variable value"
	13	"variable is read only"
	14	"general error"
	15	"cannot make request PDU"
	16	"cannot make request varbind list"
	17	"cannot parse response PDU"
	18	"request ID - response ID mismatch"
	19	"string contains non-displayable characters"
	20	"cannot open schema file"
	21	"cannot parse schema file"
	22	"cannot open host file"
	23	"cannot parse host file"
	24	"attribute unavailable for set operations"
             )
)


## End of Agent Definitions
